#open "tk";;

let rgb () =
  let fentre_principale = openTk () in

  let crer_glissire nom =
    scale__create fentre_principale
                  [Label nom; From 0.0; To 255.0;
                   Length(Centimeters 10.0); Orient Horizontal] in

  let rouge = crer_glissire "Rouge"
  and vert  = crer_glissire "Vert"
  and bleu  = crer_glissire "Bleu"
  and chantillon =
    frame__create fentre_principale
                  [Height(Centimeters 1.5); Width(Centimeters 6.0)]
  and quitter =
    button__create fentre_principale
                   [Text "Quitter"; Command closeTk] in

  let rafrachir_couleur x =
    let r = int_of_float(scale__get rouge)
    and v = int_of_float(scale__get vert)
    and b = int_of_float(scale__get bleu) in
    let couleur = printf__sprintf "#%02x%02x%02x" r v b in
    frame__configure chantillon [Background (NamedColor couleur)] in

  scale__configure rouge [ScaleCommand rafrachir_couleur];
  scale__configure vert [ScaleCommand rafrachir_couleur];
  scale__configure bleu [ScaleCommand rafrachir_couleur];
  pack [rouge; vert; bleu] [Side Side_Top];
  pack [quitter] [Side Side_Bottom];
  pack [chantillon] [Side Side_Bottom; PadY(Millimeters 2.0)];
  mainLoop ();;

if sys__interactive then () else begin rgb (); exit 0 end;;
