(***********************************************************************)
(*                                                                     *)
(*                               Ledit                                 *)
(*                                                                     *)
(*       Daniel de Rauglaudre, projet Cristal, INRIA Rocquencourt      *)
(*                                                                     *)
(*  Copyright 1997 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* $Id: cursor.ml,v 1.1 2002/12/26 08:46:01 weis Exp $ *)

type 'a t = { mutable before : 'a list; mutable after : 'a list };;

(*exception Failure;;*)

let create () = {before = []; after = []};;

let before c =
  match c.before with
  | [] -> raise Failure
  | x :: l -> c.after <- x :: c.after; c.before <- l
;;

let after c =
  match c.after with
  | [] -> raise Failure
  | x :: l -> c.after <- l; c.before <- x :: c.before
;;

let insert c x = c.before <- x :: c.before;;

let insert_last c x = c.after <- c.after @ [x];;

let normalize c =
  match c.after with
  | _ :: _ -> ()
  | [] -> before c
;;

let peek c =
  normalize c;
  match c.after with
  | x :: _ -> x
  | [] -> raise Failure
;;

let peek_last c =
  let rec peek_rec =
    function
    | [] -> raise Failure
    | [x] -> x
    | _ :: l -> peek_rec l
  in
  normalize c; peek_rec c.after
;;

let rec goto_first c =
  match c.before with
  | [] -> ()
  | x :: l -> c.after <- x :: c.after; c.before <- l; goto_first c
;;

let rec goto_last c =
  match c.after with
  | [] -> ()
  | x :: l -> c.before <- x :: c.before; c.after <- l; goto_last c
;;

let get_all c = c.before @ rev c.after;;
