(***********************************************************************)
(*                                                                     *)
(*                           Caml Light                                *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2000 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

#open "ppm";;
#open "pixmap";;
#open "graphics";;

let wait () =
 print_string "\nPress return to continue"; print_newline ();
 let _ = input_line stdin in
 ();;

let draw_pixels pixels x y =
 let img = graphics__make_image pixels in
 graphics__draw_image img x y;;

let draw_ppm = draw_pixels;;
let load s = load_ppm (filename__concat "ppms" s);;

let clean_string s =
 let x,y = current_point () in
 let w, h = text_size s in
 set_color background;
 fill_rect x y w h;;

let s_x = 800 and s_y = 600;;
open_graph (printf__sprintf " %dx%d" s_x s_y);;

set_color black;;
fill_rect 0 0 s_x s_y;;

let s0 = "fumicamltransp.ppm";;
let ss0 = "Fumi's Caml with transparencies";;
let c0 = green;;

let s1 = "fumicamlascii.pbm";;
let ss1 = "Portable bitmap, ascii encoding";;
let c1 = white;;

let s2 = "fumicamlascii.pgm";;
let ss2 = "Portable greymap, ascii encoding";;
let c2 = red;;

let s3 = "fumicamlascii.ppm";;
let ss3 = "Portable pixmap, ascii encoding";;
let c3 = black;;

let s4 = "fumicaml.pbm";;
let ss4 = "Portable bitmap, raw encoding";;
let c4 = yellow;;

let s5 = "fumicaml.pgm";;
let ss5 = "Portable greymap, raw encoding";;
let c5 = green;;

let s6 = "fumicaml.ppm";;
let ss6 = "Portable pixmap, raw encoding";;
let c6 = black;;

let s7 = "CamlAttitudetransp.ppm";;
let ss7 = "Portable pixmap with transparencies, raw encoding";;
let c7 = blue;;

let vs = [| s1; s2; s3; s4; s5; s6; s0; s7 |];;
let ss = [| ss1; ss2; ss3; ss4; ss5; ss6; ss0; ss7 |];;
let cs = [| c1; c2; c3; c4; c5; c6; c0; c7 |];;

let xfumi, yfumi = 256, 162;;
let xborder, yborder = 2, 2;;

for i = 0 to 7 do
 let ppm = load vs.(i) in
 let xi = i mod 3 in
 let yi = i / 3 in
 let ximg = xi * xfumi + xi * xborder
 and yimg = yi * yfumi + yi * yborder in
 moveto ximg yimg;
 clean_string ss.(i);
 set_color cs.(i);
 draw_string ss.(i); draw_string "...";
 draw_ppm ppm ximg yimg;
 moveto ximg yimg;
 draw_string ss.(i);
done;;

let last_x = 2 * (xfumi + xborder) in
let last_y = 2 * (yfumi + yborder) in
let s = "Fumi's Caml with transparencies..." in
moveto last_x last_y;
clean_string s;
set_color green;
draw_string s;
draw_ppm (load s0) last_x last_y;;

wait();;
