(***********************************************************************)
(*                                                                     *)
(*                           Caml Light                                *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2000 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

#open "ppm";;
#open "pixmap";;

#open "graphics";;

let wait () =
 print_string "\nPress return to continue"; print_newline ();
 let _ = input_line stdin in
 ();;

let draw_ppm ppm = graphics__draw_image (graphics__make_image ppm);;
let load s = load_ppm (filename__concat "ppms" s);;

let sz_x = 768;;
let sz_y = 600;;

open_graph (printf__sprintf " %dx%d" sz_x sz_y);;

set_color black;;
fill_rect 0 0 sz_x sz_y;;

let s1 = "fumicaml.ppm";;
let s2 = "praxi.ppm";;

let x = 0 and y = 0;;

let load_and_draw s x y =
 let ppm = load s in
 draw_ppm ppm x y;
 ppm;;

let ppm1 = load_and_draw s1 x y;;
print_string "FumiCaml loaded and drawn."; print_newline (); wait();;

let ppm2 = load_and_draw s2 (x + 260) y;;
print_string "Praxi cab loaded and drawn."; print_newline (); wait();;

let draw_bitmap ts tb ppm x y =
 let bitmap = bitmap_of_pixmap ts tb ppm in
 draw_ppm bitmap x y;;

draw_bitmap 220 220 ppm1 0 180;;
print_string "Bitmap FumiCaml drawn."; print_newline (); wait();;

let f ts tb =
 draw_bitmap ts tb ppm2 500 180;
 draw_bitmap ts tb ppm1 0 180
;;

let input_int () =
 let s = input_line stdin in
 try int_of_string s with Failure _ -> 0;;

(*
List.map
 (function x, y ->
  f x y;
  print_string "Sat : "; print_int x;
  print_string " Bri : "; print_int y;
  print_newline(); flush std_out;
  wait ())
 [
  0,210;
  10,210;
  20,210;
  40,210;
  80,210;
  128,210;
  10,160;
  20,160;
  40,160;
  80,160;
  128,160;
  10,140;
  20,140;
  40,140;
  80,140;
  128,140;
  10,100;
  20,100;
  40,100;
  80,100;
  128,100;
  10,80;
  20,80;
  40,80;
  80,80;
  128,80;
];;
*)
map
 (function x, y ->
  f x y;
  print_string "Sat : "; print_int x;
  print_string " Bri : "; print_int y;
  print_newline();
  wait ())
 [
(* 50,100;
  50,150;
  50,160;
  50,180;
  50,190;
  50,200;
  50,220;
  50,240;
  50,245;
  50,250;
  50,255;
  80,100;
  80,150;
  80,160;
  80,180;
  80,190;
  80,200;
  80,220;
  80,240;
  80,245;
  80,250;
  80,255;
  100,100;
  100,150;
  100,160;
  100,180;
  100,190;
  100,200;
  100,220;
  100,240;
  100,245;
  100,250;
  100,255;
  0,210;
  10,210;
  15,210; *)
  128, 160;
  160, 160;
  210, 210; (*
  25,210;
  30,210;
  35,210;
  40,210;
  45,210;
  50,210;
  100,210;
  150,210;
  210,210;
  0,160;
  10,160;
  15,160;
  20,160;
  25,160;
  30,160;
  35,160;
  40,160;
  45,160;
  50,160;
  0,140;
  10,140;
  15,140;
  20,140;
  25,140;
  30,140;
  35,140;
  40,140;
  45,140;
  50,140;*)
];;
