(***********************************************************************)
(*                                                                     *)
(*                           Caml Light                                *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2000 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

#open "ppm";;
#open "graphics";;

let load_ppm_file s = load_ppm (filename__concat "ppms" s);;
let save_ppm_file s ppm = save_ppm (filename__concat "ppms" s) ppm;;
let save_bitmap_file s ppm = save_bitmap (filename__concat "ppms" s) ppm;;

let draw_pixmap pixmap = graphics__draw_image (graphics__make_image pixmap);;

let wait () =
 print_string "\nPress return to continue"; flush std_out;
 let _ = input_line stdin in
 ();;

let print_and_wait s =
 print_string s; print_newline (); wait ();;

let sz_x = 600;;
let sz_y = 450;;

open_graph (printf__sprintf " %dx%d" sz_x sz_y);;

set_color black;;
fill_rect 0 0 600 450;;

let fumi_pixmap = load_ppm_file "fumicaml.ppm";;

let x = 0 and y = 0;;

draw_pixmap fumi_pixmap x y;;

print_string "FumiCaml loaded and drawn."; print_newline ();;

let make_transp img =
 let l = vect_length img in
 if l = 0 then invalid_arg "make_transp" else
 let c = vect_length img.(0) in
 let res = vect__make_matrix l c 0 in
 for i = 0 to l - 1 do
  let line = img.(i) in
  let res_line = res.(i) in
  for j = 0 to c - 1 do
    let res_color =
      let color = line.(j) in
      if color = white then transp else color in
    res_line.(j) <- res_color    
  done
 done;
 res;;

let pixmap_transp = make_transp fumi_pixmap;;

print_string "Transparent image built ..."; flush stdout;;

draw_pixmap pixmap_transp 300 210;;

print_and_wait " and drawn.";;

save_ppm_file "test_transp.ppm" pixmap_transp;;

print_string "Transparent image saved ..."; flush stdout;;

let new_pixmap_transp = load_ppm_file "test_transp.ppm";;

print_string " loaded ..."; flush stdout;;

draw_pixmap new_pixmap_transp 0 210;;

print_and_wait " and drawn.";;

save_bitmap_file "test_bitmap.ppm" fumi_pixmap;;

print_string "Bitmap image saved ..."; flush stdout;;

let read_bitmap = load_ppm_file;;

let bitmap = read_bitmap "test_bitmap.ppm";;

print_string " loaded ..."; flush stdout;;

draw_pixmap bitmap 300 0;;

print_and_wait " and drawn.";;

print_string "Drawing complementary image..."; flush std_out;
draw_pixmap new_pixmap_transp 300 0;;

print_string "Complementary image drawn."; print_newline();;

let bitmap_transp = make_transp bitmap;;

let f c =
 set_color c;
 fill_rect 0 210 256 162;
 fill_rect 300 0 256 162;

 draw_pixmap new_pixmap_transp 0 210;

 draw_pixmap bitmap_transp 300 0;

 wait ();;

list__do_list f [rgb 0 255 255; red; green; blue; yellow; cyan; black; white];;
