(***********************************************************************)
(*                                                                     *)
(*                           Caml Light                                *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

#open "graphics";;

#open "bmp";;
#open "grimage";;

let draw_bmp = draw_grimage;;
let load_bmp_file s = load_grimage (filename__concat "bmps" s);;
let save_bmp_file s bmp = save_grimage (filename__concat "bmps" s) bmp;;

let message s = print_string s; print_newline ();;

let wait () =
 message "\nPress return to continue";
 let _ = input_line stdin in
 ();;

let sz = 800;;
let sz_x = sz;;
let sz_y = sz - 100;;

open_graph (printf__sprintf " %dx%d" sz_x sz_y);;

let to_next_image, reset_to_next_image =
  let step_y = ref 0 in
  let next_x = ref 0 in
  (fun grim x y ->
     let new_x = !next_x + grim.grimage__width in
     if new_x <= sz_x then begin
       x := !next_x;
       next_x := new_x;
       step_y := max grim.grimage__height !step_y;
       end     
     else begin
       x := 0;
       next_x := grim.grimage__width;
       y := !y + !step_y;
       step_y := grim.grimage__height
     end;
     moveto !x !y),
  (fun () -> step_y := 0; next_x := 0);;

let draw_grimage_and_move grim x y =
 to_next_image grim x y;
 draw_grimage grim !x !y;;

let load_and_draw_bmp_list x y l =
 let load_and_draw s =
  let grim = load_bmp_file s in
  draw_grimage_and_move grim x y in
 do_list load_and_draw l;;

let main_load () =
 let x = ref 0 and y = ref 0 in
 reset_to_next_image ();
 load_and_draw_bmp_list x y
  ["CamlBook.bmp"; "ApprocheBook.bmp"; "FuncApproach.bmp"; "SpeBook.bmp";
    "exercices-algo.bmp"; "JoeCaml.bmp"; "SupBook.bmp";
    "seize.bmp"; "CamlRef.bmp"; "OReillyBook.bmp"; "WolffBook.bmp";
    "CnamBook.bmp"; "RouableBook.bmp"; "albertbook.bmp";
    "JoeCaml.bmp"; "JoeCaml.bmp"; "JoeCaml.bmp"; "JoeCaml.bmp";
    "JoeCaml.bmp"; "JoeCaml.bmp"; "JoeCaml.bmp"; "JoeCaml.bmp";
    "JoeCaml.bmp"; "JoeCaml.bmp"; "JoeCaml.bmp";
  ];;


let main_save () =
 message "getting graphics image ...";
 let img = graphics__get_image 40 50 150 150 in
 
 message "translating it into grimage ...";
 let bmp = grimage_of_image img in
 message "saving this grimage as a bmp ...";
 save_bmp_file "test.bmp" bmp;
 let x = ref 0 and y = ref 0 in
 message "loading and drawing it repeatedly ...";
 reset_to_next_image ();
 for i = 0 to 12 do
  load_and_draw_bmp_list x y
   ["test.bmp"; "test.bmp"]
 done;;

let main () =
  main_load (); wait ();
  main_save (); wait ();;

main ();;
