(***********************************************************************)
(*                                                                     *)
(*                           Caml Light                                *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2000 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

(* Extra graphics functions primitives: handling pixels and pixmaps,
 and hsb and rgb encodings of colors. *)

type pixmap == graphics__color vect vect;;
 (* Pixmap are represented as matrix of colors. *)

value draw_pixmap : pixmap -> int -> int -> unit;;
 (* [draw_pixmap pixmap x y] draw the given color matrix into the
    graphics window with lower left corner at the given point. *) 

value bitmap_of_pixmap : int -> int -> pixmap -> pixmap;;
 (* [bitmap_of_pixmap ts tb pixmap] Maps a matrix of colors into a
    bitmap represented as a new matrix of black or white
    colors. Arguments [ts] and [tb] are tresholds to decide whether to
    produce a black or white pixel from a pixel of a given color: both
    [ts] and [tb] are integers in the range [0 .. 255]; [ts] is the
    saturation threshold and if the saturation of the pixel color is
    greater than [ts] then the pixel is assumed to be [white]; [tb] is
    the brightness threshold and if the brightness of the pixel color
    is greater than [ts] then the pixel is assumed to be [white]. The
    correct values of [ts] and [tb] highly depend on the image at
    hand, but [ts = 20] and [tb = 210] often give good results. *)

value set_background_transp : pixmap -> unit;;
 (* Set to transparent the pixels of a pixmap whose color is the
    background color. In some sense this function embosses a pixmap
    image. *)
