(***********************************************************************)
(*                                                                     *)
(*                           Caml Light                                *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  en Automatique.  Distributed only by permission.                   *)
(*                                                                     *)
(***********************************************************************)

#open "graphics";;
#open "color";;

let draw_pixmap pixmap x y =
 let img = make_image pixmap in
 draw_image img x y;;

let pixel_is_set ts tb c =
 let h, s, b = hsb_of_color c in
 s >= ts || b >= tb;;

let bitmap_of_pixmap ts tb px =
 let l = vect_length px in
 if l = 0 then invalid_arg "make_transp" else
 let c = vect_length px.(0) in
 let res = vect__make_matrix l c 0 in
 for i = 0 to l - 1 do
  let line = px.(i) in
  let res_line = res.(i) in
  for j = 0 to c - 1 do
   let res_color =
    let color = line.(j) in
    if pixel_is_set ts tb color then white else black in
   res_line.(j) <- res_color    
  done
 done;
 res;;

(* Set pixels of an image which have background color to transparent color. *)
let set_background_transp px =
 let l = vect_length px in
 if l = 0 then invalid_arg "set_background_transp" else
 let c = vect_length px.(0) in
 for i = 0 to l - 1 do
  let line = px.(i) in
  for j = 0 to c - 1 do
   if line.(j) = background then line.(j) <- transp
  done
 done;;

