(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* Color manipulations. *)

value color_of_rgb : int -> int -> int -> graphics__color;;
 (* [color_of_rgb r g b] returns the integer encoding the color with red
    component [r], green component [g], and blue component
   [b]. *)

value red_of_color : graphics__color -> int;;
value green_of_color : graphics__color -> int;;
value blue_of_color : graphics__color -> int;;
value rgb_of_color : graphics__color -> int * int * int;;
 (* Decomposition of a color into its red, green, blue components. *)

value hsb_of_color : graphics__color -> int * int * int;;
 (* Decomposition of a color specified by its H (hue), S (saturation),
    and B (brightness) components. Hue is the wavelength within the
    visible-light spectrum at which the energy output from a source of
    this color is greatest. Sauration measures the purity of colors:
    high saturation means a pure color, low saturation means a faint color.
    Brightness (also called brilliance) is the maximum of the RGB
    components of the color.
 *)
value hsb_of_rgb : int -> int -> int -> int * int * int;;
value rgb_of_hsb : int -> int -> int -> int * int * int;;
 (* Mappings from HSB to RGB representations of colors. [hsb_of_rgb]
    and [rgb_of_hsb] are not strictly reciprocal, due to limit
    conditions, where some components are undefined and arbitrarily
    set to 0. *)

