(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Pierre Weis, projet Cristal, INRIA Rocquencourt          *)
(*                                                                     *)
(*  Copyright 2001 Institut National de Recherche en Informatique et   *)
(*  Automatique.  Distributed only by permission.                      *)
(*                                                                     *)
(***********************************************************************)

(* Color manipulations. *)

(* Extra graphics functions primitives. *)
let nround x y = (2 * x + y) / (2 * y);;
let mxround x = nround (0xFF * x) 0xFF;;

let hsb_of_rgb r g b =
 let bri = max r (max g b)
 and min = min r (min g b) in
 let d = bri - min in
 let sat = if bri = 0 then 0 else nround (0xFF * d) bri in
 let hue =
  if bri = 0 || d = 0 then 0 else
  let r' = (bri - r) * 0xFF / d
  and g' = (bri - g) * 0xFF / d
  and b' = (bri - b) * 0xFF / d in
  let h =
   if bri = r then if min = g then 5 * 0xFF + b' else 0xFF - g' else
   if bri = g then if min = b then 0xFF + r' else 3 * 0xFF - b' else
   if min = r then 3 * 0xFF + g' else 5 * 0xFF - r' in
  h / 6 in
 hue, sat, bri;;

let rgb_of_hsb h s b =
 let h = h * 6 in
 let i = h / 0xFF * 0xFF in
 let f = h - i in
 let m = b * (0xFF - s) / 0xFF and n = b * (0xFF - s * f / 0xFF) / 0xFF
 and k = b * (0xFF - s * (0xFF - f) / 0xFF) / 0xFF in
 match i / 0xFF with
 | 0 | 6 -> mxround b, mxround k, mxround m
 | 1 -> mxround n, mxround b, mxround m
 | 2 -> mxround m, mxround b, mxround k
 | 3 -> mxround m, mxround n, mxround b
 | 4 -> mxround k, mxround m, mxround b
 | 5 -> mxround b, mxround m, mxround n
 | _ -> invalid_arg "rgb_of_hsb";;

let color_of_rgb r g b = (r lsl 16) + (g lsl 8) + b;;

let red_of_color c = (c lsr 16) land 0xFF;;
let green_of_color c = (c lsr 8) land 0xFF;;
let blue_of_color c = c land 0xFF;;

let rgb_of_color c = (c lsr 16) land 0xFF, (c lsr 8) land 0xFF, c land 0xFF;;

let hsb_of_color c =
 hsb_of_rgb ((c lsr 16) land 0xFF) ((c lsr 8) land 0xFF) (c land 0xFF);;

