(* tree.mli *)

type ident == string;;

type op = 
    Plus | Minus | Times | Divide 
  | Less | LessEq | Equal | Neq | GreaterEq | Greater;;

type expr = 
    Const of int
  | Name of string
  | Binop of op * expr * expr;;

type param = Val of expr | Ref of ident;;

type stmt =
    Skip
  | Assign of ident * expr
  | Call of ident * param list
  | If of expr * stmt list * stmt list
  | While of expr * stmt list
  | Print of expr list;;

type block = Block of ident list * proc list * stmt list

and proc = Proc of ident * ident list * block;;

type prog = Program of block;;
