/* parser.mly */

%token<string>	IDENT
%token<int>	NUM
%token		PLUS MINUS TIMES DIVIDE LPAR RPAR 
%token		LESS LEQ EQUAL NEQ GREATER GEQ
%token		COMMA SEMI ASSIGN EOF

%token		BEGIN END VAR PRINT IF THEN ELSE WHILE DO PROC REF

%nonassoc	ERROR
%nonassoc	LESS LEQ EQUAL NEQ GREATER GEQ
%left		PLUS MINUS
%left		TIMES DIVIDE
%nonassoc	RPAR

%start		program
%type<tree__prog> program

%{
#open "tree";;

let yyerror s =
  print_string s;
  print_string " on line ";
  print_int !lexer__lineno;
  print_newline ();
  flush stdout;;
%}

%%

program :
    block EOF				{ Program $1 } ;

block :
    var_decl proc_decls BEGIN stmts END  { Block ($1, $2, $4) } ;

var_decl :
    /* empty */				{ [] }
  | VAR ident_list SEMI			{ $2 } ;

ident_list :
    IDENT				{ [$1] }
  | IDENT COMMA ident_list		{ $1::$3 } ;

proc_decls :
    /* empty */				{ [] }
  | proc_decl proc_decls		{ $1::$2 } ;

proc_decl :
    PROC IDENT formals SEMI block SEMI	{ Proc ($2, $3, $5) } ;

formals :
    LPAR RPAR				{ [] } ;
  | LPAR ident_list RPAR		{ $2 } ;

stmts :
    stmt				{ [$1] }
  | stmt SEMI stmts			{ $1::$3 } ;

stmt :
    /* empty */				{ Skip }
  | IDENT ASSIGN expr			{ Assign ($1, $3) }
  | IDENT actuals			{ Call ($1, $2) }
  | IF expr THEN stmts END		{ If ($2, $4, []) }
  | IF expr THEN stmts ELSE stmts END	{ If ($2, $4, $6) }
  | WHILE expr DO stmts END		{ While ($2, $4) }
  | PRINT expr_list			{ Print $2 } 
  | error				{ Skip } ;

actuals :
    LPAR RPAR				{ [] }
  | LPAR param_list RPAR		{ $2 } ;

param_list :
    param				{ [$1] }
  | param COMMA param_list		{ $1::$3 } ;

param :
    expr				{ Val $1 }
  | REF IDENT				{ Ref $2 } ;

expr_list :
    expr				{ [$1] }
  | expr COMMA expr_list		{ $1::$3 } ;

expr :
    NUM					{ Const $1 } 
  | IDENT				{ Name $1 }
  | expr PLUS expr			{ Binop (Plus, $1, $3) }
  | expr MINUS expr			{ Binop (Minus, $1, $3) }
  | expr TIMES expr			{ Binop (Times, $1, $3) }
  | expr DIVIDE expr			{ Binop (Divide, $1, $3) }
  | expr LESS expr			{ Binop (Less, $1, $3) }
  | expr LEQ expr			{ Binop (LessEq, $1, $3) } 
  | expr EQUAL expr			{ Binop (Equal, $1, $3) } 
  | expr NEQ expr			{ Binop (Neq, $1, $3) } 
  | expr GREATER expr			{ Binop (Greater, $1, $3) } 
  | expr GEQ expr			{ Binop (GreaterEq, $1, $3) }
  | LPAR expr RPAR			{ $2 } 
  | LPAR expr %prec ERROR		{ yyerror "missing ')'";
					  raise Parse_error } ;
