#open "windows";;
#open "camlwin";;


let dwin_width = 150;;
let dwin_height = 120;;


let cfg_win_def =
{
  win_left     = (screen_width() - (gr_to_real_coord dwin_width))/2;
  win_top      = (screen_height() + (gr_to_real_coord dwin_height))/2;
  win_width    = dwin_width;
  win_height   = dwin_height;
  win_id       = gr_undef_window;
  win_name     = "Window Configuration";
  win_state    = Destroyed
};;

let cwin_pt_title =
{
  expt_window   = cfg_win_def;
  expt_left     = 36;
  expt_top      = dwin_height - 5;
  expt_name     = { f_type=Proportional_font; f_att =Italic; 
                    f_size =Size1_font; f_color =black; 
                    f_string = "Window Configuration"}
};;

let cwin_pt_width =
{
  pt_window   = cfg_win_def;
  pt_left     = 5;
  pt_top      = dwin_height - 20;
  pt_name     = "Width:"
};;

let cwin_pt_height =
{
  pt_window   = cfg_win_def;
  pt_left     = 5;
  pt_top      = dwin_height - 31;
  pt_name     = "Height:"
};;

let cwin_pt_name =
{
  pt_window   = cfg_win_def;
  pt_left     = 5;
  pt_top      = dwin_height - 42;
  pt_name     = "Id Name:"
};;

let cwin_pt_help =
{
  pt_window   = cfg_win_def;
  pt_left     = 5;
  pt_top      = dwin_height - 60;
  pt_name     = "Help file:"
};;

let cwin_pt_time =
{
  pt_window   = cfg_win_def;
  pt_left     = 5;
  pt_top      = dwin_height - 71;
  pt_name     = "Time Callback:"
};;

let cwin_name =
{
  st_window   = cfg_win_def;
  st_left     = 37;
  st_top      = cwin_pt_name.pt_top + 2;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cwin_height =
{
  st_window   = cfg_win_def;
  st_left     = 37;
  st_top      = cwin_pt_height.pt_top + 2;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_natural;
  st_callback = gr_do_nothing
};;

let cwin_width =
{
  st_window   = cfg_win_def;
  st_left     = 37;
  st_top      = cwin_pt_width.pt_top + 2;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_natural;
  st_callback = gr_do_nothing
};;

let cwin_time =
{
  st_window   = cfg_win_def;
  st_left     = 37;
  st_top      = cwin_pt_time.pt_top + 2;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "gr_do_nothing";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cwin_help =
{
  st_window   = cfg_win_def;
  st_left     = 37;
  st_top      = cwin_pt_help.pt_top + 2;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cwin_timecallback =
{
  bt_window   = cfg_win_def;
  bt_left     = 120;
  bt_top      = 46;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let cwin_cancel =
{
  bt_window   = cfg_win_def;
  bt_left     = 92;
  bt_top      = 27;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let cwin_helpbar =
{
  hl_window   = cfg_win_def;
  hl_help     = "Press Ok when finished"
};;

let cwin_ok =
{
  bt_window   = cfg_win_def;
  bt_left     = 31;
  bt_top      = 27;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let cfg_win =
{
  win_def      = cfg_win_def;
  win_objects  = [
                  g_prompt cwin_pt_name;
                  g_prompt cwin_pt_height;
                  g_prompt cwin_pt_width;
                  g_prompt cwin_pt_time;
                  g_prompt cwin_pt_help;
                  g_button cwin_timecallback;
                  g_string cwin_time;
                  g_string cwin_help;
                  g_string cwin_name;
                  g_string cwin_width;
                  g_string cwin_height;
                  g_exprompt cwin_pt_title;
                  g_button cwin_cancel;
                  g_helpbar cwin_helpbar;
                  g_button cwin_ok
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let win_width = ref 0;;
let win_height = ref 0;;
let win_name = ref "";;
let win_erase = ref false;;


let win_init Width Height Name =
  win_width := Width;
  win_height := Height;
  win_name := Name;
  cwin_name.st_cursor <-0;
  cwin_width.st_cursor <-0;
  cwin_height.st_cursor <-0;
  cwin_name.st_1st_char <-0;
  cwin_width.st_1st_char <-0;
  cwin_height.st_1st_char <-0;
  cwin_width.st_name <- string_of_int Width;
  cwin_height.st_name <- string_of_int Height;
  cwin_name.st_name <- Name
;;


let win_restore () =
  cwin_width.st_name <- string_of_int !win_width;
  cwin_height.st_name <- string_of_int !win_height;
  cwin_name.st_name <- !win_name
;;



let CancelWinCfg Obj Event =
  win_erase := false;
  win_restore ();
  gr_erase_window cfg_win.win_def
;;

let OkWinCfg Obj Event =
  win_erase := true;
  gr_erase_window cfg_win.win_def
;;


cwin_ok.bt_callback <- OkWinCfg;;
cwin_cancel.bt_callback <- CancelWinCfg
;;


