#open "camlwin";;
#open "sys";;

#open "camlhelp";;

let H1_nu = ref 0
and H2_nu = ref 0
and H3_nu = ref 0
and H4_nu = ref 0
and H5_nu = ref 0
and H6_nu = ref 0
;;

let TitleList = ref [H1 []];;
TitleList := [];;

let make_number HTML =
  match HTML with
    H1 title -> 
           H1_nu := !H1_nu + 1;
           H2_nu := 0;
           H3_nu := 0;
           H4_nu := 0;
           H5_nu := 0;
           H6_nu := 0;
           (string_of_int !H1_nu) ^ ") "
  | H2 title -> 
           H2_nu := !H2_nu + 1;
           H3_nu := 0;
           H4_nu := 0;
           H5_nu := 0;
           H6_nu := 0;
           (string_of_int !H1_nu) ^ "." ^ (string_of_int !H2_nu) ^ ") "
  | H3 title -> 
           H3_nu := !H3_nu + 1;
           H4_nu := 0;
           H5_nu := 0;
           H6_nu := 0;
           (string_of_int !H1_nu) ^ "." ^ (string_of_int !H2_nu) ^ "." ^
           (string_of_int !H3_nu) ^ ") "
  | H4 title -> 
           H4_nu := !H4_nu + 1;
           H5_nu := 0;
           H6_nu := 0;
           (string_of_int !H1_nu) ^ "." ^ (string_of_int !H2_nu) ^ "." ^
           (string_of_int !H3_nu) ^ "." ^ (string_of_int !H4_nu) ^ ") "
  | H5 title -> 
           H5_nu := !H5_nu + 1;
           H6_nu := 0;
           (string_of_int !H1_nu) ^ "." ^ (string_of_int !H2_nu) ^ "." ^
           (string_of_int !H3_nu) ^ "." ^ (string_of_int !H4_nu) ^ "." ^
           (string_of_int !H5_nu) ^ ") "
  | H6 title -> 
           H6_nu := !H6_nu + 1;
           (string_of_int !H1_nu) ^ "." ^ (string_of_int !H2_nu) ^ "." ^
           (string_of_int !H3_nu) ^ "." ^ (string_of_int !H4_nu) ^ "." ^
           (string_of_int !H5_nu) ^ "." ^ (string_of_int !H6_nu) ^ ") "
  | _ -> ""
;;

let skip_number str =
  let len = string_length str in
    let rec loop pos =
      if pos = len
      then len
      else 
      (
        match nth_char str pos with
         `0`..`9` -> loop (pos+1)
        | `.`    -> loop (pos+1) 
        | ` `    -> loop (pos+1)
        | `)`    -> loop (pos+1)
        | _      -> pos
      )
    in
   let pos = loop 0 in
     sub_string str pos (len-pos)
;;


let parse_title title TitleType=
  let rec loop title return =
    match title with
      [] -> return
    | x::y -> 
      (
        match x with
          HtmlText str -> 
             return @ 
             (HtmlText ((make_number TitleType) ^ (skip_number str)) :: y) 
        | ANCHOR anchor -> 
             anchor.AnchorName <- skip_number anchor.AnchorName;
             return @ (HtmlText (make_number TitleType):: ANCHOR anchor :: y)
        | _ -> loop y (return @ [x])
      )
  in
  loop title []
;;


let parse_anchor title FileName=
  let rec loop title return =
    match title with
      [] -> return
    | x::y -> 
      (
        match x with
          ANCHOR anchor -> 
             if anchor.AnchorType = NAME
             then
             (
               anchor.AnchorType <- HREF;
               anchor.AnchorFile <- FileName ^ "#" ^ anchor.AnchorFile
             );
             loop y (return @ [x])
        | _ -> loop y (return @ [x])
      )
  in
     loop title []
;;
 


let rec NumberTitle html return FileName =
  match html with 
    [] -> return
  | x::y -> 
     let new = 
        match x with
          H1 title -> 
               let res = parse_title title x in
                 TitleList := H1 (parse_anchor res FileName):: !TitleList;
                 H1 res
        | H2 title ->  
               let res = parse_title title x in
                 TitleList := H2 (parse_anchor res FileName):: !TitleList;
                 H2 res
        | H3 title ->  
               let res = parse_title title x in
                 TitleList := H3 (parse_anchor res FileName):: !TitleList;
                 H3 res
        | H4 title ->  
               let res = parse_title title x in
                 TitleList := H4 (parse_anchor res FileName):: !TitleList;
                 H4 res
        | H5 title ->  
               let res = parse_title title x in
                 TitleList := H5 (parse_anchor res FileName):: !TitleList;
                 H5 res
        | H6 title ->  
               let res = parse_title title x in
                 TitleList := H6 (parse_anchor res FileName):: !TitleList;
                 H6 res
        | _        -> x
      in
        NumberTitle y (return @ [ new ]) FileName
;;



let list_H = ref [| [LI []] |];;
list_H := [| []; []; []; []; []; []; [] |];;

let add_title_list p_level n_level title =
  if n_level < p_level
  then
  (
    for i= 0 to p_level-n_level-1 do
      if !list_H.(p_level-i) = []
      then ()
      else 
      (
        !list_H.(p_level-i-1) <- !list_H.(p_level-i-1) @ 
                                 [UList !list_H.(p_level-i)]; 
        !list_H.(p_level-i) <- []
      )
    done
  );
  if not n_level = 0 
  then !list_H.(n_level) <- !list_H.(n_level) @ [LI title]
;;




let Transformtitle () =
  let rec loop arg p_level =
    match arg with
      [] -> add_title_list p_level 0 []
    | x::y -> 
      (
         match x with
           H1 title -> 
                add_title_list p_level 1 title;
                loop y 1
         | H2 title ->  
                add_title_list p_level 2 title;
                loop y 2
         | H3 title ->  
                add_title_list p_level 3 title;
                loop y 3
         | H4 title ->  
                add_title_list p_level 4 title;
                loop y 4 
         | H5 title ->  
                add_title_list p_level 5 title;
                loop y 5 
         | H6 title ->  
                add_title_list p_level 6 title;
                loop y 6 
         | _        -> loop y p_level 
       )
  in
    loop (rev !TitleList) 0;
    TitleList := !list_H.(0)
;;


let CompileListTitle vectFile =
  let len = vect_length vectFile in
    for i = 3 to (len -1) do
     (
       print_string ("Update Title Number: " ^ vectFile.(i));
       print_newline ();
       let file = open_in vectFile.(i) in
         let html = gr_html_interpreter file in
           let result = NumberTitle html [] vectFile.(i) in
       close_in file;
       let file = open_out vectFile.(i) in
         gr_html_save result file;
       close_out file
     )
     done;
     Transformtitle ();
     print_string ("Write table of contents in: " ^ 
                  (gr_without_suffix vectFile.(2)) ^ ".html");
     print_newline();
     let file = open_out ((gr_without_suffix vectFile.(2)) ^ ".html") in
       gr_html_save !TitleList file;
       close_out file
;;



