#open "windows";;
#open "camlwin";;


#open "globdraw";;


let text_cfg_def = 
{
  win_left     = 20;
  win_top      = 200;
  win_width    = 150;
  win_height   = 90;
  win_id       = gr_undef_window;
  win_name     = "Text Configuration";
  win_state    = Destroyed
};;

let name_prompt =
{
  pt_window   = text_cfg_def;
  pt_left     = 5;
  pt_top      = 67;
  pt_name     = "Id name:"
};;

let text_title =
{
  pt_window   = text_cfg_def;
  pt_left     = 39;
  pt_top      = 86;
  pt_name     = "Text Configuration"
};;

let text_vertical =
{
  ra_window   = text_cfg_def;
  ra_left     = 15;
  ra_top      = 52;
  ra_state    = true;
  ra_name     = "Vertical scrollbar  ";
  ra_callback = gr_do_nothing
};;

let text_horizontal =
{
  ra_window   = text_cfg_def;
  ra_left     = 15;
  ra_top      = 43;
  ra_state    = false;
  ra_name     = "Horizontal scrollbar";
  ra_callback = gr_do_nothing
};;

let text_editable =
{ 
  ga_window = text_cfg_def;
  ga_top = 54;
  ga_left = 75;
  ga_width = 50;
  ga_height = 19;
  ga_delta = 3;
  ga_radio = 0;
  ga_name = [| "Editable"; "View only"|];
  ga_callback = gr_do_nothing
};;

let text_cancel =
{
  bt_window   = text_cfg_def;
  bt_left     = 81;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let text_idname =
{
  st_window   = text_cfg_def;
  st_left     = 37;
  st_top      = 70;
  st_width    = 72;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let text_ok =
{
  bt_window   = text_cfg_def;
  bt_left     = 38;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let text_help =
{
  hl_window   = text_cfg_def;
  hl_help     = "Press Ok when finished"
};;

let cfg_text =
{
  win_def      = text_cfg_def;
  win_objects  = [
                  g_prompt    name_prompt;
                  g_prompt    text_title;
                  g_radio     text_vertical;
                  g_radio     text_horizontal;
                  g_grprad    text_editable;
                  g_button    text_cancel;
                  g_string    text_idname;
                  g_button    text_ok;
                  g_helpbar   text_help
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let text_get_scro () =
  match ( text_vertical.ra_state, text_horizontal.ra_state) with
    (true, true)   -> Dscroll
  | (true, false)  -> Vscroll
  | (false, false) -> Noscroll
  | _              -> Noscroll
;;

let text_cfg_scro Scro =
  match Scro with
    Noscroll -> text_vertical.ra_state <- false;
                text_horizontal.ra_state <- false
  | Vscroll  -> text_vertical.ra_state <- true;
                text_horizontal.ra_state <- false
  | Dscroll  -> text_vertical.ra_state <- true;
                text_horizontal.ra_state <- true
;;


let text_get_editable () =
  match text_editable.ga_radio with
    0 -> Editable
  | _ -> View_only
;;

let text_init_editable State =
  match State with
    View_only -> text_editable.ga_radio <- 1
  | _         -> text_editable.ga_radio <- 0
;;



let text_id = ref "";;
let text_scro = ref Noscroll;;
let text_ed = ref Editable;;

let text_init Id Scroll State =
  text_id := Id;
  text_scro := Scroll;
  text_ed := State;
  text_idname.st_cursor <-0;
  text_idname.st_1st_char <-0;
  text_idname.st_name <- Id;
  text_cfg_scro Scroll;
  text_init_editable State
;;


let text_restore () =
  text_idname.st_name <- !text_id;
  text_cfg_scro !text_scro;
  text_init_editable !text_ed
;;


let CloseTextCfg Obj  Event =
  gr_erase_window cfg_text.win_def
;;

let CancelTextCfg Obj Event =
  text_restore ();
  gr_erase_window cfg_text.win_def
;;

text_ok.bt_callback <- CloseTextCfg;;
text_cancel.bt_callback <- CancelTextCfg;;


