#open "windows";;
#open "camlwin";;


#open "funcdraw";;



let cfg_string_def = 
{
  win_left     = 20;
  win_top      = 300;
  win_width    = 150;
  win_height   = 150;
  win_id       = gr_undef_window;
  win_name     = "String Configuration";
  win_state    = Destroyed
};;

let edit_string =
{
  bt_window   = cfg_string_def;
  bt_left     = 121;
  bt_top      = 95;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let str_string =
{
  st_window   = cfg_string_def;
  st_left     = 42;
  st_top      = 111;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let str_callback =
{
  st_window   = cfg_string_def;
  st_left     = 42;
  st_top      = 94;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let str_idname =
{
  st_window   = cfg_string_def;
  st_left     = 42;
  st_top      = 128;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cancel_string =
{
  bt_window   = cfg_string_def;
  bt_left     = 85;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let ok_string =
{
  bt_window   = cfg_string_def;
  bt_left     = 31;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let str_prompt4 =
{
  pt_window   = cfg_string_def;
  pt_left     = 5;
  pt_top      = 92;
  pt_name     = "Callback:"
};;

let str_prompt3 =
{
  pt_window   = cfg_string_def;
  pt_left     = 5;
  pt_top      = 110;
  pt_name     = "Name:"
};;

let str_prompt2 =
{
  pt_window   = cfg_string_def;
  pt_left     = 5;
  pt_top      = 126;
  pt_name     = "Id name:"
};;

let str_prompt1 =
{
  pt_window   = cfg_string_def;
  pt_left     = 35;
  pt_top      = 147;
  pt_name     = "String Configuration"
};;

let str_helpbar =
{
  hl_window   = cfg_string_def;
  hl_help     = "Press Ok when finished"
};;

let str_type =
{
  ga_window=cfg_string_def;
  ga_top=72;
  ga_left=5;
  ga_width=140;
  ga_height=30;
  ga_delta=5;
  ga_radio=0;
  ga_name=[| "String"; "Password"; "Natural"; "Integer";
             "Hexa"; "Float" |];
  ga_callback=gr_do_nothing
};;

let cfg_string =
{
  win_def      = cfg_string_def;
  win_objects  = [
                  g_button edit_string;
                  g_string str_string;
                  g_string str_callback;
                  g_string str_idname;
                  g_button cancel_string;
                  g_button ok_string;
                  g_prompt str_prompt4;
                  g_prompt str_prompt3;
                  g_prompt str_prompt2;
                  g_prompt str_prompt1;
                  g_helpbar str_helpbar;
                  g_grprad str_type
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let type_to_rad Type =
  match Type with
    Gr_string   -> 0
  | Gr_password -> 1
  | Gr_natural  -> 2
  | Gr_int      -> 3
  | Gr_hexa     -> 4
  | Gr_float    -> 5
;;

let rad_to_type Int =
  match Int with
    0 -> Gr_string
  | 1 -> Gr_password
  | 2 -> Gr_natural
  | 3 -> Gr_int
  | 4 -> Gr_hexa
  | 5 -> Gr_float
  | _ -> raise (Failure "rad_to_type: bad number")
;;


let string_callback=ref "";;
let string_name=ref "";;
let string_id=ref "";;
let string_values=ref Gr_string;;

let str_init Id Name Type Callback =
  string_callback := Callback;
  string_id := Id;
  string_name := Name;
  string_values := Type;
  str_idname.st_cursor <-0;
  str_callback.st_cursor <-0;
  str_string.st_cursor <-0;
  str_idname.st_1st_char <-0;
  str_callback.st_1st_char <-0;
  str_string.st_1st_char <-0;
  str_idname.st_name <- Id;
  str_string.st_name <- Name;
  str_string.st_type <- Type;
  str_type.ga_radio <- (type_to_rad Type);
  str_callback.st_name <- Callback
;;


let str_restore () =
  str_idname.st_name <- !string_id;
  str_string.st_name <- !string_name;
  str_callback.st_name <- !string_callback;
  str_string.st_type <- !string_values
;;


let str_type_callback Obj Event =
  str_string.st_type <- rad_to_type Obj.ga_radio;
  str_string.st_name <- "";
  true
;;

str_type.ga_callback <- str_type_callback;;





let CloseStringCfg String  Event =
  gr_erase_window cfg_string.win_def
;;

let CancelStringCfg String Event =
  str_restore ();
  gr_erase_window cfg_string.win_def
;;

let EditStringCfg String Event =
  EditCallback str_callback.st_name;
  true
;;


ok_string.bt_callback <- CloseStringCfg;;
cancel_string.bt_callback <- CancelStringCfg;;

