(***************************************************************************)
(*                                                                         *)
(*      search_str : string -> string list -> (string * string list)       *)
(*                                                                         *)
(***************************************************************************)
let search_str Str List =
  let rec search_str_loop Str List Result =
    match List with
      []   -> (Result, List)
    | x::y -> if x=Str then (Result, y) else search_str_loop Str y (Result ^ x)
  in
    search_str_loop Str List ""
;;



(***************************************************************************)
(*                                                                         *)
(*      break_str : string -> string -> string vect                        *)
(*      merge_str : string vect -> string -> string                        *)
(*                                                                         *)
(***************************************************************************)
let break_str Str break_str =
  let End = string_length Str
  and Len = string_length break_str in
    let rec break_str_loop StartPos Pos Result =
      if Pos > End - Len
      then concat_vect Result  [| sub_string Str StartPos (End - StartPos) |]
      else if break_str = sub_string Str Pos Len
           then break_str_loop (Pos+Len)
                               (Pos+Len) 
                               (concat_vect Result  
                                            [| sub_string Str 
                                                          StartPos 
                                                          (Pos-StartPos) 
                                            |])
           else break_str_loop StartPos (Pos+1) Result
    in
      break_str_loop 0 0 [| |]
;;



let merge_str VectStr merge_str =
  let len = vect_length VectStr in
    let rec merge_loop str pos =
      if pos=len 
      then str
      else merge_loop (str ^ VectStr.(pos) ^ merge_str) (pos + 1)
    in
  merge_loop "" 0
;;
