#open "windows";;
#open "camlwin";;

#open "funcdraw";;


let cfg_scroll_def = 
{
  win_left     = 21;
  win_top      = 307;
  win_width    = 150;
  win_height   = 125;
  win_id       = gr_undef_window;
  win_name     = "Scrollbar Configuration";
  win_state    = Destroyed
};;

let scroll_delta =
{
  st_window   = cfg_scroll_def;
  st_left     = 40;
  st_top      = 77;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_natural;
  st_callback = gr_do_nothing
};;

let scroll_pr_delta =
{
  pt_window   = cfg_scroll_def;
  pt_left     = 5;
  pt_top      = 75;
  pt_name     = "Delta:"
};;

let scroll_pr_dir =
{
  pt_window   = cfg_scroll_def;
  pt_left     = 5;
  pt_top      = 47;
  pt_name     = "Direction:"
};;

let scroll_direction =
{
  ga_window   = cfg_scroll_def;
  ga_left     = 47;
  ga_top      = 57;
  ga_width    = 65;
  ga_height   = 25;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [|
                 "Vertical";
                 "Horizontal"
                |];
  ga_callback = gr_do_nothing
};;

let scroll_idname =
{
  st_window   = cfg_scroll_def;
  st_left     = 40;
  st_top      = 107;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let scroll_callback =
{
  st_window   = cfg_scroll_def;
  st_left     = 40;
  st_top      = 91;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let scroll_cancel =
{
  bt_window   = cfg_scroll_def;
  bt_left     = 92;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let scroll_ok =
{
  bt_window   = cfg_scroll_def;
  bt_left     = 37;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let scroll_edit =
{
  bt_window   = cfg_scroll_def;
  bt_left     = 120;
  bt_top      = 92;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let scroll_pr_id =
{
  pt_window   = cfg_scroll_def;
  pt_left     = 5;
  pt_top      = 105;
  pt_name     = "Id name:"
};;

let scroll_pr_callback =
{
  pt_window   = cfg_scroll_def;
  pt_left     = 5;
  pt_top      = 90;
  pt_name     = "Callback:"
};;

let scroll_help =
{
  hl_window   = cfg_scroll_def;
  hl_help     = "Press Ok when finished"
};;

let scroll_title =
{
  pt_window   = cfg_scroll_def;
  pt_left     = 28;
  pt_top      = 121;
  pt_name     = "Scrollbar Configuration"
};;

let cfg_scroll =
{
  win_def      = cfg_scroll_def;
  win_objects  = [
                  g_string    scroll_delta;
                  g_prompt    scroll_pr_delta;
                  g_prompt    scroll_pr_dir;
                  g_grprad    scroll_direction;
                  g_string    scroll_idname;
                  g_string    scroll_callback;
                  g_button    scroll_cancel;
                  g_button    scroll_ok;
                  g_button    scroll_edit;
                  g_prompt    scroll_pr_id;
                  g_prompt    scroll_pr_callback;
                  g_helpbar   scroll_help;
                  g_prompt    scroll_title
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let scroll_call = ref "";;
let scroll_dir = ref Vertical;;
let scroll_d = ref 0;;
let scroll_id = ref "";;

let update_dir Dir =
  match Dir with
    Vertical -> scroll_direction.ga_radio <- 0
  | Horizontal -> scroll_direction.ga_radio <- 1
;;

let which_dir () =
  match scroll_direction.ga_radio  with
    0 -> Vertical
  | 1 -> Horizontal
  | _ -> raise (Failure "Bad direction")
;;

let scroll_init Id Callback Delta Dir=
  scroll_call := Callback;
  scroll_id := Id;
  scroll_dir := Dir;
  scroll_d := Delta;
  scroll_idname.st_cursor <-0;
  scroll_delta.st_cursor <-0;
  scroll_callback.st_cursor <-0;
  scroll_idname.st_1st_char <-0;
  scroll_delta.st_1st_char <-0;
  scroll_callback.st_1st_char <-0;
  scroll_idname.st_name <- Id;
  scroll_delta.st_name <- string_of_int Delta;
  scroll_callback.st_name <- Callback;
  update_dir Dir
;;


let scroll_restore () =
  scroll_idname.st_name <- !scroll_id;
  scroll_delta.st_name <- string_of_int !scroll_d;
  scroll_callback.st_name <- !scroll_call;
  update_dir !scroll_dir
;;



let CloseScrollCfg Obj Event =
  gr_erase_window cfg_scroll.win_def;;

let CancelScrollCfg Obj Event =
  scroll_restore ();
  gr_erase_window cfg_scroll.win_def
;;

let EditScrollCfg Obj Event =
  EditCallback scroll_callback.st_name;
  true
;;


scroll_ok.bt_callback <- CloseScrollCfg;;
scroll_cancel.bt_callback <- CancelScrollCfg;;
scroll_edit.bt_callback <- EditScrollCfg;;

