#open "windows";;
#open "camlwin";;
#open "sys";;


let save_bitmap Image Name =
  let Array=dump_image Image in
  try
    (
      let out=(open_out (Name ^ ".ml"))
      and width =(vect_length Array.(0))
      and height =(vect_length Array) in
        output_string out "let ";
        output_string out Name;
        output_string out " =\n";
        output_string out "[|\n";
        for i=0 to (height-2) do
        (
          output_string out "  [|";
          for j=0 to (width-2) do
          (
            output_string out (string_of_int (Array.(i).(j)));
            output_string out "; "
          )done;
          output_string out (string_of_int (Array.(i).(width-1)));
          output_string out " |];\n"
        )done;
        output_string out "  [|";
        for j=0 to (width-2) do
        (
          output_string out (string_of_int (Array.(height-1).(j)));
          output_string out "; "
        )done;
        output_string out (string_of_int (Array.(height-1).(width-1)));
        output_string out " |]\n|];;";
        close_out out
    )
  with Sys_error b -> gr_warning ("Can't open file " ^ Name ^ ".ml.")
                                 [| {warn_name="Ok"; warn_callback=gr_close_warning} |]
;;






let nb_times String Char =
  let rec nb_times_loop String Char Pos Length Times=
    if Length=Pos
    then Times
    else if (nth_char String Pos)=Char
         then nb_times_loop String Char (Pos+1) Length (Times+1)
         else nb_times_loop String Char (Pos+1) Length Times
  in
    let n=string_length String in
    nb_times_loop String Char 0 n 0
;;




let file_nb_times Channel Char =
  let rec file_nb_times_loop Channel Nbtimes=
    try
      (
         let str=input_line Channel in
           file_nb_times_loop Channel (Nbtimes+(nb_times str Char))
      )
    with End_of_file -> Nbtimes
  in
    let pos=pos_in Channel in
      seek_in Channel 0;
      let Nbtimes=(file_nb_times_loop Channel 0) in
        seek_in Channel pos;
        Nbtimes
;;




let rec get_number Channel =
  let rec get_number_loop Channel String=
    let c=input_char Channel in
      match c with
        `0`..`9` -> get_number_loop Channel (String ^ (char_for_read c))
      | `-`      -> get_number_loop Channel (String ^ "-")
      | _        -> String
  in
    let c=input_char Channel in
      match c with
        ` ` -> get_number Channel
      | _   -> int_of_string (get_number_loop Channel (char_for_read c))
;;


let load_bitmap Name Default=
  try
    (
      let file=(open_in (Name ^ ".ml")) in
        input_line file; (* line: 'let name ='*)
        input_line file; (* line: '[|'*)
        let Line=(input_line file) in
          let width=(nb_times Line `;`)
          and height=((file_nb_times file `[`) - 1) in
            let Array=(make_matrix height width transp) in
              seek_in file 0;
              input_line file; (* line: 'let name ='*)
              input_line file; (* line: '[|'*)
              for j=0 to (height -1) do
              (
                input_char file;
                input_char file;
                input_char file;
                input_char file; (* beginning of line: '  [|'*)
                for i=0 to (width -1) do
                  Array.(j).(i) <- get_number file
                done;
                input_line file  (* end of line*)
              )
              done;
              close_in file;
              make_image Array
    )
  with Sys_error b -> gr_warning ("Can't open file " ^ Name ^ ".ml!")
                                 [| {warn_name="Ok";
                                     warn_callback=gr_close_warning}
                                 |];
                      Default
     | Failure c -> gr_warning "It's not a file created with camlicon!"
                               [| {warn_name="Ok";
                                   warn_callback=gr_close_warning}
                               |];
                    Default
     | End_of_file  -> gr_warning "The file is troncated!"
                               [| {warn_name="Ok";
                                   warn_callback=gr_close_warning}
                               |];
                    Default
;;

