#open "windows";;
#open "camlwin";;

#open "confdraw";;
#open "globdraw";;


let debug = false;;



let save_melted Melted ImageName =
  match Melted with
    string_type str -> "string_type \"" ^ str ^ "\""
  | bitmap_type img -> "bitmap_type (make_image " ^ ImageName ^ ")"
  | int_type    n   -> "int_type " ^ (string_of_int n)
  | float_type  x   -> "float_type " ^ (string_of_float x)
  | bool_type   b   -> match b with
                         true  -> "bool_type true"
                       | false -> "bool_type false"
;;


let save_color Color =
  if Color = black
  then "black"
  else if Color = white
       then "white"
       else if Color = blue
            then "blue"
            else if Color = red
                 then "red"
                 else if Color = green
                      then "green"
                      else if Color = transp
                           then "transp"
                           else (string_of_int Color)
;;


let save_formated_str fStr Channel =
  let ft_type x =
    match x with
      Default_font -> "Default_font"
    | Fixed_font   -> "Fixed_font"
    | Proportional_font -> "Proportional_font"
  and ft_att x =
    match x with
      Normal_font -> "Normal_font"
    | Italic      -> "Italic"
    | Bold        -> "Bold"
    | Underline   -> "Underline"
  and ft_size x =
    match x with
      Size1_font -> "Size1_font"
    | Size2_font -> "Size2_font"
    | Size3_font -> "Size3_font"
    | Size4_font -> "Size4_font"
    | Size5_font -> "Size5_font"
    | Size6_font -> "Size6_font"
  in
    output_string Channel ("{ f_type=" ^ (ft_type fStr.f_type));
    output_string Channel ("; f_att =" ^ (ft_att fStr.f_att));
    output_string Channel ("; f_size =" ^ (ft_size fStr.f_size));
    output_string Channel ("; f_color =" ^ (save_color fStr.f_color));
    output_string Channel ("; f_string = \"" ^ fStr.f_string ^ "\"}")
;;



let save_formated_li fLi Channel =
  let rec out_bool b =
    match b with
      true  -> "true"
    | false -> "false"
  and out_fstrlist Flist =
    match Flist with
      []  -> ()
    | x::y -> save_formated_str x Channel;
              if not y = []
              then output_string Channel (";               ");
              out_fstrlist y
  in
    output_string Channel ("{ l_indent =" ^ (string_of_int fLi.l_indent));
    output_string Channel ("; l_line = " ^ (out_bool fLi.l_line));
    output_string Channel ("; l_content = [");
    out_fstrlist fLi.l_content;
    output_string Channel ("              ] }")
;;




(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_button Button DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  bt_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  bt_left     = " ^ (string_of_int Button.bt_left) ^ ";\n");
  output_string Channel ("  bt_top      = " ^ (string_of_int Button.bt_top) ^ ";\n");
  output_string Channel ("  bt_width    = " ^ (string_of_int Button.bt_width) ^ ";\n");
  output_string Channel ("  bt_height   = " ^ (string_of_int Button.bt_height) ^ ";\n");
  output_string Channel ("  bt_state    = Up;\n");
  output_string Channel ("  bt_name     = " ^ (save_melted Button.bt_name DefName.images_names.(0)) ^ ";\n");
  output_string Channel ("  bt_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_string String DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  st_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  st_left     = " ^ (string_of_int String.st_left) ^ ";\n");
  output_string Channel ("  st_top      = " ^ (string_of_int String.st_top) ^ ";\n");
  output_string Channel ("  st_width    = " ^ (string_of_int String.st_width) ^ ";\n");
  output_string Channel ("  st_1st_char = " ^ (string_of_int String.st_1st_char) ^ ";\n");
  output_string Channel ("  st_cursor   = " ^ (string_of_int String.st_cursor) ^ ";\n");
  output_string Channel ("  st_name     = \"" ^ String.st_name ^ "\";\n");
  output_string Channel ("  st_state    = " ^
                         (if String.st_state=View_only
                          then "View_only"
                          else "Editable"
                         ) ^
                         ";\n");
  output_string Channel ("  st_type     = " ^
                         (match String.st_type with
                            Gr_string   -> "Gr_string"
                          | Gr_natural  -> "Gr_natural"
                          | Gr_int      -> "Gr_int"
                          | Gr_hexa     -> "Gr_hexa"
                          | Gr_float    -> "Gr_float"
                          | Gr_password -> "Gr_password"
                         ) ^
                         ";\n");
  output_string Channel ("  st_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_text Text DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = gr_make_text\n{\n");
  output_string Channel ("  t_window    = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  t_left      = " ^ (string_of_int Text.tx_left) ^ ";\n");
  output_string Channel ("  t_top       = " ^ (string_of_int Text.tx_top) ^ ";\n");
  output_string Channel ("  t_width     = " ^ (string_of_int Text.tx_width) ^ ";\n");
  output_string Channel ("  t_height    = " ^ (string_of_int Text.tx_height) ^ ";\n");
  output_string Channel ("  t_name      = gr_lines_of_string \"" ^ (string_for_read (gr_string_of_lines Text.tx_name)) ^ "\";\n");
  output_string Channel ("  t_state     = Editable;\n");
  output_string Channel ("  t_scroll    = " ^
                         (match Text.tx_scroll with
                            Noscroll -> "Noscroll\n"
                          | Vscroll  -> "Vscroll\n"
                          | Dscroll  -> "Dscroll\n"
                         ));
  output_string Channel ("};;\n\n")
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_shell Shell DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = gr_make_shell\n{\n");
  output_string Channel ("  s_window    = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  s_left      = " ^ (string_of_int Shell.sh_left) ^ ";\n");
  output_string Channel ("  s_top       = " ^ (string_of_int Shell.sh_top) ^ ";\n");
  output_string Channel ("  s_width     = " ^ (string_of_int Shell.sh_width) ^ ";\n");
  output_string Channel ("  s_height    = " ^ (string_of_int Shell.sh_height) ^ ";\n");
  output_string Channel ("  s_state     = Editable\n");
  output_string Channel ("};;\n\n")
;;


(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_list List DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  li_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  li_left     = " ^ (string_of_int List.li_left) ^ ";\n");
  output_string Channel ("  li_top      = " ^ (string_of_int List.li_top) ^ ";\n");
  output_string Channel ("  li_width    = " ^ (string_of_int List.li_width) ^ ";\n");
  output_string Channel ("  li_height   = " ^ (string_of_int List.li_height) ^ ";\n");
  output_string Channel ("  li_nu_item  = " ^ (string_of_int List.li_nu_item) ^ ";\n");
  output_string Channel ("  li_1st_item = " ^ (string_of_int List.li_1st_item) ^ ";\n");
  output_string Channel ("  li_scroll   = " ^ (string_of_int List.li_scroll) ^ ";\n");
  output_string Channel ("  li_items    = [|");
  let n=(vect_length List.li_items) in
    if not n=0
    then
      (
        output_string Channel ("\"" ^ List.li_items.(0) ^ "\"");
        for i=1 to (n-1) do
          output_string Channel ("; \"" ^ List.li_items.(i) ^ "\"")
        done
      );
  output_string Channel " |];\n";
  output_string Channel ("  li_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_prompt Prompt DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  pt_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  pt_left     = " ^ (string_of_int Prompt.pt_left) ^ ";\n");
  output_string Channel ("  pt_top      = " ^ (string_of_int Prompt.pt_top) ^ ";\n");
  output_string Channel ("  pt_name     = \"" ^ Prompt.pt_name ^ "\"\n");
  output_string Channel ("};;\n\n")
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_helpb Helpb DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  hl_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  hl_help     = \"" ^ Helpb.hl_help ^ "\"\n");
  output_string Channel ("};;\n\n")
;;




(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_radio Radio DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  ra_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  ra_left     = " ^ (string_of_int Radio.ra_left) ^ ";\n");
  output_string Channel ("  ra_top      = " ^ (string_of_int Radio.ra_top) ^ ";\n");
  output_string Channel ("  ra_state    = ");
  (
    match Radio.ra_state with
      true -> output_string Channel "true;\n"
    | _ -> output_string Channel "false;\n"
  );
  output_string Channel ("  ra_name     = \"" ^ Radio.ra_name ^ "\";\n");
  output_string Channel ("  ra_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_grprad Grprad DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  ga_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  ga_left     = " ^ (string_of_int Grprad.ga_left) ^ ";\n");
  output_string Channel ("  ga_top      = " ^ (string_of_int Grprad.ga_top) ^ ";\n");
  output_string Channel ("  ga_width    = " ^ (string_of_int Grprad.ga_width) ^ ";\n");
  output_string Channel ("  ga_height   = " ^ (string_of_int Grprad.ga_height) ^ ";\n");
  output_string Channel ("  ga_delta    = " ^ (string_of_int Grprad.ga_delta) ^ ";\n");
  output_string Channel ("  ga_radio    = " ^ (string_of_int Grprad.ga_radio) ^ ";\n");
  output_string Channel ("  ga_name     = [|\n");
  let len=(vect_length Grprad.ga_name) in
    if not len=0
    then
      (
        output_string Channel ("                 \"" ^ Grprad.ga_name.(0) ^ "\"");
        for i=1 to (len-1) do
          output_string Channel (";\n                 \"" ^ Grprad.ga_name.(i) ^ "\"")
        done
      );
  output_string Channel ("\n                |];\n");
  output_string Channel ("  ga_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;


(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_grpbut Grpbut DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  gb_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  gb_left     = " ^ (string_of_int Grpbut.gb_left) ^ ";\n");
  output_string Channel ("  gb_top      = " ^ (string_of_int Grpbut.gb_top) ^ ";\n");
  output_string Channel ("  gb_width    = " ^ (string_of_int Grpbut.gb_width) ^ ";\n");
  output_string Channel ("  gb_height   = " ^ (string_of_int Grpbut.gb_height) ^ ";\n");
  output_string Channel ("  gb_btwidth  = " ^ (string_of_int Grpbut.gb_btwidth) ^ ";\n");
  output_string Channel ("  gb_btheight = " ^ (string_of_int Grpbut.gb_btheight) ^ ";\n");
  output_string Channel ("  gb_delta    = " ^ (string_of_int Grpbut.gb_delta) ^ ";\n");
  output_string Channel ("  gb_button   = " ^ (string_of_int Grpbut.gb_button) ^ ";\n");
  output_string Channel ("  gb_dir      = " ^ ( match Grpbut.gb_dir with
                                                  Vertical -> "Vertical;\n"
                                                | Horizontal -> "Horizontal;\n"
                                               ));
  output_string Channel ("  gb_name     = [|\n");
  let len=(vect_length Grpbut.gb_name) in
    if not len=0
    then
      (
        output_string Channel ("                  " ^ (save_melted Grpbut.gb_name.(0) DefName.images_names.(0)));
        for i=1 to (len-1) do
          output_string Channel (";\n                  " ^ (save_melted Grpbut.gb_name.(i) DefName.images_names.(i)))
        done
      );
  output_string Channel ("\n                |];\n");
  output_string Channel ("  gb_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_line Line DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  ln_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  ln_color    = " ^
                         (save_color Line.ln_color) ^ ";\n");
  output_string Channel ("  ln_point1   = ("^
                         (string_of_int (fst Line.ln_point1)) ^ ", " ^
                         (string_of_int (snd Line.ln_point1)) ^ ");\n");
  output_string Channel ("  ln_point2   = ("^
                         (string_of_int (fst Line.ln_point2)) ^ ", " ^
                         (string_of_int (snd Line.ln_point2)) ^ ")\n");
  output_string Channel ("};;\n\n")
;;


(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_ellipse Ellipse DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  el_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  el_filled   = " ^ 
                         (if Ellipse.el_filled then "true" else "false") ^ 
                         ";\n");
  output_string Channel ("  el_color    = " ^
                         (save_color Ellipse.el_color) ^ ";\n");
  output_string Channel ("  el_center   = ("^
                         (string_of_int (fst Ellipse.el_center)) ^ ", " ^
                         (string_of_int (snd Ellipse.el_center)) ^ ");\n");
  output_string Channel ("  el_xray     = " ^
                         (string_of_int Ellipse.el_xray) ^ ";\n");
  output_string Channel ("  el_yray     = " ^
                         (string_of_int Ellipse.el_yray) ^ "\n");
  output_string Channel ("};;\n\n")
;;


(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_rectangle Rectangle DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  re_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  re_filled   = " ^ 
                         (if Rectangle.re_filled then "true" else "false") ^ 
                         ";\n");
  output_string Channel ("  re_color    = " ^
                         (save_color Rectangle.re_color) ^ ";\n");
  output_string Channel ("  re_point    = ("^
                         (string_of_int (fst Rectangle.re_point)) ^ ", " ^
                         (string_of_int (snd Rectangle.re_point)) ^ ");\n");
  output_string Channel ("  re_width    = " ^
                         (string_of_int Rectangle.re_width) ^ ";\n");
  output_string Channel ("  re_height   = " ^
                         (string_of_int Rectangle.re_height) ^ "\n");
  output_string Channel ("};;\n\n")
;;




(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_scroll Scroll DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " =\n{\n");
  output_string Channel ("  sb_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  sb_left     = " ^ (string_of_int Scroll.sb_left) ^ ";\n");
  output_string Channel ("  sb_top      = " ^ (string_of_int Scroll.sb_top) ^ ";\n");
  output_string Channel ("  sb_length   = " ^ (string_of_int Scroll.sb_length) ^ ";\n");
  output_string Channel ("  sb_pos      = " ^ (string_of_int Scroll.sb_pos) ^ ";\n");
  output_string Channel ("  sb_delta    = " ^ (string_of_int Scroll.sb_delta) ^ ";\n");
  output_string Channel ("  sb_dir      = " ^
                         (match Scroll.sb_dir with
                            Vertical   -> "Vertical;\n"
                          | Horizontal -> "Horizontal;\n"
                         ));
  output_string Channel ("  sb_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_bitmap Bitmap DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " =\n{\n");
  output_string Channel ("  bm_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  bm_left     = " ^ (string_of_int Bitmap.bm_left) ^ ";\n");
  output_string Channel ("  bm_top      = " ^ (string_of_int Bitmap.bm_top) ^ ";\n");
  output_string Channel ("  bm_bitmap   = make_image " ^ DefName.images_names.(0) ^ ";\n");
  output_string Channel ("  bm_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;






(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_extext ExText DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  extx_window = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  extx_name   = \"" ^ ExText.extx_name ^ "\";\n");
  output_string Channel ("  extx_left   = " ^ (string_of_int ExText.extx_left) ^ ";\n");
  output_string Channel ("  extx_top    = " ^ (string_of_int ExText.extx_top) ^ ";\n");
  output_string Channel ("  extx_width  = " ^ (string_of_int ExText.extx_width) ^ ";\n");
  output_string Channel ("  extx_height = " ^ (string_of_int ExText.extx_height) ^ ";\n");  
  output_string Channel ("  extx_first  = 0;\n");
  output_string Channel ("  extx_anchors= [ ];\n");
  output_string Channel ("  extx_content= [| |];\n");
  output_string Channel ("  extx_callback= gr_extext_callback\n");
  output_string Channel ("};;\n\n")
;;





(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_exprompt ExPrompt DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  expt_window = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  expt_left   = " ^ (string_of_int ExPrompt.expt_left) ^ ";\n");
  output_string Channel ("  expt_top    = " ^ (string_of_int ExPrompt.expt_top) ^ ";\n");
  output_string Channel ("  expt_name   = ");
  save_formated_str ExPrompt.expt_name Channel; 
  output_string Channel ("\n};;\n\n")
;;




(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_area Area DefName WindowName Channel =
  output_string Channel ("let " ^ DefName.id_name ^ " = \n{\n");
  output_string Channel ("  ar_window = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  ar_name   = \"" ^ Area.ar_name ^ "\";\n");
  output_string Channel ("  ar_left   = " ^ (string_of_int Area.ar_left) ^ ";\n");
  output_string Channel ("  ar_top    = " ^ (string_of_int Area.ar_top) ^ ";\n");
  output_string Channel ("  ar_width  = " ^ (string_of_int Area.ar_width) ^ ";\n");
  output_string Channel ("  ar_height = " ^ (string_of_int Area .ar_height) ^ "\n");  
  output_string Channel ("};;\n\n")
;;













(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_item Item DualName WindowName Channel =
  output_string Channel ("let " ^ (fst DualName) ^ " = \n{\n");
  output_string Channel ("  it_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  it_name     = \"" ^ Item.it_name ^ "\";\n");
  output_string Channel ("  it_state    = Unselected;\n");
  output_string Channel ("  it_callback = gr_do_nothing\n");
  output_string Channel ("};;\n\n")
;;


(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_menu Menu ToolbDef WindowName Channel =
  let len=vect_length Menu.mn_items in
    for i=0 to (len-1) do
      save_item Menu.mn_items.(i) ToolbDef.items_def.(i) WindowName Channel
    done;
  output_string Channel ("let " ^ ToolbDef.menu_name ^ " = \n{\n");
  output_string Channel ("  mn_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  mn_left     = 0;\n");
  output_string Channel ("  mn_top      = 0;\n");
  output_string Channel ("  mn_nu_item  = 0;\n");
  output_string Channel ("  mn_hide_area= gr_empty_image;\n");
  output_string Channel ("  mn_name     = \"" ^ Menu.mn_name ^ "\";\n");
  output_string Channel ("  mn_state    = Unvisible;\n");
  output_string Channel ("  mn_items    = [|\n");
    if not len=0
    then
      (
        output_string Channel
                      ("                 " ^
                       (fst ToolbDef.items_def.(0))
                      );
        for i=1 to (len-1) do
          output_string Channel
                        (";\n                 " ^
                         (fst ToolbDef.items_def.(i))
                        )
        done
      );
  output_string Channel ("\n                |]\n");
  output_string Channel ("};;\n\n")
;;


(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_toolb Toolb ToolbName WindowName ToolbDefs Channel =
  let len=vect_length Toolb.tb_items in
    for i=0 to (len-1) do
      save_menu Toolb.tb_items.(i) ToolbDefs.(i) WindowName Channel
    done;
  output_string Channel ("let " ^ ToolbName ^ " = \n{\n");
  output_string Channel ("  tb_window   = " ^ WindowName ^ "_def;\n");
  output_string Channel ("  tb_items    = [|\n");
    if not len=0
    then
      (
        output_string Channel ("                 " ^ ToolbDefs.(0).menu_name);
        for i=1 to (len-1) do
          output_string Channel (";\n                 " ^ ToolbDefs.(i).menu_name)
        done
      );
  output_string Channel ("\n                |]\n");
  output_string Channel ("};;\n\n")
;;










(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let save_window_def Window WindowName Channel =
  output_string Channel ("let " ^ WindowName ^ "_def = \n{\n");
  output_string Channel ("  win_left     = " ^ (string_of_int Window.win_left) ^ ";\n");
  output_string Channel ("  win_top      = " ^ (string_of_int Window.win_top) ^ ";\n");
  output_string Channel ("  win_width    = " ^ (string_of_int Window.win_width) ^ ";\n");
  output_string Channel ("  win_height   = " ^ (string_of_int Window.win_height) ^ ";\n");
  output_string Channel ("  win_id       = gr_undef_window;\n");
  output_string Channel ("  win_name     = \"" ^ Window.win_name ^ "\";\n"); 
  output_string Channel ("  win_state    = Destroyed\n");
  output_string Channel ("};;\n\n")
;;







let save_window_object Object ObjectName Channel =
  match Object with
    g_user   User     -> output_string Channel ("g_user      " ^ ObjectName)
  | g_text   Text     -> output_string Channel ("g_text      " ^ ObjectName)
  | g_list   List     -> output_string Channel ("g_list      " ^ ObjectName)
  | g_extext ExText   -> output_string Channel ("g_extext    " ^ ObjectName)
  | g_exprompt ExPt   -> output_string Channel ("g_exprompt  " ^ ObjectName)
  | g_area   Area     -> output_string Channel ("g_area      " ^ ObjectName)
  | g_item   Item     -> ()
  | g_menu   Menu     -> ()
  | g_line   Line     -> output_string Channel ("g_line      " ^ ObjectName)
  | g_radio  Radio    -> output_string Channel ("g_radio     " ^ ObjectName)
  | g_shell  Shell    -> output_string Channel ("g_shell     " ^ ObjectName)
  | g_prompt Prompt   -> output_string Channel ("g_prompt    " ^ ObjectName)
  | g_bitmap Bitmap   -> output_string Channel ("g_bitmap    " ^ ObjectName)
  | g_button Button   -> output_string Channel ("g_button    " ^ ObjectName)
  | g_string String   -> output_string Channel ("g_string    " ^ ObjectName)
  | g_grpbut Grpbut   -> output_string Channel ("g_grpbut    " ^ ObjectName)
  | g_grprad Grprad   -> output_string Channel ("g_grprad    " ^ ObjectName)
  | g_toolbar Toolb   -> output_string Channel ("g_toolbar   " ^ ObjectName)
  | g_helpbar Helpb   -> output_string Channel ("g_helpbar   " ^ ObjectName)
  | g_ellipse Ellip   -> output_string Channel ("g_ellipse   " ^ ObjectName)
  | g_scrollbar Scrol -> output_string Channel ("g_scrollbar " ^ ObjectName)
  | g_rectangle Rect  -> output_string Channel ("g_rectangle " ^ ObjectName)
;;





let save_window WindowName Objects DefName HelpFile 
                TimeCallback ResizeCallback Channel =
  let rec save_window_loop Objects DefName =
    match (DefName,Objects) with
      ([],[]) -> output_string Channel "\n                 ];\n"
    | (x::y,r::t) ->
        (
          match r with
            g_item Item -> ()
          | g_menu Menu -> ()
          | _           ->
              output_string Channel ";\n                  ";
              save_window_object r x.id_name Channel
        );
        save_window_loop t y
    | _ -> ()
  in
    output_string Channel ("let " ^ WindowName ^ " = \n{\n");
    output_string Channel ("  win_def      = " ^ WindowName ^ "_def;\n");
    output_string Channel "  win_objects  = [\n                  ";
    (
      match (DefName,Objects) with
        ([],[]) -> output_string Channel "                 ];\n"
      | (x::y,r::t) ->
          (
          match r with
            g_item Item -> ()
          | g_menu Menu -> ()
          | _           ->
              save_window_object r x.id_name Channel
        );
        save_window_loop t y
      | _ -> ()
    );
    output_string Channel ("  time_callback    = gr_do_nothing;\n");
    output_string Channel ("  resize_callback  = gr_do_nothing;\n");
    output_string Channel ("  help_file        = \"" ^ HelpFile ^ "\";\n");
    output_string Channel ("  miscellaneous    = [| |]\n");
    output_string Channel ("};;\n\n")
;;









let init_save Modules Channel =
  output_string Channel ("(* This file is created with Camldsgn *)\n\n");
  output_string Channel ("#open \"windows\";;\n");
  output_string Channel ("#open \"camlwin\";;\n");
  output_string Channel ("\n\n\n");
  for i=0 to ((vect_length Modules)-1) do
    if not Modules.(i)="" 
    then output_string Channel ("#open \"" ^ Modules.(i) ^ "\";;\n")
  done;
  output_string Channel ("\n\n\n")
;;





let save_object Object DefName WindowName Channel =
  match Object with
    g_button Button -> save_button Button DefName WindowName Channel
  | g_string String -> save_string String DefName WindowName Channel
  | g_text   Text   -> save_text   Text   DefName WindowName Channel
  | g_shell  Shell  -> save_shell  Shell  DefName WindowName Channel
  | g_list   List   -> save_list   List   DefName WindowName Channel
  | g_area   Area   -> save_area   Area   DefName WindowName Channel
  | g_prompt Prompt -> save_prompt Prompt DefName WindowName Channel
  | g_item   Item   -> ()
  | g_menu   Menu   -> ()
  | g_toolbar Toolb -> ()
  | g_bitmap Bitmap -> save_bitmap Bitmap DefName WindowName Channel
  | g_scrollbar Scr -> save_scroll Scr    DefName WindowName Channel
  | g_rectangle Rec -> save_rectangle Rec DefName WindowName Channel
  | g_line   Line   -> save_line  Line    DefName WindowName Channel
  | g_ellipse Elli  -> save_ellipse Elli  DefName WindowName Channel
  | g_radio  Radio  -> save_radio Radio   DefName WindowName Channel
  | g_helpbar Helpb -> save_helpb Helpb   DefName WindowName Channel
  | g_grpbut Grpbut -> save_grpbut Grpbut DefName WindowName Channel
  | g_grprad Grprad -> save_grprad Grprad DefName WindowName Channel
  | g_extext ExText -> save_extext ExText DefName WindowName Channel
  | g_exprompt ExPt -> save_exprompt ExPt DefName WindowName Channel
  | g_user   User   -> ()
;;


let rec save_loop Objects DefNames WindowName Channel =
  match (Objects,DefNames) with
    ([],[]) -> ()
  | (o::p,n::m) ->
      save_object o n WindowName Channel;
      save_loop p m WindowName Channel
  | _   -> ()
;;





let rec save_callbacks CallbacksNames Channel=
  match CallbacksNames with
    [] -> ()
  | x::y ->
      output_string Channel x;
      output_string Channel "\n";
      save_callbacks y Channel
;;



let save_set_callback Object ObjectName CallbackName Channel =
  let output_set_callback Prefix =
    output_string Channel (ObjectName ^ "." ^ Prefix ^ "_callback <- " ^
                           CallbackName ^ ";;\n")
  in
    match Object with
      g_button Button -> output_set_callback "bt"
    | g_string String -> output_set_callback "st"
    | g_text   Text   -> ()
    | g_shell  Shell  -> ()
    | g_extext ExText -> ()
    | g_exprompt ExPt -> ()
    | g_area   Area   -> ()
    | g_list   List   -> output_set_callback "li"
    | g_prompt Prompt -> ()
    | g_item   Item   -> output_set_callback "it"
    | g_menu   Menu   -> ()
    | g_toolbar Toolb -> ()
    | g_bitmap Bitmap -> output_set_callback "bm"
    | g_scrollbar Scr -> output_set_callback "sb"
    | g_rectangle Rec -> ()
    | g_line   Line   -> ()
    | g_ellipse Elli  -> ()
    | g_radio  Radio  -> output_set_callback "ra"
    | g_helpbar Helpb -> ()
    | g_grpbut Grpbut -> output_set_callback "gb"
    | g_grprad Grprad -> output_set_callback "ga"
    | g_user   User   -> ()
;;



let save_toolb_callbacks Toolb  ToolbDefs Channel =
  let save_item_callbacks Item DualName =
    save_set_callback (g_item Item) (fst DualName) (snd DualName) Channel
  in
    let save_menu_callbacks Menu ToolbDef=
      let len=vect_length Menu.mn_items in
        for i=0 to (len-1) do
          save_item_callbacks Menu.mn_items.(i) ToolbDef.items_def.(i)
        done
      in
      let len=vect_length Toolb.tb_items in
        for i=0 to (len-1) do
          save_menu_callbacks Toolb.tb_items.(i) ToolbDefs.(i)
        done
;;




let save_set_callbacks ObjList DefNames DefToolb Channel =
  let rec save_set_callbacks_loop ObjList DefNames =
    match (ObjList,DefNames) with
      ([],[]) -> ()
    | (o::p,n::m) ->
        if not n.callback="gr_do_nothing"
        then save_set_callback o n.id_name n.callback Channel;
        save_set_callbacks_loop p m 
    | _ -> ()
  in
    if had_toolbar ObjList
    then
    (
      let toolb = get_toolbar ObjList in
        let n = which_object (g_toolbar toolb) ObjList in
          save_toolb_callbacks toolb DefToolb Channel
    );
    save_set_callbacks_loop ObjList DefNames
;;





let save Window WindowName HelpFile TimeCallback ResizeCallback 
         DefNames DefToolb CallbacksDefs Channel =
  if debug
  then
  (
    print_string "init";
    print_newline ()
  );
  init_save (images_name_vect DefNames) Channel;
  if debug
  then
  (
    print_string "save_window_def";
    print_newline ()
  );
  save_window_def Window.win_def WindowName Channel;
  if debug
  then
  (
    print_string "had_toolbar";
    print_newline ()
  );
  if had_toolbar Window.win_objects
  then
  (
    let toolb = get_toolbar Window.win_objects in
      let n = which_object (g_toolbar toolb) Window.win_objects in
        let Def= nth_elem DefNames n in
          if debug
          then
          (
            print_string "save_toolb";
            print_newline ()
          );
          save_toolb toolb Def.id_name WindowName DefToolb Channel
  );
  if debug
  then
  (
    print_string "save_loop";
    print_newline ()
  );
  save_loop Window.win_objects
            DefNames
            WindowName
            Channel;
  if debug
  then
  (
    print_string "save_window";
    print_newline ()
  );
  save_window WindowName Window.win_objects DefNames HelpFile 
              TimeCallback ResizeCallback Channel;
  if debug
  then
  (
    print_string "save_callback";
    print_newline ()
  );
  save_callbacks CallbacksDefs Channel;
  if not TimeCallback = "gr_do_nothing"
  then output_string Channel (WindowName ^ "time_callback <- " ^ 
                     TimeCallback ^ ";\n");
  if not ResizeCallback = "gr_do_nothing"
  then output_string Channel (WindowName ^ "resize_callback <- " ^ 
                     ResizeCallback ^ ";\n");
  if debug
  then
  (
    print_string "set_callback";
    print_newline ()
  );
  save_set_callbacks Window.win_objects DefNames DefToolb Channel
;;

