#open "windows";;
#open "camlwin";;

#open "funcdraw";;


let cfg_s3_def =
{
  win_left     = 20;
  win_top      = 300;
  win_width    = 150;
  win_height   = 100;
  win_id       = gr_undef_window;
  win_name     = "";
  win_state    = Destroyed
};;

let s3_edit =
{
  bt_window   = cfg_s3_def;
  bt_left     = 123;
  bt_top      = 45;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let s3_callback =
{
  st_window   = cfg_s3_def;
  st_left     = 42;
  st_top      = 44;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let s3_name =
{
  st_window   = cfg_s3_def;
  st_left     = 42;
  st_top      = 60;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let s3_prompt7 =
{
  pt_window   = cfg_s3_def;
  pt_left     = 5;
  pt_top      = 57;
  pt_name     = "Name:"
};;

let s3_prompt6 =
{
  pt_window   = cfg_s3_def;
  pt_left     = 5;
  pt_top      = 42;
  pt_name     = "Callback:"
};;

let s3_idname =
{
  st_window   = cfg_s3_def;
  st_left     = 42;
  st_top      = 78;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let s3_prompt4 =
{
  pt_window   = cfg_s3_def;
  pt_left     = 5;
  pt_top      = 76;
  pt_name     = "Id name:"
};;

let s3_cancel =
{
  bt_window   = cfg_s3_def;
  bt_left     = 82;
  bt_top      = 26;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let s3_helpbar =
{
  hl_window   = cfg_s3_def;
  hl_help     = "Press Ok when finished"
};;

let s3_prompt1 =
{
  pt_window   = cfg_s3_def;
  pt_left     = 35;
  pt_top      = 96;
  pt_name     = "Item Configuration"
};;

let s3_ok =
{
  bt_window   = cfg_s3_def;
  bt_left     = 28;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let cfg_s3 =
{
  win_def      = cfg_s3_def;
  win_objects  = [
                  g_button s3_edit;
                  g_string s3_callback;
                  g_string s3_name;
                  g_prompt s3_prompt7;
                  g_prompt s3_prompt6;
                  g_string s3_idname;
                  g_prompt s3_prompt4;
                  g_button s3_cancel;
                  g_helpbar s3_helpbar;
                  g_prompt s3_prompt1;
                  g_button s3_ok
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;


let s3_call = ref "";;
let s3_save = ref "";;
let s3_id = ref "";;

let s3_init Title Id Name Callback =
  let dx=gr_to_win_coord (fst (text_size Title)) in
    let x=((cfg_s3_def.win_width-dx)/2) in
      s3_prompt1.pt_left <- x;
  s3_prompt1.pt_name <- Title;
  cfg_s3_def.win_name <- Title;

  s3_call := Callback;
  s3_id := Id;
  s3_save := Name;
  s3_idname.st_cursor <-0;
  s3_name.st_cursor <-0;
  s3_callback.st_cursor <-0;
  s3_idname.st_1st_char <-0;
  s3_name.st_1st_char <-0;
  s3_callback.st_1st_char <-0;
  s3_idname.st_name <- Id;
  s3_name.st_name <- Name;
  s3_callback.st_name <- Callback
;;


let s3_restore () =
  s3_idname.st_name <- !s3_id;
  s3_name.st_name <- !s3_save;
  s3_callback.st_name <- !s3_call
;;



let CloseS3Cfg Obj Event =
  gr_erase_window cfg_s3.win_def
;;

let CancelS3Cfg Obj Event =
  s3_restore ();
  gr_erase_window cfg_s3.win_def
;;

let EditS3Cfg Obj Event =
  EditCallback s3_callback.st_name;
  true
;;


s3_ok.bt_callback <- CloseS3Cfg;;
s3_cancel.bt_callback <- CancelS3Cfg;;
s3_edit.bt_callback <- EditS3Cfg;;

