#open "windows";;
#open "camlwin";;



let cfg_s2_def =
{
  win_left     = 20;
  win_top      = 300;
  win_width    = 150;
  win_height   = 75;
  win_id       = gr_undef_window;
  win_name     = "";
  win_state    = Destroyed
};;

let s2_name =
{
  st_window   = cfg_s2_def;
  st_left     = 42;
  st_top      = 42;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let s2_idname =
{
  st_window   = cfg_s2_def;
  st_left     = 42;
  st_top      = 58;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let s2_cancel =
{
  bt_window   = cfg_s2_def;
  bt_left     = 83;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let s2_ok =
{
  bt_window   = cfg_s2_def;
  bt_left     = 33;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let s2_prompt3 =
{
  pt_window   = cfg_s2_def;
  pt_left     = 37;
  pt_top      = 73;
  pt_name     = "Helpbar Configuration"
};;

let s2_prompt2 =
{
  pt_window   = cfg_s2_def;
  pt_left     = 4;
  pt_top      = 55;
  pt_name     = "Id name:"
};;

let s2_prompt1 =
{
  pt_window   = cfg_s2_def;
  pt_left     = 4;
  pt_top      = 39;
  pt_name     = "Name:"
};;

let s2_helpbar =
{
  hl_window   = cfg_s2_def;
  hl_help     = "Press Ok when finshed"
};;

let cfg_s2 =
{
  win_def      = cfg_s2_def;
  win_objects  = [
                  g_string s2_idname;
                  g_string s2_name;
                  g_button s2_cancel;
                  g_button s2_ok;
                  g_prompt s2_prompt3;
                  g_prompt s2_prompt2;
                  g_prompt s2_prompt1;
                  g_helpbar s2_helpbar
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let s2_save = ref "";;
let s2_id = ref "";;

let s2_init Title Id Name =
  let dx=gr_to_win_coord (fst (text_size Title)) in
    let x=((cfg_s2_def.win_width-dx)/2) in
      s2_prompt3.pt_left <- x;
  s2_prompt3.pt_name <- Title;
  cfg_s2_def.win_name <- Title;

  s2_id := Id;
  s2_save := Name;
  s2_name.st_cursor <-0;
  s2_idname.st_cursor <-0;
  s2_name.st_1st_char <-0;
  s2_idname.st_1st_char <-0;
  s2_idname.st_name <- Id;
  s2_name.st_name <- Name
;;


let s2_restore () =
  s2_name.st_name <- !s2_save;
  s2_idname.st_name <- !s2_id
;;




let CloseS2Cfg Obj  Event =
  gr_erase_window cfg_s2.win_def
;;

let CancelS2Cfg Obj Event =
  s2_restore ();
  gr_erase_window cfg_s2.win_def
;;

s2_ok.bt_callback <- CloseS2Cfg;;
s2_cancel.bt_callback <- CancelS2Cfg;;

