#open "windows";;
#open "camlwin";; 



let proj_win_def = 
{
  win_left     = 4;
  win_top      = 460;
  win_width    = 130;
  win_height   = 75;
  win_id       = gr_undef_window;
  win_name     = "Project Window";
  win_state    = Destroyed
};;

let proj_title =
{
  pt_window   = proj_win_def;
  pt_left     = 25;
  pt_top      = 72;
  pt_name     = "Project List"
};;

let proj_list =
{
  li_window   = proj_win_def;
  li_left     = 2;
  li_top      = 65;
  li_width    = 95;
  li_height   = 42;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [| |];
  li_callback = gr_do_nothing
};;

let proj_add =
{
  bt_window   = proj_win_def;
  bt_left     = 100;
  bt_top      = 65;
  bt_width    = 25;
  bt_height   = 12;
  bt_state    = Up;
  bt_name     = string_type "Add";
  bt_callback = gr_do_nothing
};;

let proj_ins =
{
  bt_window   = proj_win_def;
  bt_left     = 100;
  bt_top      = 50;
  bt_width    = 25;
  bt_height   = 12;
  bt_state    = Up;
  bt_name     = string_type "Ins";
  bt_callback = gr_do_nothing
};;

let proj_del =
{
  bt_window   = proj_win_def;
  bt_left     = 100;
  bt_top      = 35;
  bt_width    = 25;
  bt_height   = 12;
  bt_state    = Up;
  bt_name     = string_type "Del";
  bt_callback = gr_do_nothing
};;

let proj_cfgmake =
{
  bt_window   = proj_win_def;
  bt_left     = 10;
  bt_top      = 15;
  bt_width    = 40;
  bt_height   = 12;
  bt_state    = Up;
  bt_name     = string_type "Config Compilers";
  bt_callback = gr_do_nothing
};;

let proj_cfglink =
{
  bt_window   = proj_win_def;
  bt_left     = 60;
  bt_top      = 15;
  bt_width    = 40;
  bt_height   = 12;
  bt_state    = Up;
  bt_name     = string_type "Config Linker";
  bt_callback = gr_do_nothing
};;

let proj_win =
{
  win_def      = proj_win_def;
  win_objects  = [
                  g_prompt    proj_title;
                  g_list      proj_list;
                  g_button    proj_add;
                  g_button    proj_ins;
                  g_button    proj_del;
                  g_button    proj_cfglink;
                  g_button    proj_cfgmake
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;


let CloseProjWin Obj Event =
  gr_erase_window proj_win.win_def;
  true
;;



let change_proj_title Str =
  let Title=Str ^ " project:" in
    let dx=gr_to_win_coord (fst (text_size Title))
    and width=proj_title.pt_window.win_width in
      proj_title.pt_name <- Title;
      proj_title.pt_left <- (width-dx)/2
;;





