#open "windows";;
#open "camlwin";;

#open "globdraw";;
#open "camldraw";;


let ObjectWin_def = 
{
  win_left     = 400;
  win_top      = 460;
  win_width    = 100;
  win_height   = 100;
  win_id       = gr_undef_window;
  win_name     = "Window Objects";
  win_state    = Destroyed
};;

let obj_prompt =
{
  pt_window   = ObjectWin_def;
  pt_left     = 23;
  pt_top      = 96;
  pt_name     = "Objects list"
};;

let obj_close =
{
  bt_window   = ObjectWin_def;
  bt_left     = 35;
  bt_top      = 14;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Close";
  bt_callback = gr_do_nothing
};;

let obj_del =
{
  bt_window   = ObjectWin_def;
  bt_left     = 3;
  bt_top      = 66;
  bt_width    = 20;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Del";
  bt_callback = gr_do_nothing
};;

let obj_cfg =
{
  bt_window   = ObjectWin_def;
  bt_left     = 3;
  bt_top      = 48;
  bt_width    = 20;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let obj_list =
{
  li_window   = ObjectWin_def;
  li_left     = 32;
  li_top      = 86;
  li_width    = 60;
  li_height   = 65;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [| |];
  li_callback = gr_do_nothing
};;

let ObjectWin =
{
  win_def      = ObjectWin_def;
  win_objects  = [
                  g_prompt obj_prompt;
                  g_button obj_close;
                  g_button obj_del;
                  g_button obj_cfg;
                  g_list obj_list
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let CloseObject Obj Event =
  gr_erase_window ObjectWin.win_def;;

obj_close.bt_callback <- CloseObject;;


let UpdateObject NameVect =
  let len = vect_length NameVect in
  obj_list.li_items <- sub_vect NameVect 1 (len-1);
  if ObjectWin.win_def.win_state=Created
  then
  (
    let current=get_current_window () in
      set_draw_window ObjectWin.win_def.win_id;
      gr_draw_list obj_list;
      set_draw_window current
  )
;;



