#open "windows";;
#open "camlwin";;

#open "camldraw";;





let UpdatePos x y =
  let current=get_current_window () in
    camldraw_pos.st_name <- ((string_of_int x) ^ "*" ^
                             (string_of_int y));
    set_draw_window CamldrawWin.win_def.win_id;
    gr_draw_string camldraw_pos;
    set_draw_window current
;;


let UpdateSize x y =
  let current=get_current_window () in
    camldraw_size.st_name <- ((string_of_int x) ^ "x" ^
                             (string_of_int y));
    set_draw_window CamldrawWin.win_def.win_id;
    gr_draw_string camldraw_size;
    set_draw_window current
;;




let move_object Left Top Width Height MouseCoord=
  let left  = gr_to_real_coord Left
  and top   = gr_to_real_coord Top
  and width = gr_to_real_coord Width
  and height= gr_to_real_coord Height in
  let dx=MouseCoord.x-left
  and dy=MouseCoord.y-top in
    let x=ref left
    and y=ref top
    and im1 = (get_image left (top-6) 6 6)
    and im2 = (get_image (left+width-6) (top-6) 6 6)
    and im3 = (get_image (left+width-6) (top-height) 6 6)
    and im4 = (get_image left (top-height) 6 6) in

      set_color black;
      fill_rect !x (!y-6) 6 6;
      fill_rect (!x+width-6) (!y-6) 6 6;
      fill_rect (!x+width-6) (!y-height) 6 6;
      fill_rect (!x) (!y-height) 6 6;

      UpdatePos !x !y;
      UpdateSize width height;

  while (
    let Event=(get_event([Button_up; Mouse_motion])) in
      draw_image im1 !x (!y-6);
      draw_image im2 (!x+width-6) (!y-6);
      draw_image im3 (!x+width-6) (!y-height);
      draw_image im4 !x (!y-height);
      x := gr_to_real_coord (gr_to_win_coord (Event.mouse_x-dx));
      y := gr_to_real_coord (gr_to_win_coord (Event.mouse_y-dy));
      Event.button
        )
  do

        (
          blit_image im1 !x (!y-6);
          blit_image im2 (!x+width-6) (!y-6);
          blit_image im3 (!x+width-6) (!y-height);
          blit_image im4 !x (!y-height);
          fill_rect !x (!y-6) 6 6;
          fill_rect (!x+width-6) (!y-6) 6 6;
          fill_rect (!x+width-6) (!y-height) 6 6;
          fill_rect !x (!y-height) 6 6;
          UpdatePos !x !y
  ) done;

  {x=gr_to_win_coord !x; y=gr_to_win_coord !y}
;;



let min_size = 8;;


let resize_object Left Top Width Height MouseCoord=
  let left  = gr_to_real_coord Left
  and top   = gr_to_real_coord Top
  and iwidth = gr_to_real_coord Width
  and iheight= gr_to_real_coord Height in

  let dx = MouseCoord.x-(left + iwidth)
  and dy = MouseCoord.y-(top - iheight)
  and width = ref iwidth
  and height = ref iheight in
    let im1 = (get_image left (top - 6) 6 6)
    and im2 = (get_image (left + !width-6) (top - 6) 6 6)
    and im3 = (get_image (left + !width-6) (top - !height) 6 6)
    and im4 = (get_image left (top - !height) 6 6) in

      set_color black;
      fill_rect left (top - 6) 6 6;
      fill_rect (left + !width-6) (top - 6) 6 6;
      fill_rect (left + !width-6) (top - !height) 6 6;
      fill_rect left (top - !height) 6 6;
      UpdatePos left top;
      UpdateSize !width !height;

  while (
    let Event=(get_event([Button_up; Mouse_motion])) in
      draw_image im2 (left + !width-6) (top - 6);
      draw_image im3 (left + !width-6) (top - !height);
      draw_image im4 left (top - !height);
      width  := gr_to_real_coord (gr_to_win_coord (max min_size (Event.mouse_x-dx-left)));
      height := gr_to_real_coord (gr_to_win_coord (max min_size (dy-Event.mouse_y+top)));
      Event.button
        )
  do

        (
          blit_image im2 (left + !width - 6) (top - 6);
          blit_image im3 (left + !width - 6) (top - !height);
          blit_image im4 left (top - !height);
          fill_rect (left + !width - 6) (top - 6) 6 6;
          fill_rect (left + !width - 6) (top - !height) 6 6;
          fill_rect left (top - !height) 6 6;
          UpdateSize !width !height
  ) done;
  draw_image im1 left (top - 6);

  {x=gr_to_win_coord !width; y=gr_to_win_coord !height}
;;




let width_object left top width height MouseCoord=
  let left  = gr_to_real_coord left
  and top   = gr_to_real_coord top
  and height = gr_to_real_coord height
  and iwidth = gr_to_real_coord width in

  let dx=MouseCoord.x - (left + iwidth)
  and dy=MouseCoord.y - (top - height)
  and width=ref iwidth in
    let im1 = (get_image left (top - 6) 6 6)
    and im2 = (get_image (left + !width-6) (top - 6) 6 6)
    and im3 = (get_image (left + !width-6) (top - height) 6 6)
    and im4 = (get_image left (top - height) 6 6) in

      set_color black;
      fill_rect left (top - 6) 6 6;
      fill_rect (left + !width - 6) (top - 6) 6 6;
      fill_rect (left + !width - 6) (top - height) 6 6;
      fill_rect left (top - height) 6 6;
      UpdatePos left top;
      UpdateSize !width height;

  while (
    let Event=(get_event([Button_up; Mouse_motion])) in
      draw_image im2 (left + !width-6) (top - 6);
      draw_image im3 (left + !width-6) (top - height);
      width := gr_to_real_coord (gr_to_win_coord(max min_size (Event.mouse_x-dx-left)));
      Event.button
        )
  do

        (
          blit_image im2 (left + !width - 6) (top - 6);
          blit_image im3 (left + !width - 6) (top - height);
          fill_rect (left + !width - 6) (top - 6) 6 6;
          fill_rect (left + !width - 6) (top - height) 6 6;
          UpdateSize !width height
  ) done;
  draw_image im1 left (top - 6);
  draw_image im4 left (top - height);

  (gr_to_win_coord !width)
;;


let height_object left top width height MouseCoord=
  let left  = gr_to_real_coord left
  and top   = gr_to_real_coord top
  and width = gr_to_real_coord width
  and iheight= gr_to_real_coord height in

  let dx=MouseCoord.x - (left + width)
  and dy=MouseCoord.y - (top - iheight)
  and height=ref iheight in
    let im1 = (get_image left (top - 6) 6 6)
    and im2 = (get_image (left + width - 6) (top - 6) 6 6)
    and im3 = (get_image (left + width - 6) (top - !height) 6 6)
    and im4 = (get_image left (top - !height) 6 6) in

      set_color black;
      fill_rect left (top - 6) 6 6;
      fill_rect (left+width - 6) (top - 6) 6 6;
      fill_rect (left+width - 6) (top - !height) 6 6;
      fill_rect left (top - !height) 6 6;
      UpdatePos left top;
      UpdateSize width !height;

  while (
    let Event=(get_event([Button_up; Mouse_motion])) in
      draw_image im3 (left + width-6) (top - !height);
      draw_image im4 left (top - !height);
      height :=gr_to_real_coord (gr_to_win_coord (max min_size (dy-Event.mouse_y+top)));
      Event.button
        )
  do

        (
          blit_image im3 (left + width - 6) (top - !height);
          blit_image im4 left (top - !height);
          fill_rect (left + width - 6) (top - !height) 6 6;
          fill_rect left (top - !height) 6 6;
          UpdateSize width !height
  ) done;
  draw_image im1 left (top-6);
  draw_image im2 (left + width - 6) (top - 6);

  (gr_to_win_coord !height)
;;

