#open "sys";;
#open "printexc";;

#open "windows";;
#open "camlwin";;

#open "strbrk";; 
#open "camlprog";;
#open "projprog";;
#open "cfgprog";;
#open "linkprog";;
#open "compprog";;
#open "extprog";;

#open "camlicon";;
#open "newicon";;
#open "camldraw";;
#open "globdraw";;
#open "objdraw";;
#open "funcdraw";;



let edited_file_name = ref "";;
let proj_name  = ref "";;
let proj_saved = ref true;;
let proj_pos   = ref [| (0,0) |];;
  proj_pos := [| |];;





(****************************************************************************)
(*                                                                          *)
(****************************************************************************)
let SaveFile Obj Event =
  if prog_text.tx_modified
  then
  (
    if !edited_file_name=""
    then edited_file_name := gr_input_filename "File's Name:" "tmp.ml"
    else
    (
      let name = gr_without_suffix !edited_file_name in
      try
        remove (name ^ ".bak")
      with _ -> ();
      try
        rename !edited_file_name (name ^ ".bak")
      with _ -> ()
    );
    let file=open_out !edited_file_name in
      gr_text_save prog_text file;
    close_out file
  );
  true
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let SaveProj Obj Event =
  if !proj_name = ""
  then proj_name := gr_input_string "Project's Name:" "";
  let file = open_out (!proj_name ^ ".prj") in
    output_string file ("Camlprog Project V" ^ 
                           (string_of_float CamlprogVersion) ^ "\n");
    gr_list_save proj_list file;
  close_out file;
  let file = open_out (!proj_name ^ ".cfg") in
    SaveConfigMake file;
    SaveLinkCfg file;
  close_out file;
  proj_saved := true;
  true
;;








(****************************************************************************)
(*                                                                          *)
(****************************************************************************)

let NewFile Obj Event =
  let DoNewFile () =
    prog_text.tx_name <- gr_lines_of_string "";
    gr_text_init prog_text;
    gr_draw_text prog_text;
    edited_file_name := "";
    true
  in
    if prog_text.tx_modified
    then
    (
      gr_warning ("The file " ^ !edited_file_name ^ " isn't saved. Save it ?")
                [| {warn_name="Yes";
                    warn_callback=gr_warning1};
                   {warn_name="No";
                    warn_callback=gr_warning2};
                   {warn_name="Cancel";
                    warn_callback=gr_warning3}
                 |];
      match gr_warn_button () with
        gr_ans1 -> SaveFile Obj Event;
                   DoNewFile ()
      | gr_ans2 -> DoNewFile ()
      | gr_ans3 -> false
    )
    else DoNewFile ()
;;





let SaveFileAs Obj Event =
  edited_file_name := "";
  prog_text.tx_modified <- true;
  SaveFile Obj Event
;;


let LoadFile Obj Event =
  let DoLoadFile () =
    let file_name = gr_select_file "*.*" in
    if not file_name = ""
    then
    (
      edited_file_name := file_name;
      try
        let file=open_in !edited_file_name in
          gr_text_load prog_text file;
        close_in file;
        true
      with Sys_error b -> false
    )
    else false
  in
    if prog_text.tx_modified
    then
    (
      gr_warning ("The file " ^ !edited_file_name ^ " isn't saved. Save it ?")
                [| {warn_name="Yes";
                    warn_callback=gr_warning1};
                   {warn_name="No";
                    warn_callback=gr_warning2};
                   {warn_name="Cancel";
                    warn_callback=gr_warning3}
                 |];
      match gr_warn_button () with
        gr_ans1 -> SaveFile Obj Event;
                   DoLoadFile ()
      | gr_ans2 -> DoLoadFile ()
      | gr_ans3 -> false
    )
    else DoLoadFile ()
;;


let ExitFile Obj Event =
  let Quit () =
    if prog_text.tx_modified
    then
    (
      gr_warning ("The file " ^ !edited_file_name ^ " isn't saved. Save it ?")
                [| {warn_name="Yes";
                    warn_callback=gr_warning1};
                   {warn_name="No";
                    warn_callback=gr_warning2};
                   {warn_name="Cancel";
                    warn_callback=gr_warning3}
                 |];
      match gr_warn_button () with
        gr_ans1 -> SaveFile Obj Event;
                   gr_quit_callback Obj Event
      | gr_ans2 -> gr_quit_callback Obj Event
      | gr_ans3 -> false
    )
    else gr_quit_callback Obj Event
  in
    if not !proj_saved
    then
    (
      gr_warning ("The project " ^ !proj_name ^ " isn't saved. Save it ?")
                  [| {warn_name="Yes";
                      warn_callback=gr_warning1};
                     {warn_name="No";
                      warn_callback=gr_warning2};
                     {warn_name="Cancel";
                      warn_callback=gr_warning3}
                   |];
       match gr_warn_button () with
        gr_ans1 -> SaveProj Obj Event;
                   Quit ()
      | gr_ans2 -> Quit ()
      | gr_ans3 -> false
    )
    else Quit ()
;;





file_new.it_callback    <- NewFile;;
file_load.it_callback   <- LoadFile;;
file_save.it_callback   <- SaveFile;;
file_saveas.it_callback <- SaveFileAs;;
file_exit.it_callback   <- ExitFile;;





(****************************************************************************)
(*                                                                          *)
(****************************************************************************)
let nu_old_file = ref 0;;

let ChangeEditedFile Obj Event =
  !proj_pos.(!nu_old_file) <- (prog_text.tx_cursor, prog_text.tx_line);
  SaveFile Obj Event;
  let n=vect_length proj_list.li_items in
  if n>0
  then
  (
    let file_name=proj_list.li_items.(proj_list.li_nu_item) in
      let suff=gr_suffix_only file_name in
        if suff="zo" or suff="zi"
        then true
        else
        (
          try
          (
            let file=(open_in file_name) in
              gr_text_load prog_text file;
            close_in file;
            set_current_window prog_win.win_def.win_id;
            gr_text_goto prog_text !proj_pos.(proj_list.li_nu_item);
            nu_old_file := proj_list.li_nu_item;
            gr_draw_text prog_text;
            edited_file_name := file_name;
            true
          )
          with Sys_error b -> false
        )
  )
  else false
;;






let NewProj Obj Event =
  let DoNewProj () =
    proj_list.li_items <- [| |];
    proj_name := "";
    proj_pos := [| |];
    while !proj_name="" do
      proj_name := gr_without_suffix (gr_input_string "Project name:" "")
    done;
    change_proj_title !proj_name;
    proj_saved := true;
    InitConfigMake (); 
    InitLinkCfg ();
    if proj_win.win_def.win_state=Created
    then ( gr_draw_list proj_list; true)
    else gr_create_window proj_win.win_def
  in
    if not !proj_saved
    then
    (
      gr_warning ("The project " ^ !proj_name ^ " isn't saved. Save it ?")
                  [| {warn_name="Yes";
                      warn_callback=gr_warning1};
                     {warn_name="No";
                      warn_callback=gr_warning2};
                     {warn_name="Cancel";
                      warn_callback=gr_warning3}
                  |];
      match gr_warn_button () with
        gr_ans1 -> SaveProj Obj Event;
                   DoNewProj ()
      | gr_ans2 -> DoNewProj ()
      | gr_ans3 -> false
    )
    else DoNewProj ()
;;






let LoadProj Obj Event =
  let DoLoadProj () =
    let new_proj = gr_select_file "*.prj" in
    if not new_proj = ""
    then
    (
      proj_name := gr_without_suffix new_proj;
      change_proj_title !proj_name;
      try
      (
        let file = open_in new_proj in
          let fst_line = input_line file in
            let strvect = break_str fst_line " " in
              let len = vect_length strvect in
                if len < 3
                then seek_in file 0
                else
                (
                  match strvect.(0),strvect.(1),strvect.(2) with
                    "Camlprog", "Project", "V0.8" -> ()
                  | _ -> seek_in file 0
                );
          gr_list_load proj_list file;
        close_in file;
        if proj_win.win_def.win_state=Created
        then ( gr_draw_list proj_list; true)
        else gr_create_window proj_win.win_def;
        proj_saved := true;
        InitLinkCfg ();
        InitConfigMake ();
        proj_pos := make_vect (vect_length proj_list.li_items) (0,0);
       
        (
          try
          (
            let file = open_in (!proj_name ^ ".cfg") in
              LoadConfigMake file;
              LoadLinkCfg file;
            close_in file
          )
          with Sys_error b -> ()
             | End_of_file -> ()
        );
        true
      )
      with Sys_error b -> false
    )
    else false
  in
    if not !proj_saved
    then
    (
      gr_warning ("The project " ^ !proj_name ^ " isn't saved. Save it ?")
                  [| {warn_name="Yes";
                      warn_callback=gr_warning1};
                     {warn_name="No";
                      warn_callback=gr_warning2};
                     {warn_name="Cancel";
                      warn_callback=gr_warning3}
                  |];
      match gr_warn_button () with
        gr_ans1 -> SaveProj Obj Event;
                   DoLoadProj ()
      | gr_ans2 -> DoLoadProj ()
      | gr_ans3 -> false
    )
    else DoLoadProj ()
;;




let AddFileProj Obj Event =
  let new_file = gr_select_file "*.*"
  and n = vect_length proj_list.li_items in
    if new_file = ""
    then false
    else
    (
      gr_list_add_item proj_list new_file n;
      proj_pos := concat_vect !proj_pos [| (0,0) |];
      proj_saved := false;
      edited_file_name := new_file;
      gr_draw_list proj_list;
      ChangeEditedFile Obj Event
    )
;;



let InsFileProj Obj Event =
  let new_file = gr_select_file "*.*"
  and n = proj_list.li_nu_item 
  and len = vect_length proj_list.li_items in
    if new_file = ""
    then false
    else
    (
      if len = 0
      then
      (
        gr_list_add_item proj_list new_file len;
        proj_pos := concat_vect !proj_pos [| (0,0) |]
      )
      else
      (
        gr_list_add_item proj_list new_file n;
        let vect_bef = sub_vect !proj_pos 0 n
        and vect_aft = sub_vect !proj_pos n (len-n) in
          proj_pos := concat_vect vect_bef 
                                  (concat_vect [| (0,0) |] vect_aft );
        if n <= !nu_old_file then nu_old_file := !nu_old_file + 1
      );
      proj_saved := false;
      edited_file_name := new_file;
      gr_draw_list proj_list;
      ChangeEditedFile Obj Event
    )
;;



let DelFileProj Obj Event =
  let n = proj_list.li_nu_item 
  and len = vect_length proj_list.li_items in
    if not len = 0
    then
    (
      gr_list_del_item proj_list n;
      let vect_bef = sub_vect !proj_pos 0 n
      and vect_aft = sub_vect !proj_pos (n+1) (len-n-1) in
        proj_pos := concat_vect vect_bef vect_aft;
        if n >= !nu_old_file then nu_old_file := max 0 (!nu_old_file - 1);
      proj_saved := false;
      if proj_win.win_def.win_state = Created
      then gr_draw_list proj_list;
      ChangeEditedFile Obj Event
    )
    else false
;;


let ConfigProj Obj Event =
  OpenConfProgWin ();
  proj_saved := false;
  true
;;



proj_new.it_callback  <- NewProj;;
proj_load.it_callback <- LoadProj;;
proj_save.it_callback <- SaveProj;;
proj_add.bt_callback  <- AddFileProj;;
proj_ins.bt_callback  <- InsFileProj;;
proj_del.bt_callback  <- DelFileProj;;
proj_cfglink.bt_callback  <- LinkCallback;;
proj_cfgmake.bt_callback <- ConfigProj;;
proj_list.li_callback <- ChangeEditedFile;;



let Search Obj Event =
  gr_find_in_text prog_text Event.mouse_x Event.mouse_y;
  gr_draw_text prog_text;
  true
;;

let Replace Obj Event =
  gr_replace_in_text prog_text Event.mouse_x Event.mouse_y;
  gr_draw_text prog_text;
  true
;;

let GotoLine Obj Event =
  let line=gr_input_natural "Goto line number :" 0 in
      gr_text_goto prog_text (0,line+1);
      gr_draw_text prog_text;
    true
;;


search_find.it_callback <- Search;;
search_line.it_callback <- GotoLine;;
search_replace.it_callback <- Replace;;


let Copy Obj Event =
  gr_copy_text (gr_get_selected_text prog_text);
  true
;;

let Past Obj Event =
  gr_add_text prog_text (gr_past_text ());
  gr_draw_text prog_text;
  true
;;

let Cut Obj Event =
  gr_copy_text (gr_get_selected_text prog_text);
  gr_del_selected_text prog_text;
  gr_draw_text prog_text;
  true
;;

let Clear Obj Event =
  gr_del_selected_text prog_text;
  gr_draw_text prog_text;
  true
;;


edit_copy.it_callback <- Copy;;
edit_past.it_callback <- Past;;
edit_cut.it_callback <- Cut;;
edit_clear.it_callback <- Clear;;






exec_camldraw.it_callback <- ExecCamldraw;;
exec_camlicon.it_callback <- ExecCamlicon;;
exec_shell.it_callback <- WinShell;;




let ToplevelCallback Obj Event =
  if prog_text.tx_s_select=prog_text.tx_e_select
  then gr_warning ("There isn't selected text to send to toplevel!")
                  [| {warn_name="Ok";
                      warn_callback=gr_close_warning}
                  |]
  else ToToplevel (gr_get_selected_text prog_text);
  true
;;


let CompileCallback Obj Event =
  SaveFile Obj Event;
  if Compile !edited_file_name
  then gr_warning ("The file " ^ !edited_file_name ^ " was succesfully compiled.")
                      [| {warn_name="Ok";
                          warn_callback=gr_close_warning}
                      |];
  true
;;

let LinkCallback Obj Event =
  let ExeName= if !proj_name=""
               then (* single file program *)
                 gr_without_suffix !edited_file_name
               else (* multiple files program *)
                 gr_without_suffix !proj_name
  and FilesNames= if !proj_name=""
                  then (* single file program *)
                    [| !edited_file_name |]
                  else (* multiple files program *)
                    proj_list.li_items in
    let linked=Link ExeName FilesNames in
      if linked
      then gr_warning ("The file " ^ ExeName ^ " was succesfully linked.")
                      [| {warn_name="Ok";
                          warn_callback=gr_close_warning}
                      |];
      true
;;


let MakeCallback Obj Event =
  SaveFile Obj Event;
  let ExeName= if !proj_name=""
               then (* single file program *)
                 gr_without_suffix !edited_file_name
               else (* multiple files program *)
                 gr_without_suffix !proj_name
  and FilesNames= if !proj_name=""
                  then (* single file program *)
                    [| !edited_file_name |]
                  else (* multiple files program *)
                    proj_list.li_items in
    let made=Make ExeName  FilesNames in
      if made
      then gr_warning ("The file " ^ ExeName ^ " was succesfully created.")
                      [| {warn_name="Ok";
                          warn_callback=gr_close_warning}
                      |];
      true
;;


let BuildCallback Obj Event =
  SaveFile Obj Event;
  let ExeName= if !proj_name=""
               then (* single file program *)
                 gr_without_suffix !edited_file_name
               else (* multiple files program *)
                 gr_without_suffix !proj_name
  and FilesNames= if !proj_name=""
                  then (* single file program *)
                    [| !edited_file_name |]
                  else (* multiple files program *)
                    proj_list.li_items in
    let made=Build ExeName FilesNames in
      if made
      then gr_warning ("The file " ^ ExeName ^ " was succesfully created.")
                      [| {warn_name="Ok";
                          warn_callback=gr_close_warning}
                      |];
      true
;;



let CleanCallback Obj Event =
  SaveFile Obj Event;
  let ExeName= if !proj_name=""
               then (* single file program *)
                 gr_without_suffix !edited_file_name
               else (* multiple files program *)
                 gr_without_suffix !proj_name
  and FilesNames= if !proj_name=""
                  then (* single file program *)
                    [| !edited_file_name |]
                  else (* multiple files program *)
                    proj_list.li_items in
    Clean ExeName FilesNames ;
      true
;;



let RunCallback Obj Event =
  SaveFile Obj Event;
  let ExeName= if !proj_name=""
               then (* single file program *)
                 gr_without_suffix !edited_file_name
               else (* multiple files program *)
                 gr_without_suffix !proj_name
  and FilesNames= if !proj_name=""
                  then (* single file program *)
                    [| !edited_file_name |]
                  else (* multiple files program *)
                    proj_list.li_items in
    Run ExeName FilesNames;
    true
;;


run_toplevel.it_callback <- ToplevelCallback;;
run_compile.it_callback <- CompileCallback;;
run_link.it_callback <- LinkCallback;;
run_make.it_callback <- MakeCallback;;
run_build.it_callback <- BuildCallback;;
run_clean.it_callback <- CleanCallback;;
run_run.it_callback  <- RunCallback;;







f gr_main_loop [prog_win; proj_win; gr_shell;
                CamldrawWin; DesignWin; ObjectWin; FuncWin;
                CamliconWin; NewiconWin
               ];;


