#open "windows";;
#open "camlwin";;

#open "sys";;


#open "confdraw";;
#open "globdraw";;
#open "cfgdraw";;
#open "deldraw";;
#open "camldraw";;
#open "savedraw";;
#open "objdraw";;
#open "funcdraw";;
#open "tooldraw";;
#open "scrodraw";;
#open "windraw";;

#open "add_draw";;
#open "evendraw";;

#open "saveicon";;
#open "camlicon";;
#open "newicon";;
#open "icondraw";;







(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let collect_event =
{
  us_window=design_win;
  us_param=[| |];
  us_draw= do_nothing1;
  us_callback= CollectEvent
};;


DesignWin.win_objects <- [g_user collect_event];;








(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let update_menu_vect MenuVect =
  let rec update_menu_vect_loop Pos Result Length =
    if Pos=Length
    then Result
    else update_menu_vect_loop (Pos+1)
                              (concat_vect Result
                                           [| MenuVect.(Pos).mn_name |])
                              Length
  in
    update_menu_vect_loop 0 [| |] (vect_length MenuVect)
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let update_item_vect ItemVect =
  let rec update_item_vect_loop Pos Result Length=
    if Pos=Length
    then Result
    else update_item_vect_loop (Pos+1)
                              (concat_vect Result [| ItemVect.(Pos).it_name |])
                              Length
  in
    let n=(vect_length ItemVect) in
      update_item_vect_loop 0 [| |] n
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbUpdateMenu () =
  if (had_toolbar DesignWin.win_objects)
  then
  (
    let Toolb=get_toolbar DesignWin.win_objects in
      toolb_menu.li_items <- update_menu_vect Toolb.tb_items
  )
  else
  (
    toolb_def := [| |];
    toolb_menu.li_items <- [| |]
  );
  if cfg_toolb.win_def.win_state = Created
  then gr_draw_list toolb_menu;
  true
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbUpdateItem ()=
  if had_toolbar DesignWin.win_objects
  then
  (
    let Toolb=get_toolbar DesignWin.win_objects in
      if not (vect_length Toolb.tb_items)=0
      then
      (
        let Menu=(Toolb.tb_items.(toolb_menu.li_nu_item)) in
          toolb_item.li_items <- update_item_vect Menu.mn_items
      )
      else
      (
        toolb_def := [| |];
        toolb_menu.li_items <- [| |]
      )
  )
  else
  (
    toolb_def := [| |];
    toolb_menu.li_items <- [| |]
  );
  if cfg_toolb.win_def.win_state = Created
  then gr_draw_list toolb_item;
  true
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbAddMenu Obj Event =
  AddMenu ();
  ToolbUpdateMenu ();
  ToolbUpdateItem ()
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbDelMenu Obj Event =
  let Toolb=get_toolbar DesignWin.win_objects in
    if not (vect_length Toolb.tb_items)=0
    then
    (
      DelMenu toolb_menu.li_nu_item;
      window_saved := false;
      ToolbUpdateMenu ();
      ToolbUpdateItem ()
    )
    else false
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbEditMenu Obj Event =
  let Toolb=get_toolbar DesignWin.win_objects in
    if not (vect_length Toolb.tb_items)=0
    then
      (
        ConfigMenu toolb_menu.li_nu_item;
        window_saved := false;
        ToolbUpdateMenu ()
      )
    else false
;;





(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbUpdateItemCallback Obj Event =
  ToolbUpdateItem ()
;;

(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbAddItem Obj Event =
  let Toolb=get_toolbar DesignWin.win_objects in
    if not (vect_length Toolb.tb_items)=0
    then
      (
        AddItem ();
        ToolbUpdateItem ()
      )
    else false
;;

(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbDelItem Obj Event =
  let Toolb=get_toolbar DesignWin.win_objects in
    if not (vect_length Toolb.tb_items)=0
    then
    (
      DelItem toolb_menu.li_nu_item toolb_item.li_nu_item;
      window_saved := false;
      ToolbUpdateItem ()
    )
    else false
;;

(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ToolbEditItem Obj Event =
  let Toolb=get_toolbar DesignWin.win_objects in
    if not (vect_length Toolb.tb_items)=0
    then
    (
      ConfigItem toolb_menu.li_nu_item toolb_item.li_nu_item;
      window_saved := false;
      ToolbUpdateItem ()
    )
    else false
;;




toolb_add_menu.bt_callback <- ToolbAddMenu;;
toolb_del_menu.bt_callback <- ToolbDelMenu;;
toolb_edit_menu.bt_callback <- ToolbEditMenu;;
toolb_menu.li_callback <- ToolbUpdateItemCallback;;
toolb_add_item.bt_callback <- ToolbAddItem;;
toolb_del_item.bt_callback <- ToolbDelItem;;
toolb_edit_item.bt_callback <- ToolbEditItem;;








(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let SaveWindow Obj Event =
  if !window_file_name=""
  then window_file_name := gr_without_suffix(gr_input_filename "File's Name" "win");
  let out=(open_out_bin (!window_file_name ^ ".drw")) in
    gr_output_window out { win_def = DesignWin.win_def;
                           win_objects = without_first DesignWin.win_objects;
                           time_callback = gr_do_nothing;
                           resize_callback = gr_do_nothing;
                           help_file = "";
                           miscellaneous = [| |]
                         };
    output_value out !window_name;
    output_value out !obj_def;
    output_value out !toolb_def;
    output_value out !callbacks_def;
    close_out out;
  let out=(open_out (!window_file_name ^ ".ml")) in
    save {
          win_def=DesignWin.win_def;
          win_objects=without_first DesignWin.win_objects;
          time_callback = gr_do_nothing;
          resize_callback = gr_do_nothing;
          help_file = "";
          miscellaneous = [| |]
         }
         !window_name
         cwin_help.st_name
         cwin_time.st_name
         "gr_do_nothing"
         (without_first !obj_def)
         !toolb_def
         !callbacks_def
         out;
    close_out out;
    window_saved := true;
    true
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let NewWindow Obj Event =
  let DoNew () =
    cwin_help.st_name <- "";
    cwin_time.st_name <- "gr_do_nothing";
    cwin_name.st_name <- "win";
    ConfigWin ();
    if !win_erase
    then
    (
      design_win.win_top <- (gr_to_real_coord design_win.win_height)+10;
      design_win.win_left <- 10;
      DesignWin.win_objects <- [ g_user collect_event ];
      window_saved := true;
      window_file_name := "";
      obj_def := [ {id_name=""; callback=""; images_names=[||]} ];
      toolb_def := [| |];
      callbacks_def:= [];
      UpdateObject (id_name_vect !obj_def !toolb_def);
      UpdateFunc (FunctionsNames ());

      if design_win.win_state=Created
      then
      (
        let height=gr_to_real_coord design_win.win_height
        and width =gr_to_real_coord design_win.win_width in
          set_current_window design_win.win_id;
          set_window_car design_win.win_left
                         (design_win.win_top-height)
                         width height;
        true
      )
      else gr_create_window design_win
    )
    else false
  in
    if not !window_saved
    then
    (
      gr_warning ("The window " ^ !window_file_name ^ " isn't saved. Save it ?")
                [| {warn_name="Yes";
                    warn_callback=gr_warning1};
                   {warn_name="No";
                    warn_callback=gr_warning2};
                   {warn_name="Cancel";
                    warn_callback=gr_warning3}
                 |];
      match gr_warn_button () with
        gr_ans1 -> SaveWindow Obj Event;
                   DoNew ()
      | gr_ans2 -> DoNew ()
      | gr_ans3 -> false
    )
    else DoNew ()
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let SaveWindowAs Obj Event =
  window_file_name := "";
  SaveWindow Obj Event
;;








(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let LoadWindow Obj Event =
  let DoLoad () =
    window_file_name := gr_without_suffix (gr_select_file "*.drw");
    try
      (
        let file=(open_in_bin (!window_file_name ^ ".drw")) in
          let Window=(gr_input_window file design_win) in
            DesignWin.win_objects <- [ g_user collect_event ] @ Window.win_objects;
          window_name := (input_value file : string);
          obj_def := (input_value file :object_cfg_type list);
          toolb_def := (input_value file :toolbar_cfg_type vect);
          callbacks_def := (input_value file :string list);
          UpdateObject (id_name_vect !obj_def !toolb_def);
          UpdateFunc (FunctionsNames ());
          ToolbUpdateMenu ();
          ToolbUpdateItem ();

        close_in file;
        window_saved := true;
        if design_win.win_state=Created
        then
        (
          let height=gr_to_real_coord design_win.win_height
          and width =gr_to_real_coord design_win.win_width
          and pos = window_pos design_win.win_id in
            design_win.win_left <- fst pos;
            design_win.win_top <- (snd pos)+height;
            set_current_window design_win.win_id;
            set_window_car design_win.win_left
                           (design_win.win_top-height)
                           width
                           height;
          true
        )
        else gr_create_window design_win
      )
    with Sys_error b -> false
  in
    if not !window_saved
    then
    (
      gr_warning ("The window " ^ !window_file_name ^ " isn't saved. Save it ?")
                [| {warn_name="Yes";
                    warn_callback=gr_warning1};
                   {warn_name="No";
                    warn_callback=gr_warning2};
                   {warn_name="Cancel";
                    warn_callback=gr_warning3}
                 |];
      match gr_warn_button () with
        gr_ans1 -> SaveWindow Obj Event;
                   DoLoad ()
      | gr_ans2 -> DoLoad ()
      | gr_ans3 -> false
    )
    else DoLoad ()
;;















(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let EditNewCallback Item Event =
  EditCallback "";
  true
;;


let EditNewFunction Item Event =
  add_callback (gr_edit "Function:" "let ");
  UpdateFunc (FunctionsNames ());
  true
;;


let WindowFunc Obj Event =
  gr_create_window FuncWin.win_def
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let ResizeWindow Obj Event =
  ConfigWin ();
  if design_win.win_state=Created
  then
    (
      let height=gr_to_real_coord design_win.win_height
      and width =gr_to_real_coord design_win.win_width in
        set_current_window design_win.win_id;
        set_window_car design_win.win_left
                       (design_win.win_top-height)
                       width height;
        true
    )
  else false
;;

let WindowPos Obj Event =
   let coord=(window_pos design_win.win_id) in
     design_win.win_left <- (fst coord);
     design_win.win_top <- ((snd coord)+(gr_to_real_coord design_win.win_height));
     true
;;

let WindowObjects Obj Event =
  gr_create_window ObjectWin.win_def;
  true
;;

(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let DelAnObject Obj Event =
  let n = obj_list.li_nu_item
  and Toolbar = if had_toolbar DesignWin.win_objects
                then get_toolbar DesignWin.win_objects
                else { tb_window = gr_std_win;
                       tb_items = [| |]
                     }
  in
    let obj = Wich_object n
                          (without_first DesignWin.win_objects)
                          Toolbar
    in
      DelObject obj;
      true
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let EditObject Obj Event =
  let n = obj_list.li_nu_item
  and Toolbar = if had_toolbar DesignWin.win_objects
                then get_toolbar DesignWin.win_objects
                else { tb_window = gr_std_win;
                       tb_items = [| |]
                     }
  in
    let obj = Wich_object n
                          (without_first DesignWin.win_objects)
                          Toolbar
    in
      ConfigObject obj;
      true
;;


obj_del.bt_callback <- DelAnObject;;
obj_cfg.bt_callback <- EditObject;;




let EditTimeCallback Obj Event =
  EditCallback cwin_time.st_name;
  true
;;

cwin_timecallback.bt_callback <- EditTimeCallback;





drawnew_file.it_callback <- NewWindow;;
drawload_file.it_callback <- LoadWindow;;
drawsave_file.it_callback <- SaveWindow;;
drawsaveas_file.it_callback <- SaveWindowAs;;


drawedit_func.it_callback <- EditNewCallback;;
drawnew_func.it_callback <- EditNewFunction;;
drawlist_func.it_callback <- WindowFunc;;

drawresize_window.it_callback <- ResizeWindow;;
drawlist_window.it_callback <- WindowObjects;;
drawpos_window.it_callback <- WindowPos;;

camldraw_buttons.gb_callback <- AddObject;;












