#open "windows";;
#open "camlwin";;
#open "sys";;
#open "printexc";;

#open "camlicon";;
#open "newicon";;
#open "saveicon";;







let SaveModifThenQuit Obj Event =
  gr_close_warning Obj Event;
  SaveIcon Obj Event;
  gr_copy_text !icon_file;
  gr_quit_callback Obj Event;;

let Quit Obj Event =
  gr_copy_text !icon_file;
  if !icon_modified
  then
    (
      gr_warning ("The modifications aren't saved. Save them ?")
                 [| {warn_name="Yes"; warn_callback=SaveModifThenQuit};
                    {warn_name="No"; warn_callback=gr_quit_callback};
                    {warn_name="Cancel"; warn_callback=gr_close_warning}
                 |];
      true
    )
  else gr_quit_callback Obj Event;;


iconexit_file.it_callback <- Quit;;






  (* load a file if a name is passed in argument *)
if vect_length command_line>=2
then
(
  let Name=(gr_without_suffix command_line.(1)) in
    load_icon Name
);;


f gr_main_loop [ CamliconWin; NewiconWin ];;

