#open "windows";;
#open "camlwin";;

#open "printexc";;

#open "camldraw";;
#open "camlicon";;
#open "newicon";;
#open "funcdraw";;
#open "objdraw";;

#open "maindraw";;
#open "globdraw";;



let ExitFile Obj Event =
  if not !window_saved
  then
  (
    gr_warning ("The window " ^ !window_file_name ^ " isn't saved. Save it ?")
              [| {warn_name="Yes";
                  warn_callback=gr_warning1};
                 {warn_name="No";
                  warn_callback=gr_warning2};
                 {warn_name="Cancel";
                  warn_callback=gr_warning3}
               |];
    match gr_warn_button () with
      gr_ans1 -> SaveWindow Obj Event;
                 gr_quit_callback Obj Event
    | gr_ans2 -> gr_quit_callback Obj Event
    | gr_ans3 -> false
  )
  else gr_quit_callback Obj Event
;;


drawexit_file.it_callback <- ExitFile;;


f gr_main_loop [CamldrawWin; DesignWin; ObjectWin; FuncWin;
                CamliconWin; NewiconWin ];;

