#open "camlwin";;
#open "sys";;
#open "sort";;



(***************************************************************************)
(*                                                                         *)
(*      to_upper : string -> string                                        *)
(*                                                                         *)
(***************************************************************************)
let int_of_A = int_of_char `A`;;
let int_of_a = int_of_char `a`;;

let char_to_upper a =
  match a with
   `a`..`z` -> char_of_int ( int_of_A + (int_of_char a) - int_of_a)
  | _      -> a
;;

let to_upper Str =
  let len = string_length Str in
    let Mstr = make_string len ` ` in
      for i = 0 to (len - 1) do
        set_nth_char Mstr i (char_to_upper (nth_char Str i))
      done;
  Mstr
;;







let Anchor_to_string Anchor =
  "<A " ^
  (match Anchor.AnchorType with
       HREF-> "HREF"
     | _   -> "NAME"
  ) ^
  "=\"" ^ Anchor.AnchorFile ^
  "\">" ^ Anchor.AnchorName ^ "</A>"
;;





let rec ExtractAnchor2 List =
  match List with
   []    -> []
  | x::y -> if x.AnchorType = NAME
            then x::(ExtractAnchor2 y)
            else ExtractAnchor2 y
;;


let TransformAnchors Anchors FileName =
  let rec trans_anchor List =
    match List with
      []   -> ()
    | x::y -> x.AnchorType <- HREF;
              x.AnchorFile <- FileName ^ "#" ^ x.AnchorFile;
              trans_anchor y
  in
    trans_anchor Anchors
;;


let search_name Str =
  let len = string_length Str in
    let rec diese_loop pos =
      if pos = len 
      then Str
      else if nth_char Str pos = `#`
           then sub_string Str (pos+1) (len-pos-1)
           else diese_loop (pos+1)
    in
      diese_loop 0
;;

let CompareAnchor A1 A2 =
  let str1 = search_name A1.AnchorName 
  and str2 = search_name A2.AnchorName in
    lt_string (to_upper str1) (to_upper str2)
;;






let SaveAnchorsList Anchors Channel =
  let save_letter = ref `A` in
  let rec loop Anchors =
    match Anchors with
     [] -> ()
    | x::y -> if not string_length x.AnchorName = 0
              then
              (
                let a = char_to_upper (nth_char x.AnchorName 0) in
                if int_of_char a >= int_of_char !save_letter
                then 
                (
                   output_string Channel ("<H2>" ^ 
                                          (char_for_read a) ^ 
                                          "</H2>\n");
                   save_letter := char_of_int ((int_of_char a)+1)
                );
                output_string Channel (Anchor_to_string x);
                output_string Channel "<BR>\n"
              );
              loop y
  in
    loop Anchors
;;


let CompileListAnchor vectFile =
  let out_file = vectFile.(2)
  and len = vect_length vectFile 
  and AnchorsList = ref [{ 
                          AnchorType = HREF; 
                          AnchorFile = ""; 
                          AnchorName = ""
                        }] in
    AnchorsList := [];
    print_string ("Output file = " ^ out_file);
    print_newline ();
    for i = 3 to (len -1) do
     (
       print_string ("Make Anchor List: " ^ vectFile.(i));
       print_newline ();
       let file = open_in vectFile.(i) in
         let html = gr_html_interpreter file in
           let anchors = ExtractAnchor2 (gr_html_anchor_list html) in
             TransformAnchors anchors vectFile.(i);
             AnchorsList := anchors @ !AnchorsList;
       close_in file
     )
     done;
     AnchorsList := sort CompareAnchor !AnchorsList;
     let file = open_out out_file in
       SaveAnchorsList !AnchorsList file;
     close_out file
;;
