#open "windows";;
#open "camlwin";;


#open "funcdraw";;



let cfg_list_def =
{
  win_left     = 20;
  win_top      = 320;
  win_width    = 150;
  win_height   = 125;
  win_id       = gr_undef_window;
  win_name     = "List configuration";
  win_state    = Destroyed
};;

let ins_list =
{
  bt_window   = cfg_list_def;
  bt_left     = 3;
  bt_top      = 70;
  bt_width    = 35;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ins item";
  bt_callback = gr_do_nothing
};;

let sort_list =
{
  bt_window   = cfg_list_def;
  bt_left     = 43;
  bt_top      = 53;
  bt_width    = 35;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "sort";
  bt_callback = gr_do_nothing
};;

let edit_list =
{
  bt_window   = cfg_list_def;
  bt_left     = 120;
  bt_top      = 98;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let list_prompt13 =
{
  pt_window   = cfg_list_def;
  pt_left     = 5;
  pt_top      = 95;
  pt_name     = "Callback:"
};;

let list_prompt12 =
{
  pt_window   = cfg_list_def;
  pt_left     = 5;
  pt_top      = 110;
  pt_name     = "Id name:"
};;

let ok_list =
{
  bt_window   = cfg_list_def;
  bt_left     = 32;
  bt_top      = 24;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let cancel_list =
{
  bt_window   = cfg_list_def;
  bt_left     = 85;
  bt_top      = 24;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let add_list =
{
  bt_window   = cfg_list_def;
  bt_left     = 3;
  bt_top      = 53;
  bt_width    = 35;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Add item";
  bt_callback = gr_do_nothing
};;

let del_list =
{
  bt_window   = cfg_list_def;
  bt_left     = 43;
  bt_top      = 70;
  bt_width    = 35;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Del item";
  bt_callback = gr_do_nothing
};;

let list_list =
{
  li_window   = cfg_list_def;
  li_left     = 82;
  li_top      = 81;
  li_width    = 50;
  li_height   = 50;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [| |];
  li_callback = gr_do_nothing
};;

let list_idname =
{
  st_window   = cfg_list_def;
  st_left     = 40;
  st_top      = 111;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let list_callback =
{
  st_window   = cfg_list_def;
  st_left     = 40;
  st_top      = 97;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let list_helpbar =
{
  hl_window   = cfg_list_def;
  hl_help     = "Press Ok when finished"
};;

let list_prompt0 =
{
  pt_window   = cfg_list_def;
  pt_left     = 40;
  pt_top      = 123;
  pt_name     = "List Configuration"
};;

let cfg_list =
{
  win_def      = cfg_list_def;
  win_objects  = [
                  g_button ins_list;
                  g_button sort_list;
                  g_button edit_list;
                  g_prompt list_prompt13;
                  g_prompt list_prompt12;
                  g_button ok_list;
                  g_button cancel_list;
                  g_button add_list;
                  g_button del_list;
                  g_list   list_list;
                  g_string list_idname;
                  g_string list_callback;
                  g_helpbar list_helpbar;
                  g_prompt list_prompt0
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;


let list_call=ref "";;
let list_id=ref "";;
let list_items=ref [| "" |];;

let list_init Id Callback Items =
  list_call := Callback;
  list_id := Id;
  list_items := Items;
  list_idname.st_cursor <-0;
  list_callback.st_cursor <-0;
  list_idname.st_1st_char <-0;
  list_callback.st_1st_char <-0;
  list_idname.st_name <- Id;
  list_callback.st_name <- Callback;
  list_list.li_items <- Items
;;


let list_restore () =
  list_idname.st_name <- !list_id;
  list_callback.st_name <- !list_call;
  list_list.li_items <- !list_items
;;



let CloseListCfg Button  Event =
  gr_erase_window cfg_list.win_def;;

let CancelListCfg Button Event =
  list_restore ();
  gr_erase_window cfg_list.win_def
;;

let EditListCfg Button Event =
  EditCallback list_callback.st_name;
  true
;;

let AddItemListCfg Button Event =
  gr_list_add_item list_list
                   (gr_input_string "Value:" "")
                   (vect_length list_list.li_items);
  gr_draw_list list_list;
  true
;;

let InsItemListCfg Button Event =
  gr_list_add_item list_list
                   (gr_input_string "Value:" "")
                   list_list.li_nu_item;
  gr_draw_list list_list;
  true
;;


let DelItemListCfg Button Event =
  gr_list_del_item list_list list_list.li_nu_item;
  gr_draw_list list_list;
  true
;;

let SortListCfg Button Event =
  gr_list_sort list_list;
  gr_draw_list list_list;
  true
;;


ok_list.bt_callback <- CloseListCfg;;
cancel_list.bt_callback <- CancelListCfg;;
edit_list.bt_callback <- EditListCfg;;
add_list.bt_callback <- AddItemListCfg;;
del_list.bt_callback <- DelItemListCfg;;
ins_list.bt_callback <- InsItemListCfg;;
sort_list.bt_callback <- SortListCfg;;


