#open "windows";;
#open "camlwin";;






let CfgLinkWin_def = 
{
  win_left     = 10;
  win_top      = 335;
  win_width    = 154;
  win_height   = 90;
  win_id       = gr_undef_window;
  win_name     = "Design window";
  win_state    = Destroyed
};;

let cfglink_pt_title = 
{
  expt_window = CfgLinkWin_def;
  expt_left   = 40;
  expt_top    = 84;
  expt_name   = { f_type=Proportional_font; 
                  f_att =Italic; 
                  f_size =Size1_font; 
                  f_color =black; 
                  f_string = "Link Configuration"}
};;

let cfglink_pt_goal = 
{
  pt_window   = CfgLinkWin_def;
  pt_left     = 2;
  pt_top      = 37;
  pt_name     = "Goal:"
};;

let cfglink_ok = 
{
  bt_window   = CfgLinkWin_def;
  bt_left     = 100;
  bt_top      = 17;
  bt_width    = 32;
  bt_height   = 13;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let cfglink_goal = 
{
  ga_window   = CfgLinkWin_def;
  ga_left     = 2;
  ga_top      = 32;
  ga_width    = 53;
  ga_height   = 25;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [|
                 "Binary";
                 "Library"
                |];
  ga_callback = gr_do_nothing
};;

let cfglink_pt_flags = 
{
  pt_window   = CfgLinkWin_def;
  pt_left     = 2;
  pt_top      = 68;
  pt_name     = "Flags:"
};;

let cfglink_flags = 
{
  st_window   = CfgLinkWin_def;
  st_left     = 16;
  st_top      = 70;
  st_width    = 60;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cfglink_helpindex = 
{
  ra_window   = CfgLinkWin_def;
  ra_left     = 92;
  ra_top      = 64;
  ra_state    = false;
  ra_name     = "Make index";
  ra_callback = gr_do_nothing
};;

let cfglink_helptitle = 
{
  ra_window   = CfgLinkWin_def;
  ra_left     = 92;
  ra_top      = 52;
  ra_state    = false;
  ra_name     = "Make Table of contents";
  ra_callback = gr_do_nothing
};;

let cfglink_area = 
{
  ar_window = CfgLinkWin_def;
  ar_name   = "Help Configuration";
  ar_left   = 86;
  ar_top    = 72;
  ar_width  = 64;
  ar_height = 44
};;

let cfglink_pt_tmpfile = 
{
  pt_window   = CfgLinkWin_def;
  pt_left     = 2;
  pt_top      = 44;
  pt_name     = "Tmp file:"
};;

let cfglink_tmpfile = 
{
  st_window   = CfgLinkWin_def;
  st_left     = 22;
  st_top      = 46;
  st_width    = 56;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;


let cfglink_pt_runflags = 
{
  pt_window   = CfgLinkWin_def;
  pt_left     = 2;
  pt_top      = 54;
  pt_name     = "Run option:"
};;

let cfglink_runflags = 
{
  st_window   = CfgLinkWin_def;
  st_left     = 30;
  st_top      = 56;
  st_width    = 48;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let cfglink_helpupdate = 
{
  ra_window   = CfgLinkWin_def;
  ra_left     = 92;
  ra_top      = 40;
  ra_state    = false;
  ra_name     = "Update Titles";
  ra_callback = gr_do_nothing
};;

let CfgLinkWin = 
{
  win_def      = CfgLinkWin_def;
  win_objects  = [
                  g_exprompt  cfglink_pt_title;
                  g_prompt    cfglink_pt_goal;
                  g_button    cfglink_ok;
                  g_grprad    cfglink_goal;
                  g_prompt    cfglink_pt_flags;
                  g_string    cfglink_flags;
                  g_prompt    cfglink_pt_runflags;
                  g_string    cfglink_runflags;
                  g_radio     cfglink_helpindex;
                  g_radio     cfglink_helptitle;
                  g_area      cfglink_area;
                  g_prompt    cfglink_pt_tmpfile;
                  g_string    cfglink_tmpfile;
                  g_radio     cfglink_helpupdate
                 ];
  time_callback  = gr_do_nothing;
  resize_callback  = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let help_index_file = ref ""
and help_title_file = ref ""
;;


let QuitCallback Obj Event =
  gr_erase_window CfgLinkWin.win_def;
  true
;;


cfglink_ok.bt_callback <- QuitCallback;;


let ConfigLink () =
  gr_block_loop CfgLinkWin
;;



let LinkCallback Obj Event =
  ConfigLink ();
  true
;;


let ConfigMakeIndex Obj Event =
  if cfglink_helpindex.ra_state
  then help_index_file := gr_input_filename "Index file's name:" "index.html";
  true
;;
  
cfglink_helpindex.ra_callback <- ConfigMakeIndex;;


let ConfigMakeTitle Obj Event =
  if cfglink_helptitle.ra_state
  then help_title_file := gr_input_filename "Title file's name:" "title.html";
  true
;;
  
cfglink_helptitle.ra_callback <- ConfigMakeTitle;;



let SaveLinkCfg Channel =
  if cfglink_goal.ga_radio = 0
  then output_string Channel "Binary\n"
  else output_string Channel "Library\n";
  output_string Channel (cfglink_flags.st_name ^"\n");
  output_string Channel (cfglink_tmpfile.st_name ^ "\n");
  if cfglink_helpindex.ra_state 
  then output_string Channel ("Index " ^ !help_index_file ^ "\n")
  else output_string Channel "NoIndex\n";
  if cfglink_helptitle.ra_state
  then output_string Channel ("Title " ^ !help_title_file ^ "\n")
  else output_string Channel "NoTitle\n";
  if cfglink_helpupdate.ra_state
  then output_string Channel "UpdateTile\n"
  else output_string Channel "NoUpdate\n";
  output_string Channel (cfglink_runflags.st_name ^"\n\n")
;;


let LoadLinkCfg Channel =
  let line = input_line Channel in
    if line = "Binary"
    then cfglink_goal.ga_radio <- 0
    else cfglink_goal.ga_radio <- 1;
  cfglink_flags.st_name <- input_line Channel;
  cfglink_tmpfile.st_name <- input_line Channel;
  let line = input_line Channel in
    if sub_string line 0 5 = "Index"
    then 
    (
      cfglink_helpindex.ra_state <- true;
      try
        help_index_file := sub_string line 6 ((string_length line)-6)
      with Invalid_argument _ -> help_index_file := ""
    )
    else cfglink_helpindex.ra_state <- false;
  let line = input_line Channel in
    if sub_string line 0 5 = "Title"
    then 
    (
      cfglink_helptitle.ra_state <- true;
      try
        help_title_file := sub_string line 6 ((string_length line)-6)
      with Invalid_argument _ -> help_title_file := ""
    )
    else cfglink_helptitle.ra_state <- false;
  let line = input_line Channel in
    if line = "UpdateTile"
    then cfglink_helpupdate.ra_state <- true
    else cfglink_helpupdate.ra_state <- false;
  try
    cfglink_runflags.st_name <- input_line Channel
  with _ -> cfglink_runflags.st_name <- ""
;;



let InitLinkCfg () =
  cfglink_goal.ga_radio <- 0;
  cfglink_flags.st_name <- "";
  cfglink_runflags.st_name <- "";
  cfglink_tmpfile.st_name <- "tmp.ml";
  cfglink_helpindex.ra_state <- false;
  cfglink_helptitle.ra_state <- false;
  cfglink_helpupdate.ra_state <- false
;;


InitLinkCfg ();;


