#open "windows";;
#open "camlwin";;


type Inside_type = Out
                 | Place
                 | Resize;;

let InsideArea left top width height Coord=
  let Pos_area={x1=left;
                y1=top-height;
                x2=left+width/2;
                y2=top}
  and Size_area={x1=left+width/2;
                 y1=top-height;
                 x2=left+width;
                 y2=top} in
    if gr_inside Coord Pos_area
    then Place
    else if gr_inside Coord Size_area
         then Resize
         else Out
;;


let inside_rect left top width height Coord=
  let Pos_area={x1=left;
                y1=top-height;
                x2=left+width;
                y2=top} in
    if gr_inside Coord Pos_area
    then Place
    else Out
;;




let inside_button Button Coord =
  let left  = gr_to_real_coord Button.bt_left
  and top   = gr_to_real_coord Button.bt_top
  and width = gr_to_real_coord Button.bt_width
  and height= gr_to_real_coord Button.bt_height in
    InsideArea left top width height Coord
;;



let inside_string String Coord =
  let left  = gr_to_real_coord String.st_left
  and top   = gr_to_real_coord String.st_top
  and width = gr_to_real_coord String.st_width
  and height= gr_text_height+4*gr_short_space in
    InsideArea left top width height Coord
;;



let inside_text Text Coord =
  let left  = gr_to_real_coord Text.tx_left
  and top   = gr_to_real_coord Text.tx_top
  and width = gr_to_real_coord Text.tx_width
  and height= gr_to_real_coord Text.tx_height in
    InsideArea left top width height Coord
;;


let inside_shell Shell Coord =
  let left  = gr_to_real_coord Shell.sh_left
  and top   = gr_to_real_coord Shell.sh_top
  and width = gr_to_real_coord Shell.sh_width
  and height= gr_to_real_coord Shell.sh_height in
    InsideArea left top width height Coord
;;



let inside_list List Coord =
  let left  = gr_to_real_coord List.li_left
  and top   = gr_to_real_coord List.li_top
  and width = gr_to_real_coord List.li_width
  and height= gr_to_real_coord List.li_height in
    InsideArea left top width height Coord
;;



let inside_helpbar Helpbar Coord =
  let height=gr_text_height + 2*gr_short_space+ 2*gr_long_space
  and width =gr_to_real_coord Helpbar.hl_window.win_width in
    inside_rect 0 height width height Coord
;;



let inside_prompt Prompt Coord =
  let size=text_size Prompt.pt_name in
    let width=(fst size)
    and height=(snd size)
    and left= gr_to_real_coord Prompt.pt_left
    and top = gr_to_real_coord Prompt.pt_top in
      inside_rect left top width height Coord
;;



let inside_exprompt exPrompt Coord =
  set_font exPrompt.expt_name.f_type
           exPrompt.expt_name.f_att
           exPrompt.expt_name.f_size;
  let size=text_size exPrompt.expt_name.f_string in
    set_font Default_font Normal_font Size4_font;
    let width=(fst size)
    and height=(snd size)
    and left= gr_to_real_coord exPrompt.expt_left
    and top = gr_to_real_coord exPrompt.expt_top in
      inside_rect left top width height Coord
;;




let inside_toolbar Toolb Coord =
  let height=gr_text_height + 2*gr_long_space
  and top   =gr_to_real_coord Toolb.tb_window.win_height
  and width =gr_to_real_coord Toolb.tb_window.win_width in
    inside_rect 0 top width height Coord
;;




let inside_radio Radio Coord =
  let size=text_size Radio.ra_name in
    let width =(fst size)
    and height=((snd size)+2*gr_short_space)
    and left  = gr_to_real_coord Radio.ra_left
    and top   = gr_to_real_coord Radio.ra_top in
      inside_rect left top (width+height+gr_short_space) height Coord
;;



let inside_bitmap Bitmap Coord =
  let width  =fst (image_size Bitmap.bm_bitmap)
  and height =snd (image_size Bitmap.bm_bitmap)
  and left   =gr_to_real_coord Bitmap.bm_left
  and top    =gr_to_real_coord Bitmap.bm_top in
    inside_rect left top width height Coord
;;



let sqr x = x*x;;

let inside_line Line Coord =
  let d1=(sqr ((gr_to_real_coord (fst Line.ln_point1))-Coord.x))+
         (sqr ((gr_to_real_coord (snd Line.ln_point1))-Coord.y))
  and d2=(sqr ((gr_to_real_coord (fst Line.ln_point2))-Coord.x))+
         (sqr ((gr_to_real_coord (snd Line.ln_point2))-Coord.y)) in
    if d1<=4
    then Place
    else if d2<=4
         then Resize
         else Out;;


let inside_rectangle Rect Coord =
  let left  = gr_to_real_coord (fst Rect.re_point)
  and bottom= gr_to_real_coord (snd Rect.re_point)
  and width = gr_to_real_coord Rect.re_width
  and height= gr_to_real_coord Rect.re_height in
    InsideArea left (bottom+height) width height Coord
;;



let inside_ellipse Ellipse Coord =
  let left  = gr_to_real_coord (fst Ellipse.el_center)
  and top   = gr_to_real_coord (snd Ellipse.el_center)
  and width = gr_to_real_coord (Ellipse.el_xray)
  and height= gr_to_real_coord (Ellipse.el_yray) in
    InsideArea (left-width) (top+height)
                (2*width) (2*height) Coord
;;



let inside_grprad Grprad Coord =
  let left  = gr_to_real_coord Grprad.ga_left
  and top   = gr_to_real_coord Grprad.ga_top
  and width = gr_to_real_coord Grprad.ga_width
  and height= gr_to_real_coord Grprad.ga_height in
    InsideArea left top width height Coord
;;


let inside_grpbut Grpbut Coord =
  let left  = gr_to_real_coord Grpbut.gb_left
  and top   = gr_to_real_coord Grpbut.gb_top
  and width = gr_to_real_coord Grpbut.gb_width
  and height= gr_to_real_coord Grpbut.gb_height in
    InsideArea left top width height Coord
;;


let inside_area Area Coord =
  let left  = gr_to_real_coord Area.ar_left
  and top   = gr_to_real_coord Area.ar_top
  and width = gr_to_real_coord Area.ar_width
  and height= gr_to_real_coord Area.ar_height in
    InsideArea left top width height Coord
;;


let inside_extext exText Coord =
  let left  = gr_to_real_coord exText.extx_left
  and top   = gr_to_real_coord exText.extx_top
  and width = gr_to_real_coord exText.extx_width
  and height= gr_to_real_coord exText.extx_height in
    InsideArea left top width height Coord
;;


let inside_scrollbar Scroll Coord =
  match Scroll.sb_dir with
    Horizontal ->
      let left  = gr_to_real_coord Scroll.sb_left
      and top   = gr_to_real_coord Scroll.sb_top
      and width = gr_to_real_coord Scroll.sb_length
      and height= gr_scroll_width in
        InsideArea left top width height Coord
  | Vertical   ->
      let left  = gr_to_real_coord Scroll.sb_left
      and top   = gr_to_real_coord Scroll.sb_top
      and width = gr_scroll_width
      and height= gr_to_real_coord Scroll.sb_length in
        InsideArea left top width height Coord
;;


