#open "windows";;
#open "camlwin";;

#open "camlicon";;
#open "saveicon";;





let SaveIconThenClose Obj Event =
  gr_close_warning Obj Event;
  SaveIcon Obj Event;
  gr_erase_window CamliconWin.win_def;;


let CloseIconWithoutSaving Obj Event =
  gr_close_warning Obj Event;
  gr_erase_window CamliconWin.win_def;;


let CloseIcon Obj Event =
  if !icon_file=""
  then
  (
    icon_file := gr_input_string "Icon Name:" "icon";
    SaveIcon Obj Event;
    ()
  );
  if !icon_modified
  then
  (
    gr_warning ("The modifications aren't saved. Save them ?")
               [| {warn_name="Yes"; warn_callback=SaveIconThenClose};
                  {warn_name="No"; warn_callback=CloseIconWithoutSaving};
                  {warn_name="Cancel"; warn_callback=gr_close_warning}
               |];
    true
  )
  else gr_erase_window CamliconWin.win_def;;


iconexit_file.it_callback <- CloseIcon;;


