#open "windows";;
#open "camlwin";;
#open "sys";;
#open "printexc";;


#open "camlhelp";;
#open "helpsave";; 
#open "comphelp";;
#open "listhelp";;
#open "titlhelp";;


let file_name = ref "";;
let html_struct = ref [HtmlText ""];;

let HtmlLoad Obj Event =
  let name = gr_select_file "*.*" in
    if not name = ""
    then
    (
      html_help.hl_help <- "Loading file: " ^ name;
      gr_draw_helpbar html_help;
      html_struct := gr_extext_load html_draw name;
      gr_draw_extext html_draw;
      html_help.hl_help <- "File: " ^ name;
      file_name := name;
      gr_draw_helpbar html_help;
      true
    )
    else false
;;




let do_save = ref false;;

let SaveOkCallback Obj Event =
  do_save := true;
  gr_erase_window HtmlSaveWin.win_def
;;

let SaveCancelCallback Obj Event =
  do_save := false;
  gr_erase_window HtmlSaveWin.win_def
;;

htsave_ok.bt_callback <- SaveOkCallback;;
htsave_cancel.bt_callback <- SaveCancelCallback;;

 

let HtmlSave Obj Event =
  let pos = window_pos HtmlWin_def.win_id in
    HtmlSaveWin_def.win_top = (snd pos) + 100;
    HtmlSaveWin_def.win_left = (fst pos) + 100;
  htsave_name.st_name <- gr_without_suffix !file_name;
  gr_block_loop HtmlSaveWin;
  if !do_save
  then
  (
    if htsave_html.ra_state
    then 
    (
      html_help.hl_help <- "File: " ^ htsave_name.st_name ^ ".html";
      file_name := htsave_name.st_name;
      gr_draw_helpbar html_help;
      let file = open_out (htsave_name.st_name ^ ".html") in
        gr_html_save !html_struct file;
        close_out file
    );

    if htsave_ml.ra_state
    then 
    (
      html_help.hl_help <- "File: " ^ htsave_name.st_name ^ ".ml";
      file_name := htsave_name.st_name;
      gr_draw_helpbar html_help;
      let file = open_out (htsave_name.st_name ^ ".ml") in
        gr_save_HTML_type htsave_name.st_name !html_struct file;
        close_out file
    );

    if htsave_hlp.ra_state
    then 
    (
      html_help.hl_help <- "File: " ^ htsave_name.st_name ^ ".hlp";
      file_name := htsave_name.st_name;
      gr_draw_helpbar html_help;
      gr_extext_save html_draw htsave_name.st_name
    );

    true
  ) 
  else false
;; 






let Anchor_to_name Anchor =
  (fst Anchor).AnchorName 
;;


let rec ExtractAnchor List =
  match List with
   []    -> []
  | x::y -> if (fst x).AnchorType = NAME
            then x::(ExtractAnchor y)
            else ExtractAnchor y
;;

let HtmlAnchorList Obj Event =
    let AList = ExtractAnchor html_draw.extx_anchors in
    if not AList = []
    then
    (
      let strList = map Anchor_to_name AList in
        let sel = gr_select "Anchor" (vect_of_list strList) in
          gr_extext_goto_anchor html_draw (snd sel);
(*          html_draw.extx_scroll <- (snd (nth_elem AList (fst sel)))-1; *)
        gr_draw_extext html_draw
    );

  false
;;
      

html_load.bt_callback <- HtmlLoad;;
html_save.bt_callback <- HtmlSave;;
html_anchor.bt_callback <- HtmlAnchorList;;
html_quit.bt_callback <- gr_quit_callback;;




let parse_cmdline () =
  let len = vect_length command_line 
  and result = ref [""] in 
    result := [];
    for i = 0 to len - 1 do
      if gr_suffix_only command_line.(i) = "prj"
      then
      (
        let file = open_in command_line.(i) in
          try
            while true do
              let line = input_line file in
                if gr_suffix_only line = "html" or 
                   gr_suffix_only line = "htm"
                then 
                (
                  result  := !result @ [ line ]
                )
            done
         with End_of_file -> ()
      )
      else result := !result @ [ command_line.(i) ]
    done;
   vect_of_list !result
;;





 

if vect_length command_line > 1
then
(
  print_string "Camlwin help Compiler:";
  print_newline ();
  try
  (
    match command_line.(1) with
      "-c" -> CompileHelp (parse_cmdline ())
    | "-l" -> CompileListAnchor (parse_cmdline ())
    | "-t" -> CompileListTitle (parse_cmdline ())
    | _    -> print_string ("I dont know what to do with:" ^ 
                             command_line.(1));
              print_newline();
              raise (Failure "bad argument")

  )
  with Invalid_argument str -> print_string ("Invalid argument: " ^ str ^ 
           "\nUsage: camlhelp [-c size] | [-l outfile] | [-t outfile] [-files infile] | [file...]");
            print_newline ()
)
else (f gr_main_loop [HtmlWin]; ());;

