#open "windows";;
#open "camlwin";;



let cfg_graph_def =
{
  win_left     = 20;
  win_top      = 300;
  win_width    = 125;
  win_height   = 80;
  win_id       = gr_undef_window;
  win_name     = "Graphical Object";
  win_state    = Destroyed
};;

let graph_ok =
{
  bt_window   = cfg_graph_def;
  bt_left     = 25;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let graph_cancel =
{
  bt_window   = cfg_graph_def;
  bt_left     = 72;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let graph_help =
{
  hl_window   = cfg_graph_def;
  hl_help     = "Press Ok when finished"
};;

let graph_title =
{
  pt_window   = cfg_graph_def;
  pt_left     = 15;
  pt_top      = 77;
  pt_name     = "Choose graphical object"
};;

let graph_type =
{
  ga_window   = cfg_graph_def;
  ga_top      = 70;
  ga_left     = 12;
  ga_width    = 100;
  ga_height   = 35;
  ga_delta    = 5;
  ga_radio    = 0;
  ga_name     = [| "Line"; "Rectangle"; "Circle" |];
  ga_callback = gr_do_nothing
};;


let cfg_graph =
{
  win_def      = cfg_graph_def;
  win_objects  = [
                  g_button    graph_ok;
                  g_button    graph_cancel;
                  g_helpbar   graph_help;
                  g_grprad    graph_type;
                  g_prompt    graph_title
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;



let graph_end = ref false;;

let CloseGraphCfg Obj  Event =
  graph_end := true;
  gr_erase_window cfg_graph.win_def
;;

let CancelGraphCfg Obj Event =
  graph_end := false;
  gr_erase_window cfg_graph.win_def
;;

graph_ok.bt_callback <- CloseGraphCfg;;
graph_cancel.bt_callback <- CancelGraphCfg;;

