#open "windows";;
#open "camlwin";;

#open "funcdraw";;


let cfg_grprad_def =
{
  win_left     = 41;
  win_top      = 367;
  win_width    = 150;
  win_height   = 150;
  win_id       = gr_undef_window;
  win_name     = "Group of Radio-button";
  win_state    = Destroyed
};;

let grprad_add =
{
  bt_window   = cfg_grprad_def;
  bt_left     = 10;
  bt_top      = 96;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Add";
  bt_callback = gr_do_nothing
};;

let grprad_ins =
{
  bt_window   = cfg_grprad_def;
  bt_left     = 10;
  bt_top      = 78;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ins";
  bt_callback = gr_do_nothing
};;

let grprad_del =
{
  bt_window   = cfg_grprad_def;
  bt_left     = 10;
  bt_top      = 61;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Del";
  bt_callback = gr_do_nothing
};;

let grprad_prompt3 =
{
  pt_window   = cfg_grprad_def;
  pt_left     = 2;
  pt_top      = 103;
  pt_name     = "Names:"
};;

let grprad_names =
{
  li_window   = cfg_grprad_def;
  li_left     = 42;
  li_top      = 98;
  li_width    = 100;
  li_height   = 50;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [| |];
  li_callback = gr_do_nothing
};;

let grprad_delta =
{
  st_window   = cfg_grprad_def;
  st_left     = 40;
  st_top      = 42;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 1;
  st_name     = "0";
  st_state    = Editable;
  st_type     = Gr_natural;
  st_callback = gr_do_nothing
};;

let grrad_prompt4 =
{
  pt_window   = cfg_grprad_def;
  pt_left     = 2;
  pt_top      = 40;
  pt_name     = "Delta:"
};;

let grprad_edit =
{
  bt_window   = cfg_grprad_def;
  bt_left     = 120;
  bt_top      = 117;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let grprad_callback =
{
  st_window   = cfg_grprad_def;
  st_left     = 40;
  st_top      = 117;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let grprad_prompt2 =
{
  pt_window   = cfg_grprad_def;
  pt_left     = 2;
  pt_top      = 115;
  pt_name     = "Callback:"
};;

let grprad_idname =
{
  st_window   = cfg_grprad_def;
  st_left     = 40;
  st_top      = 132;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let grprad_prompt1 =
{
  pt_window   = cfg_grprad_def;
  pt_left     = 2;
  pt_top      = 130;
  pt_name     = "Id name:"
};;

let grprad_ok =
{
  bt_window   = cfg_grprad_def;
  bt_left     = 35;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let grprad_cancel =
{
  bt_window   = cfg_grprad_def;
  bt_left     = 85;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let grprad_help =
{
  hl_window   = cfg_grprad_def;
  hl_help     = "Press Ok when finished"
};;

let grprad_title =
{
  pt_window   = cfg_grprad_def;
  pt_left     = 5;
  pt_top      = 147;
  pt_name     = "Group of radio-button Configuration"
};;

let cfg_grprad =
{
  win_def      = cfg_grprad_def;
  win_objects  = [
                  g_button    grprad_add;
                  g_button    grprad_ins;
                  g_button    grprad_del;
                  g_prompt    grprad_prompt3;
                  g_list      grprad_names;
                  g_string    grprad_delta;
                  g_prompt    grrad_prompt4;
                  g_button    grprad_edit;
                  g_string    grprad_callback;
                  g_prompt    grprad_prompt2;
                  g_string    grprad_idname;
                  g_prompt    grprad_prompt1;
                  g_button    grprad_ok;
                  g_button    grprad_cancel;
                  g_helpbar   grprad_help;
                  g_prompt    grprad_title
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;


let grprad_id = ref "";;
let grprad_call = ref "";;
let grprad_saves = ref [| "" |];;
let grprad_d = ref 0;;



let grprad_init IdName CallName Grprad =
  grprad_id := IdName;
  grprad_call := CallName;
  grprad_saves := Grprad.ga_name;
  grprad_d := Grprad.ga_delta;
  grprad_idname.st_name <- IdName;
  grprad_callback.st_name <- CallName;
  grprad_delta.st_name <- string_of_int Grprad.ga_delta;
  grprad_names.li_items <- Grprad.ga_name
;;

let grprad_restore ()=
  grprad_idname.st_name   <- !grprad_id;
  grprad_callback.st_name <- !grprad_call;
  grprad_delta.st_name    <- string_of_int !grprad_d;
  grprad_names.li_items   <- !grprad_saves
;;



let CloseGrpradCfg Obj Event =
  gr_erase_window cfg_grprad.win_def
;;

let CancelGrpradCfg Obj Event =
  grprad_restore ();
  gr_erase_window cfg_grprad.win_def
;;

let EditGrpradCfg Obj Event =
  EditCallback grprad_callback.st_name;
  true
;;

let AddGrpradCfg Button Event =
  gr_list_add_item grprad_names
                   (gr_input_string "Value:" "")
                   (vect_length grprad_names.li_items);
  gr_draw_list grprad_names;
  true
;;

let InsGrpradCfg Button Event =
  gr_list_add_item grprad_names
                   (gr_input_string "Value:" "")
                   grprad_names.li_nu_item;
  gr_draw_list grprad_names;
  true
;;

let DelGrpradCfg Button Event =
  gr_list_del_item grprad_names grprad_names.li_nu_item;
  gr_draw_list grprad_names;
  true
;;



grprad_ok.bt_callback     <- CloseGrpradCfg;;
grprad_cancel.bt_callback <- CancelGrpradCfg;;
grprad_edit.bt_callback   <- EditGrpradCfg;;
grprad_add.bt_callback    <- AddGrpradCfg;;
grprad_add.bt_callback    <- AddGrpradCfg;;
grprad_del.bt_callback    <- DelGrpradCfg;;
grprad_ins.bt_callback    <- InsGrpradCfg;;

