#open "windows";;
#open "camlwin";;
#open "confdraw";;
#open "saveicon";;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let callbacks_def = ref [" "];;
  callbacks_def := [];;

let window_name = ref "win";;
let window_saved=ref true;;
let window_file_name=ref "";;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let add_callback String =
  callbacks_def := !callbacks_def @ [ String ]
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let list_length List =
  let rec list_len_loop List i =
    match List with
      []   -> i
    | x::y -> list_len_loop y (i+1)
  in
    list_len_loop List 0
;;





(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let without_end l =
  let l1=rev l in
    match l1 with
      []-> []
    | x::y -> rev y
;;

let without_first l=
  match l with
    [] -> []
  | x::y -> y
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let spaces c = (c=` ` or c=`\t` or c=`\n`);;



let nth_word String Word =
  let rec nth_word_loop1 String Word n Pos Len =
    if Pos=(Len - 1)
    then Pos
    else if (spaces (nth_char String Pos)) &
            not (spaces (nth_char String (Pos+1)))
         then if n=Word
              then (Pos+1)
              else nth_word_loop1 String Word (n+1) (Pos+1) Len
         else nth_word_loop1 String Word n (Pos+1) Len
  in
  let rec nth_word_loop2 String Pos Len =
    if Pos=(Len - 1)
    then Pos
    else if not (spaces (nth_char String Pos)) &
            (spaces (nth_char String (Pos+1)))
         then (Pos+1)
         else nth_word_loop2 String (Pos+1) Len
  in
    let Text=(" " ^ String ^ " ") in
      let n=(string_length Text) in
        let b=(nth_word_loop1 Text Word 0 0 n) in
          let e=(nth_word_loop2 Text b n) in
            sub_string Text b (e-b)
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let get_function_name String =
  let name1=(nth_word String 1) in
    if name1="rec"
    then (nth_word String 2)
    else name1
;;


let get_functions_names List =
  let rec get_functions_loop List Result=
    match List with
      [] -> Result
    | x::y ->
        get_functions_loop y (Result @ [ (get_function_name x) ] )
  in
    get_functions_loop List [ ]
;;


let FunctionsNames ()=
  vect_of_list (get_functions_names !callbacks_def)
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let in_vect Vect Elem =
  let rec in_vect_loop Vect Elem Pos Length =
    if Pos=Length
    then (false,Length)
    else if Vect.(Pos)=Elem
         then (true,Pos)
         else in_vect_loop Vect Elem (Pos+1) Length
  in
    let n=vect_length Vect in
      in_vect_loop Vect Elem 0 n
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let which_object Obj List =
  let rec which_object_loop Obj List Pos =
    match List with
      [] -> raise (Failure "which_object: bad object")
    | x::y -> if x=Obj
              then Pos
              else which_object_loop Obj y (Pos+1)
  in
    which_object_loop Obj List 0
;;





(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let string_of_melted Melted ImageName=
  match Melted with
    string_type str -> "s " ^ str
  | bitmap_type img -> "b " ^ ImageName
  | float_type  x   -> "f " ^ (string_of_float x)
  | int_type    n   -> "i " ^ (string_of_int n)
  | bool_type   b   -> match b with
                         true  -> "o true"
                       | false -> "o false"
;;


let melted_of_string String =
  let len=string_length String in
    let str= sub_string String 2 (len-2) in
      match (nth_char String 0) with
        `s` -> string_type str
      | `b` -> bitmap_type (load_bitmap str
                                        (make_image (make_matrix 2 2 black)))
      | `i` -> int_type (int_of_string str)
      | `f` -> float_type (float_of_string str)
      | _   -> bool_type true
;;


let image_name_of_string String =
  let len=string_length String in
    let str= sub_string String 2 (len-2) in
      match (nth_char String 0) with
        `b` -> str
      | _   -> ""
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let rec get_toolbar ObjList =
  match ObjList with
    [] -> raise (Failure "Didn't have an toolbar!")
  | x::y -> match x with
              g_toolbar Toolb -> Toolb
            | _ -> get_toolbar y
;;

let rec had_toolbar ObjList =
  match ObjList with
    [] -> false
  | x::y -> match x with
              g_toolbar Toolb -> true
            | _ -> had_toolbar y
;;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let rec had_helpbar ObjList =
  match ObjList with
    [] -> false
  | x::y -> match x with
              g_helpbar Helpb -> true
            | _ -> had_helpbar y
;;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let MenuPos Menu toolb =
  let len = vect_length toolb.tb_items in
    let rec menu_pos_loop i =
      if i=len
      then raise (Failure "confdraw: MenuPos didn't find Menu\n")
      else if Menu = toolb.tb_items.(i)
           then i
           else menu_pos_loop (i+1)
    in
      menu_pos_loop 0
;;


let ItemPos Item toolb =
    let rec item_loop NuMenu i len =
      if i=len
      then (-1)
      else if Item = toolb.tb_items.(NuMenu).mn_items.(i)
           then i
           else item_loop NuMenu (i+1) len
    in
    let rec menu_loop i len =
      if i=len
      then raise (Failure "confdraw: ItemPos didn't find Item\n")
      else
      (
        let nb_items = vect_length toolb.tb_items.(i).mn_items in
          let found = item_loop i 0 nb_items in
            if found < 0
            then menu_loop (i+1) len
            else (i,found)
      )
    in
      menu_loop 0 (vect_length !toolb_def)
;;