#open "windows";;
#open "camlwin";;

#open "confdraw";;
#open "funcdraw";;
#open "globdraw";;
#open "camlicon";;
#open "saveicon";;
#open "typedraw";;


let cfg_grpbut_def =
{
  win_left     = 32;
  win_top      = 380;
  win_width    = 150;
  win_height   = 185;
  win_id       = gr_undef_window;
  win_name     = "Group of Buttons";
  win_state    = Destroyed
};;

let grpbut_pr_title =
{
  pt_window   = cfg_grpbut_def;
  pt_left     = 18;
  pt_top      = 182;
  pt_name     = "Group of Buttons Configuration"
};;

let grpbut_pr_idname =
{
  pt_window   = cfg_grpbut_def;
  pt_left     = 5;
  pt_top      = 167;
  pt_name     = "Id name:"
};;

let grpbut_pr_callback =
{
  pt_window   = cfg_grpbut_def;
  pt_left     = 5;
  pt_top      = 155;
  pt_name     = "Callback:"
};;

let grpbut_idname =
{
  st_window   = cfg_grpbut_def;
  st_left     = 40;
  st_top      = 170;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let grpbut_callback =
{
  st_window   = cfg_grpbut_def;
  st_left     = 40;
  st_top      = 157;
  st_width    = 75;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let grpbut_edit =
{
  bt_window   = cfg_grpbut_def;
  bt_left     = 120;
  bt_top      = 159;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let grpbut_pr_coord =
{
  pt_window   = cfg_grpbut_def;
  pt_left     = 5;
  pt_top      = 135;
  pt_name     = "Buttons' size:"
};;

let grpbut_pr_width =
{
  pt_window   = cfg_grpbut_def;
  pt_left     = 60;
  pt_top      = 140;
  pt_name     = "Width:"
};;

let grpbut_pr_height =
{
  pt_window   = cfg_grpbut_def;
  pt_left     = 60;
  pt_top      = 130;
  pt_name     = "Height:"
};;

let grpbut_width =
{
  st_window   = cfg_grpbut_def;
  st_left     = 87;
  st_top      = 142;
  st_width    = 45;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_natural;
  st_callback = gr_do_nothing
};;

let grpbut_height =
{
  st_window   = cfg_grpbut_def;
  st_left     = 87;
  st_top      = 132;
  st_width    = 45;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_natural;
  st_callback = gr_do_nothing
};;

let grpbut_pr_delta =
{
  pt_window   = cfg_grpbut_def;
  pt_left     = 5;
  pt_top      = 115;
  pt_name     = "Delta:"
};;

let grpbut_delta =
{
  st_window   = cfg_grpbut_def;
  st_left     = 40;
  st_top      = 117;
  st_width    = 60;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_natural;
  st_callback = gr_do_nothing
};;

let grpbut_help =
{
  hl_window   = cfg_grpbut_def;
  hl_help     = "Press Ok when finished"
};;

let grpbut_names =
{
  li_window   = cfg_grpbut_def;
  li_left     = 35;
  li_top      = 105;
  li_width    = 85;
  li_height   = 40;
  li_nu_item  = 0;
  li_1st_item = 0;
  li_scroll   = 0;
  li_items    = [| |];
  li_callback = gr_do_nothing
};;

let grpbut_add =
{
  bt_window   = cfg_grpbut_def;
  bt_left     = 5;
  bt_top      = 105;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Add";
  bt_callback = gr_do_nothing
};;

let grpbut_ins =
{
  bt_window   = cfg_grpbut_def;
  bt_left     = 5;
  bt_top      = 90;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ins";
  bt_callback = gr_do_nothing
};;

let grpbut_del =
{
  bt_window   = cfg_grpbut_def;
  bt_left     = 5;
  bt_top      = 75;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Del";
  bt_callback = gr_do_nothing
};;

let grpbut_change =
{
  bt_window   = cfg_grpbut_def;
  bt_left     = 122;
  bt_top      = 90;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Edit";
  bt_callback = gr_do_nothing
};;

let grpbut_pr_dir =
{
  pt_window   = cfg_grpbut_def;
  pt_left     = 50;
  pt_top      = 57;
  pt_name     = "Direction:"
};;

let grpbut_dir =
{
  ga_window=cfg_grpbut_def;
  ga_top=50;
  ga_left=5;
  ga_width=140;
  ga_height=15;
  ga_delta=5;
  ga_radio=0;
  ga_name=[|
            "Vertical";
            "Horizontal"
          |];
  ga_callback=gr_do_nothing
};;

let grpbut_ok =
{
  bt_window   = cfg_grpbut_def;
  bt_left     = 42;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Ok";
  bt_callback = gr_do_nothing
};;

let grpbut_cancel =
{
  bt_window   = cfg_grpbut_def;
  bt_left     = 87;
  bt_top      = 25;
  bt_width    = 25;
  bt_height   = 10;
  bt_state    = Up;
  bt_name     = string_type "Cancel";
  bt_callback = gr_do_nothing
};;

let cfg_grpbut =
{
  win_def      = cfg_grpbut_def;
  win_objects  = [
                  g_prompt    grpbut_pr_title;
                  g_prompt    grpbut_pr_idname;
                  g_prompt    grpbut_pr_callback;
                  g_string    grpbut_idname;
                  g_string    grpbut_callback;
                  g_button    grpbut_edit;
                  g_prompt    grpbut_pr_coord;
                  g_prompt    grpbut_pr_width;
                  g_prompt    grpbut_pr_height;
                  g_string    grpbut_width;
                  g_string    grpbut_height;
                  g_prompt    grpbut_pr_delta;
                  g_string    grpbut_delta;
                  g_helpbar   grpbut_help;
                  g_list      grpbut_names;
                  g_button    grpbut_add;
                  g_button    grpbut_ins;
                  g_button    grpbut_del;
                  g_button    grpbut_change;
                  g_prompt    grpbut_pr_dir;
                  g_grprad    grpbut_dir;
                  g_button    grpbut_ok;
                  g_button    grpbut_cancel
                 ];
  time_callback = gr_do_nothing;
  resize_callback = gr_do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;


let GrpbutDir () =
  if grpbut_dir.ga_radio=0
  then Vertical
  else Horizontal
;;


let GrpbutName_to_lines Vect ImageNames =
  let n=vect_length Vect in
    if n=0
    then [| |]
    else
    (
      let Result=make_vect n "" in
        for i=0 to (n-1) do
          Result.(i) <- string_of_melted Vect.(i) ImageNames.(i)
        done;
        Result
    )
;;

let lines_to_GrpbutName Lines =
  let n=vect_length Lines in
    let Result=make_vect n (string_type "") in
    if n>0
    then
    (
      for i=0 to (n-1) do
        Result.(i) <- melted_of_string Lines.(i)
      done
    );
    Result
;;

let grpbut_id=ref "";;
let grpbut_call=ref "";;
let grpbut_saves=ref [| "" |];;
let grpbut_d=ref 0;;
let grpbut_size=ref (0,0);;
let grpbut_direction=ref Horizontal;;



let grpbut_init Def Grpbut =
  grpbut_id := Def.id_name;
  grpbut_call := Def.callback;
  grpbut_saves := GrpbutName_to_lines Grpbut.gb_name Def.images_names;
  grpbut_d := Grpbut.gb_delta;
  grpbut_size := (Grpbut.gb_btwidth,Grpbut.gb_btheight);
  grpbut_direction := Grpbut.gb_dir;

  grpbut_idname.st_name <- Def.id_name;
  grpbut_callback.st_name <- Def.callback;
  grpbut_delta.st_name <- string_of_int Grpbut.gb_delta;
  grpbut_width.st_name <- string_of_int Grpbut.gb_btwidth;
  grpbut_height.st_name <- string_of_int Grpbut.gb_btheight;
  grpbut_names.li_items <- !grpbut_saves
;;


let grpbut_restore ()=
  grpbut_idname.st_name   <- !grpbut_id;
  grpbut_callback.st_name <- !grpbut_call;
  grpbut_delta.st_name    <- string_of_int !grpbut_d;
  grpbut_width.st_name    <- string_of_int (fst !grpbut_size);
  grpbut_height.st_name   <- string_of_int (snd !grpbut_size);
  grpbut_names.li_items   <- !grpbut_saves;
  grpbut_dir.ga_radio     <- if !grpbut_direction=Vertical
                             then 0
                             else 1
;;



let CloseGrpbutCfg Obj Event =
  gr_erase_window cfg_grpbut.win_def
;;

let CancelGrpbutCfg Obj Event =
  grpbut_restore ();
  gr_erase_window cfg_grpbut.win_def
;;

let EditGrpbutCfg Obj Event =
  EditCallback grpbut_callback.st_name;
  true
;;





let AddGrpbutCfg Button Event =
  gr_block_loop ChooseTypeWin;
  let name = match choosen_type.gb_button with
               1 -> (* button with bitmap label *)
                   gr_block_loop CamliconWin;
                   string_of_melted (bitmap_type icon.bm_bitmap) !icon_file
             | 2 -> (* button with int label *)
                   string_of_melted (int_type (gr_input_int "Label:" 0)) ""
             | _ -> (* button with text label *)
                   string_of_melted (string_type (gr_input_string "Label:" "")) ""
             in
  gr_list_add_item grpbut_names name (vect_length grpbut_names.li_items);
  true
;;

let InsGrpbutCfg Button Event =
  gr_block_loop ChooseTypeWin;
  let name = match choosen_type.gb_button with
               1 -> (* button with bitmap label *)
                   gr_block_loop CamliconWin;
                   string_of_melted (bitmap_type icon.bm_bitmap) !icon_file
             | 2 -> (* button with int label *)
                   string_of_melted (int_type (gr_input_int "Label:" 0)) ""
             | _ -> (* button with text label *)
                   string_of_melted (string_type (gr_input_string "Label:" "")) ""
             in
  gr_list_add_item grpbut_names name grpbut_names.li_nu_item;
  true
;;


let DelGrpbutCfg Button Event =
  gr_list_del_item grpbut_names grpbut_names.li_nu_item;
  gr_draw_list grpbut_names;
  true
;;


let ChangeGrpbutCfg Obj Event =
  let len=string_length grpbut_names.li_items.(grpbut_names.li_nu_item)
  and str=grpbut_names.li_items.(grpbut_names.li_nu_item) in
    let name=sub_string str 2 (len-2) in
  (
  match nth_char str 0 with
    `b` -> (* button with bitmap label *)
          load_icon name;
          icon_name.st_name <- name;
          gr_block_loop CamliconWin;
          grpbut_names.li_items.(grpbut_names.li_nu_item) <-
                string_of_melted (bitmap_type icon.bm_bitmap) !icon_file
  | `i` -> (* button with int label *)
          let label_init=int_of_string name in
            grpbut_names.li_items.(grpbut_names.li_nu_item) <-
                string_of_melted (int_type (gr_input_int "Label:" label_init)) ""
  | _   -> (* button with text label *)
          grpbut_names.li_items.(grpbut_names.li_nu_item) <-
              string_of_melted (string_type (gr_input_string "Label:" name)) ""
  );
  true
;;




grpbut_ok.bt_callback     <- CloseGrpbutCfg;;
grpbut_cancel.bt_callback <- CancelGrpbutCfg;;
grpbut_edit.bt_callback   <- EditGrpbutCfg;;
grpbut_add.bt_callback    <- AddGrpbutCfg;;
grpbut_del.bt_callback    <- DelGrpbutCfg;;
grpbut_ins.bt_callback    <- InsGrpbutCfg;;
grpbut_change.bt_callback <- ChangeGrpbutCfg;;

