#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_text";;
#open "g_shell";;
#open "g_prompt";;
#open "g_mloop";;





let gr_shell_height = 75;;
let gr_shell_width = 200;;


let gr_shell_window_def = 
{
  win_id = undef_window;
  win_top = (screen_height() + to_real_coord (gr_shell_height))/2;
  win_left = (screen_width() - to_real_coord (gr_shell_width))/2;
  win_width = gr_shell_width;
  win_height = gr_shell_height;
  win_name = "Shell";
  win_state = Destroyed
};;

let gr_shell_OK =
{
  bt_window=gr_shell_window_def;
  bt_left=((gr_shell_width-25)/2);
  bt_top=15;
  bt_width=25;
  bt_height=12;
  bt_name=string_type "Ok";
  bt_state=Up;
  bt_callback= do_nothing
};;


let gr_shell_text = make_shell
{
  s_window=gr_shell_window_def;
  s_left= 5;
  s_top=gr_shell_height - 10;
  s_width=gr_shell_width - 10;
  s_height=gr_shell_height - 27;
  s_state=Edited
};;


let gr_shell_prompt=
{
  pt_window=gr_shell_window_def;
  pt_left=5;
  pt_top=gr_shell_height - 2;
  pt_name="Shell:"
};;



let gr_shell_window = 
{
  win_def=gr_shell_window_def;
  win_objects=[g_button gr_shell_OK;
               g_shell  gr_shell_text;
               g_prompt gr_shell_prompt
              ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;




let rec gr_close_shell Obj_graph Event =
  erase_window gr_shell_window.win_def;;
gr_shell_OK.bt_callback <- gr_close_shell;;



