#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_prompt";;
#open "g_bitmap";;
#open "g_mloop";;





let gr_warning_width = 120;;
let gr_warning_height = 40;;
let gr_warning_delta n = ((gr_warning_width-n*25)/(n+1));;





let rec begin_of_word String Pos =
  if Pos=0
  then 0
  else if (nth_char String Pos)=` `
       then Pos
       else begin_of_word String (Pos-1)
;;

let rec cut_line_loop String Pos Vect =
  let len=string_length String in
  if Pos=len
  then concat_vect Vect [|String|]
  else
  (
    let str=sub_string String 0 Pos in
      if to_win_coord (fst (text_size str)) > gr_warning_width-20
      then
      (
        let end_pos=begin_of_word String Pos in
          let end_str=sub_string String end_pos (len-end_pos)
          and begin_str=sub_string String 0 end_pos in
            cut_line_loop end_str 0 (concat_vect Vect [|begin_str|])
      )
      else cut_line_loop String (Pos+1) Vect
  )
;;

let cut_line String =
  cut_line_loop String 0 [| |]
;;

let draw_multiple_line User =
  let left= (match User.us_param.(0) with
               int_type Int -> to_real_coord Int
             | _            -> 0
            )
  and top= (match User.us_param.(1) with
               int_type Int -> to_real_coord Int
             | _            -> 0
            )
  and Text= (match User.us_param.(2) with
               string_type Text ->Text
             | _                -> ""
            ) in
    let lines=cut_line Text in
      let nb_lines=vect_length lines
      and dy=line_height+short_space in
        set_color black;
        for i=0 to (nb_lines-1) do
        (
          moveto left
                 (top-dy*(i+1));
          draw_string lines.(i)
        )
        done
;;




let gr_warning_window_def =
{
  win_id = undef_window;
  win_top = (screen_height() + (to_real_coord gr_warning_height))/2;
  win_left = (screen_width() - (to_real_coord gr_warning_width))/2;
  win_width = gr_warning_width;
  win_height = gr_warning_height;
  win_name = "Warning";
  win_state = Destroyed
};;

let gr_warning_but1 =
{
  bt_window=gr_warning_window_def;
  bt_left=0;
  bt_top=25;
  bt_width=25;
  bt_height=10;
  bt_name=string_type "Ok";
  bt_state=Up;
  bt_callback= do_nothing
};;

let gr_warning_but2 =
{
  bt_window=gr_warning_window_def;
  bt_left=0;
  bt_top=25;
  bt_width=25;
  bt_height=10;
  bt_name=string_type "Cancel";
  bt_state=Up;
  bt_callback= do_nothing
};;

let gr_warning_but3 =
{
  bt_window=gr_warning_window_def;
  bt_left=0;
  bt_top=25;
  bt_width=25;
  bt_height=10;
  bt_name=string_type "Help";
  bt_state=Up;
  bt_callback= do_nothing
};;

let gr_warning_text=
{
  us_window=gr_warning_window_def;
  us_param=[|int_type 10; int_type 35; string_type "Warning!"|];
  us_draw=draw_multiple_line;
  us_callback=do_nothing
};;

let gr_warning_window =
{
  win_def = gr_warning_window_def;
  win_objects = [ ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;





let create_warning Name List =
  let n=(min 3 (vect_length List)) in
    let delta=gr_warning_delta n in
      (
        match n with
          0 -> ()
        | 1 -> gr_warning_but1.bt_left <- delta;
               gr_warning_but1.bt_callback <- List.(0).warn_callback;
               gr_warning_but1.bt_name <- string_type List.(0).warn_name;
               gr_warning_window.win_objects <-
                   [ g_user   gr_warning_text;
                     g_button gr_warning_but1
                   ]
        | 2 -> gr_warning_but1.bt_left <- delta;
               gr_warning_but1.bt_callback <- List.(0).warn_callback;
               gr_warning_but1.bt_name <- string_type List.(0).warn_name;
               gr_warning_but2.bt_left <- 2*delta+25;
               gr_warning_but2.bt_callback <- List.(1).warn_callback;
               gr_warning_but2.bt_name <- string_type List.(1).warn_name;
               gr_warning_window.win_objects <-
                   [ g_user   gr_warning_text;
                     g_button gr_warning_but1;
                     g_button gr_warning_but2
                   ]
        | _ -> gr_warning_but1.bt_left <- delta;
               gr_warning_but1.bt_callback <- List.(0).warn_callback;
               gr_warning_but1.bt_name <- string_type List.(0).warn_name;
               gr_warning_but2.bt_left <- 2*delta+25;
               gr_warning_but2.bt_callback <- List.(1).warn_callback;
               gr_warning_but2.bt_name <- string_type List.(1).warn_name;
               gr_warning_but3.bt_left <- 3*delta+2*25;
               gr_warning_but3.bt_callback <- List.(2).warn_callback;
               gr_warning_but3.bt_name <- string_type List.(2).warn_name;
               gr_warning_window.win_objects <-
                   [ g_user   gr_warning_text;
                     g_button gr_warning_but1;
                     g_button gr_warning_but2;
                     g_button gr_warning_but3
                   ]
      );
      gr_warning_text.us_param.(2) <- string_type Name;
      let nb_lines=vect_length (cut_line Name)
      and dy=line_height+short_space in
        gr_warning_window_def.win_height <- 40 + to_win_coord (dy*nb_lines);
        gr_warning_text.us_param.(1) <-
          int_type (gr_warning_window_def.win_height-5);
        block_loop gr_warning_window
;;

let close_warning Obj_graph Event =
  erase_window gr_warning_window.win_def
;;











let answer=ref gr_ans1;;

let warn_callback1 Obj Event =
  answer := gr_ans1;
  erase_window gr_warning_window.win_def
;;

let warn_callback2 Obj Event =
  answer := gr_ans2;
  erase_window gr_warning_window.win_def
;;

let warn_callback3 Obj Event =
  answer := gr_ans3;
  erase_window gr_warning_window.win_def
;;

let warn_button () =
  !answer
;;

