#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_item";;
#open "g_menu";;



let next_menu = make_image
[|
  [| white;   white;  white;    white;    white;    white;    black;    transp;   transp |];
  [| white;  transp;  transp;   transp;   transp;   nextgrey; black;    transp;   transp |];
  [| white;  nextgrey;nextgrey; nextgrey; nextgrey; nextgrey; black;    nextgrey; nextgrey |];
  [| black;  black;   black;    black;     black;   black;    black;    nextgrey; nextgrey |];
  [| transp; transp;  nextgrey; nextgrey; nextgrey; nextgrey; nextgrey; nextgrey; nextgrey |];
  [| transp; transp;  nextgrey; nextgrey; nextgrey; nextgrey; nextgrey; nextgrey; nextgrey |]
|];;



let Item_toolbar_size String =
  match (get_gr_look()) with
      Open_look_color -> 10*short_space+fst(text_size String)
    | Open_look_mono  -> 10*short_space+fst(text_size String)
    | Next_color      -> 10*short_space+fst(text_size String)
    | Window_color    -> 6*short_space+fst(text_size String)
    | _               -> 6*short_space+fst(text_size String )
;;



let rec std_draw_gr_toolbar_loop Toolbar Left Pos =
  if not Pos=vect_length Toolbar.tb_items
  then
  (
    let Menu = Toolbar.tb_items.(Pos)
    and height=to_real_coord Toolbar.tb_window.win_height in
      let string_height = line_height +2*short_space
      and string_width = Item_toolbar_size Menu.mn_name in
        set_color black;
        moveto (Left+3*short_space)
               (height-long_space-line_height-short_space);
        draw_string Menu.mn_name;
        std_draw_gr_toolbar_loop Toolbar (Left+string_width+2*short_space) (Pos+1)
  )
;;




let std_draw_gr_toolbar Toolbar =
  let width = to_real_coord Toolbar.tb_window.win_width
  and height = to_real_coord Toolbar.tb_window.win_height in
    draw_button 0 height width (line_height + 2*long_space) Up;
    set_color black;
    moveto long_space (height - line_height -2*short_space);

    std_draw_gr_toolbar_loop Toolbar short_space 0
;;






let rec windows_draw_gr_toolbar_loop Toolbar Left Pos =
  if not Pos=vect_length Toolbar.tb_items
  then
  (
    let Menu = Toolbar.tb_items.(Pos)
    and height=to_real_coord Toolbar.tb_window.win_height in
      let string_height = line_height +2*short_space
      and string_width = Item_toolbar_size Menu.mn_name in
        if Menu.mn_state=Visible
        then
        (
          set_color winblue;
          fill_rect Left (height-line_height-2*long_space)
                         string_width (line_height+2*long_space-2);
          set_color white
        )
        else set_color black;

        moveto (Left+3*short_space)
               (height-long_space-line_height-short_space);
        draw_string Menu.mn_name;
        windows_draw_gr_toolbar_loop Toolbar (Left+string_width+2*short_space)
                                             (Pos+1)
  )
;;

let windows_draw_gr_toolbar Toolbar =
  let width = to_real_coord Toolbar.tb_window.win_width
  and wheight = to_real_coord Toolbar.tb_window.win_height
  and height  = (line_height + 2*long_space) in
    set_color white;
    fill_rect 0 (wheight-height) width height;
    set_color black;
    draw_rect 0 (wheight-height) width height;

  windows_draw_gr_toolbar_loop Toolbar short_space 0
;;






let rec open_draw_gr_toolbar_loop Toolbar Left Pos =
  if not Pos=vect_length Toolbar.tb_items
  then
  (
    let Menu = Toolbar.tb_items.(Pos)
    and height=to_real_coord Toolbar.tb_window.win_height in
      let string_height = line_height +2*short_space
      and string_width = Item_toolbar_size Menu.mn_name in
        if Menu.mn_state=Visible 
        then
        (
             draw_button Left (height-long_space)
                    string_width string_height Down;
             set_color white
        )
        else
        (
             draw_button Left (height-long_space)
                    string_width string_height Up;
             set_color black
        );
        moveto (Left+3*short_space)
               (height-long_space-line_height-short_space);
        draw_string Menu.mn_name;
          draw_triangle (Left +string_width - 5*short_space)
                        (height-long_space -2*short_space)
                        (line_height/2);
          open_draw_gr_toolbar_loop Toolbar (Left+string_width+2*short_space) (Pos+1)
  )
;;

let open_draw_gr_toolbar Toolbar =
  open_draw_gr_toolbar_loop Toolbar short_space 0;;



let rec next_draw_gr_toolbar_loop Toolbar Left Pos =
  if not Pos=vect_length Toolbar.tb_items
  then
  (
    let Menu = Toolbar.tb_items.(Pos)
    and height=to_real_coord Toolbar.tb_window.win_height in
      let string_height = line_height +2*short_space
      and string_width = Item_toolbar_size Menu.mn_name in
        if Menu.mn_state=Visible 
        then
        (
             draw_button Left (height-long_space)
                    string_width string_height Down;
             set_color white
        )
        else
        (
             draw_button Left (height-long_space)
                    string_width string_height Up;
             set_color black
        );
        moveto (Left+3*short_space)
               (height-long_space-line_height-short_space);
        draw_string Menu.mn_name;
        draw_image next_menu 
                   (Left +string_width - 5*short_space)
                   (height-long_space-(string_height+6)/2);
        next_draw_gr_toolbar_loop Toolbar (Left+string_width+2*short_space) 
                                  (Pos+1)
  )
;;

let next_draw_gr_toolbar Toolbar =
  next_draw_gr_toolbar_loop Toolbar short_space 0;;









let draw_gr_toolbar Toolbar =
  if Toolbar.tb_window.win_state=Created
  then
  (
    set_draw_window Toolbar.tb_window.win_id;
    let n=vect_length Toolbar.tb_items in
      for i=0 to (n-1) do
      (
        let Menu=Toolbar.tb_items.(i) in
        if Menu.mn_state=Visible
        then draw_gr_menu Menu
      )
      done;

    match (get_gr_look()) with
        Open_look_color -> open_draw_gr_toolbar Toolbar
      | Open_look_mono  -> open_draw_gr_toolbar Toolbar
      | Window_color    -> windows_draw_gr_toolbar Toolbar
      | Next_color      -> next_draw_gr_toolbar Toolbar
      | _               -> std_draw_gr_toolbar Toolbar
  )
;;




let rec gr_toolbar_callback_loop Toolbar Event Left Pos =
  if Pos=vect_length Toolbar.tb_items
  then false
  else
  (
    let mouse_coord={x=Event.mouse_x; y=Event.mouse_y}
    and Menu=Toolbar.tb_items.(Pos) in
      let string_height = line_height +2*long_space
      and string_width= Item_toolbar_size Menu.mn_name in
        let toolbar_area={x1=Left;
                          y1=(to_real_coord Toolbar.tb_window.win_height)-string_height;
                          x2=Left+string_width;
                          y2=to_real_coord Toolbar.tb_window.win_height} in
          if ( inside mouse_coord toolbar_area )
          then
          (
            let menu_width=(gr_menu_width Menu.mn_items) + 2*long_space
            and window_width=to_real_coord Toolbar.tb_window.win_width in
              let x=match (Left+menu_width>window_width,
                           Left-menu_width<0) with
                    (false, _)     -> Left
                  | (true, false)  -> Left-menu_width
                  | (true, true)   -> short_space
              and y=(to_real_coord Toolbar.tb_window.win_height) - string_height - 1 in
                gr_open_menu Menu x y;
                draw_gr_toolbar Toolbar;
                draw_gr_menu Menu;
                true
          )
          else gr_toolbar_callback_loop Toolbar Event (Left+string_width+2*short_space) (Pos+1)
  )
;;



let gr_toolbar_callback Toolbar Event =
  let dealt = ref false
  and n=vect_length Toolbar.tb_items in
    for i=0 to (n-1) do
    (
      let Menu=Toolbar.tb_items.(i) in
      if Menu.mn_state=Visible
      then
      (
        gr_menu_callback Menu Event;
        dealt := true;
        if Menu.mn_state=Unvisible
        then draw_gr_toolbar Toolbar
      )
    )
    done;
    if not !dealt
    then  gr_toolbar_callback_loop Toolbar Event long_space 0
    else true
;;

