#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;




(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let rec gr_nb_char_display_loop String NbChar Width=
  if String.st_1st_char+NbChar < string_length String.st_name
  then
    let display_string=sub_string String.st_name
                                   String.st_1st_char
                                   NbChar in
      let string_dot=fst (text_size display_string) in
        if string_dot >= Width
        then NbChar - 1
        else gr_nb_char_display_loop String (NbChar + 1) Width
  else NbChar - 1;;

let gr_nb_char_display String =
  gr_nb_char_display_loop String 0 (to_real_coord String.st_width);;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let open_cursor_size = 7;;
let draw_open_cursor x y =
  fill_poly [| (x,y);
               ((x-open_cursor_size/2),y-open_cursor_size);
               ((x+open_cursor_size/2),y-open_cursor_size);
               (x,y) |];;


(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let open_mono_draw_gr_string String =
  let left = to_real_coord String.st_left
  and top  = to_real_coord String.st_top
  and width= to_real_coord String.st_width in

  set_color (backcolor ());
  fill_rect (left+short_space) (top - (line_height + 4*short_space))
            (width - 2*short_space) (line_height + 4*short_space);

  set_color black;
  moveto left (top-line_height-2*short_space);
  lineto (left+width) (top-line_height-2*short_space);

  set_clip_area (left+short_space) (top - (line_height + 4*short_space))
                (width - 2*short_space) (line_height + 4*short_space);

  moveto ( left + 2*short_space ) ( top - 2*short_space - line_height );

  let drawing_string=sub_string String.st_name
                                 String.st_1st_char
                                 (string_length String.st_name -
                                  String.st_1st_char) in
    if String.st_type=Gr_password
    then
      draw_string (make_string (string_length drawing_string) `*`)
    else
      draw_string drawing_string;
  (
    match String.st_state with
      Edited ->
        let string_before_cur=(sub_string String.st_name
                                          String.st_1st_char
                                          (String.st_cursor - String.st_1st_char)) in
          let cursor_pos = fst (text_size (string_before_cur)) in
            draw_open_cursor (left + short_space + cursor_pos)
                             (top - short_space - line_height)
    | _      -> ()
  );
  set_clip_area 0 0 (screen_width ()) (screen_height ())
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let open_col_draw_gr_string String =
  let left = to_real_coord String.st_left
  and top  = to_real_coord String.st_top
  and width= to_real_coord String.st_width in
    set_color (backcolor ());
    fill_rect (left+short_space) (top - (line_height + 4*short_space))
              (width - 2*short_space) (line_height + 4*short_space);
    draw_button left (top-line_height-2*short_space) width 1 Up;

  set_clip_area (left+short_space) (top - (line_height + 4*short_space))
                (width - 2*short_space) (line_height + 4*short_space);

  moveto (left + 2*short_space) (top - 2*short_space - line_height);

  set_color black;
  let drawing_string=sub_string String.st_name
                                 String.st_1st_char
                                 (string_length String.st_name -
                                  String.st_1st_char) in
    if String.st_type=Gr_password
    then
      draw_string (make_string (string_length drawing_string) `*`)
    else
      draw_string drawing_string;
  (
    match String.st_state with
      Edited ->
        let string_before_cur=(sub_string String.st_name
                                          String.st_1st_char
                                          (String.st_cursor - String.st_1st_char)) in
          let cursor_pos = fst (text_size (string_before_cur)) in
            draw_open_cursor (left + short_space +cursor_pos)
                             (top - short_space - line_height)
    | _      -> ()
  );
  set_clip_area 0 0 (screen_width ()) (screen_height ())
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let std_draw_gr_string String =
  let left = to_real_coord String.st_left
  and top  = to_real_coord String.st_top
  and width= to_real_coord String.st_width in

  let button={
               bt_window=String.st_window;
               bt_top= String.st_top;
               bt_left= String.st_left;
               bt_width= String.st_width;
               bt_height= to_win_coord (line_height + 4*short_space);
               bt_name=string_type "";
               bt_state=Down;
               bt_callback=do_nothing
             } in
    draw_unfilled_gr_button button;

  set_color white;

  fill_rect (left+short_space)
            (top - (line_height + 3*short_space))
            (width - 2*short_space)
            (line_height + 2*short_space);

  set_clip_area (left+short_space)
                (top - (line_height + 3*short_space))
                (width - 2*short_space)
                (line_height + 2*short_space);

  moveto ( left + 2*short_space )
         ( top - 2*short_space - line_height );
  set_color black;
  let drawing_string=(sub_string String.st_name
                                 String.st_1st_char
                                 (string_length String.st_name -
                                  String.st_1st_char)) in
    if String.st_type=Gr_password
    then
       draw_string (make_string (string_length drawing_string) `*`)
    else
       draw_string drawing_string;
  (
    match String.st_state with
      Edited ->
        let string_before_cur=(sub_string String.st_name
                                          String.st_1st_char
                                          (String.st_cursor - String.st_1st_char)) in
          let cursor_pos = fst (text_size (string_before_cur)) in
              moveto (left + 2*short_space +cursor_pos)
                     (top - 2*short_space - line_height);

              lineto (left + 2*short_space +cursor_pos)
                     (top - 2*short_space)
    | _      -> ()
  );
  set_clip_area 0 0 (screen_width ()) (screen_height ())
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let motif_draw_gr_string String =
  let left = to_real_coord String.st_left
  and top  = to_real_coord String.st_top
  and width= to_real_coord String.st_width in

  let button={
               bt_window=String.st_window;
               bt_top= String.st_top;
               bt_left= String.st_left;
               bt_width= String.st_width;
               bt_height= to_win_coord (line_height + 4*short_space);
               bt_name=string_type "";
               bt_state=Down;
               bt_callback=do_nothing
             } in
    draw_gr_button button;

(*
  set_color darkblue;

  fill_rect (left+short_space)
            (top - (line_height + 3*short_space))
            (width - 2*short_space)
            (line_height + 2*short_space);
*)
  set_clip_area (left+short_space)
                (top - (line_height + 3*short_space))
                (width - 2*short_space)
                (line_height + 2*short_space);

  moveto ( left + 2*short_space )
         ( top - 2*short_space - line_height );
  set_color white;
  let drawing_string=(sub_string String.st_name
                                 String.st_1st_char
                                 (string_length String.st_name -
                                  String.st_1st_char)) in
    if String.st_type=Gr_password
    then
       draw_string (make_string (string_length drawing_string) `*`)
    else
       draw_string drawing_string;
  (
    match String.st_state with
      Edited ->
        let string_before_cur=(sub_string String.st_name
                                          String.st_1st_char
                                          (String.st_cursor - String.st_1st_char)) in
          let cursor_pos = fst (text_size (string_before_cur)) in
              moveto (left + 2*short_space +cursor_pos)
                     (top - 2*short_space - line_height);

              lineto (left + 2*short_space +cursor_pos)
                     (top - 2*short_space)
    | _      -> ()
  );
  set_clip_area 0 0 (screen_width ()) (screen_height ())
;;







(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let windows_draw_gr_string String =
  let left = to_real_coord String.st_left
  and top  = to_real_coord String.st_top
  and width= to_real_coord String.st_width
  and height= (line_height + 4*short_space) in

    set_color black;
    draw_rect left (top-height)
              width height;

  set_color white;

  fill_rect (left+1)
            (top - height + 1)
            (width - 2)
            (height - 2);

  set_clip_area (left+short_space)
                (top - (line_height + 3*short_space))
                (width - 2*short_space)
                (line_height + 2*short_space);

  moveto ( left + 2*short_space )
         ( top - 2*short_space - line_height );
  set_color black;
  let drawing_string=(sub_string String.st_name
                                 String.st_1st_char
                                 (string_length String.st_name -
                                  String.st_1st_char)) in
    if String.st_type=Gr_password
    then
       draw_string (make_string (string_length drawing_string) `*`)
    else
       draw_string drawing_string;
  (
    match String.st_state with
      Edited ->
        let string_before_cur=(sub_string String.st_name
                                          String.st_1st_char
                                          (String.st_cursor - String.st_1st_char)) in
          let cursor_pos = fst (text_size (string_before_cur)) in
              moveto (left + 2*short_space +cursor_pos)
                     (top - 2*short_space - line_height);

              lineto (left + 2*short_space +cursor_pos)
                     (top - 2*short_space)
    | _      -> ()
  );
  set_clip_area 0 0 (screen_width ()) (screen_height ())
;;



(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let draw_gr_string String =
  if String.st_window.win_state=Created
  then
  (
    set_draw_window String.st_window.win_id;
    let n=string_length String.st_name in
      if String.st_cursor > n
        then String.st_cursor <- n;
      if String.st_1st_char > String.st_cursor
        then String.st_1st_char <- String.st_cursor;
      if String.st_cursor < 0
        then String.st_cursor <- 0;
      if String.st_1st_char < 0
        then String.st_1st_char <- 0;
    match (get_gr_look()) with
        Std_color       -> std_draw_gr_string String
      | Std_mono        -> std_draw_gr_string String
      | Open_look_color -> open_col_draw_gr_string String
      | Open_look_mono  -> open_mono_draw_gr_string String
      | Window_color    -> windows_draw_gr_string String
      | Motif_color     -> motif_draw_gr_string String
      | _               -> std_draw_gr_string String
  )
;;








(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let rec gr_string_pos_loop Text Dx Pos Max=
  if Pos > Max 
  then Max
  else 
  (
    let string_before=(sub_string Text 0 Pos) in
      let Pos_dx=(fst (text_size string_before)) in
       if Pos_dx <= Dx
       then gr_string_pos_loop Text Dx (Pos + 1) Max
       else (Pos - 1)
  )
;;



let gr_string_pos String X =
  let n1=(string_length String.st_name) in
    let Text=(sub_string String.st_name
                         String.st_1st_char
                         (n1 - String.st_1st_char)) in
      let Left=to_real_coord String.st_left
      and n=(string_length Text) in
        let dot_length=(X - Left) in
          (String.st_1st_char +
           gr_string_pos_loop Text dot_length 0 n)
;;







(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let rec gr_edit_string String Add =
  let left = to_real_coord String.st_left
  and top  = to_real_coord String.st_top
  and width= to_real_coord String.st_width in

  let Pos=String.st_cursor
  and Text=String.st_name
  and n=string_length String.st_name
  and First=String.st_1st_char in
   match Add with
     0x0008       ->  (* Back space *)
        if not Pos=0
        then
        (
          let string_start=sub_string Text 0 (Pos - 1)
          and string_end=sub_string Text Pos (n - Pos) in
            String.st_name <- (string_start ^ string_end);
            gr_edit_string String Left_key
        )
  | 0x007f       -> (*Del *)
      gr_edit_string String Del_key

  | 0xff09       ->  (* Del *)
        if not Pos=n
        then
        (
          let string_start=sub_string Text 0 Pos
          and string_end=sub_string Text (Pos+1) (n - Pos-1) in
            String.st_name <- (string_start ^ string_end)
        )

  | 0xff00         ->  (* Cursor to right *)
      if Pos<n
      then
      (
        String.st_cursor <- (Pos + 1);
        if (((fst (text_size (sub_string Text First (Pos - First+1)))) >=
             (width- 2*short_space)) &
            not (First=n))
        then String.st_1st_char <- First + 1
      )

  | 0xff01         ->  (* Cursor to left *)
      if Pos>0
      then
      (
        String.st_cursor <- Pos - 1;
        if ((String.st_cursor <= First) & not (First=0))
        then String.st_1st_char <- First - 1
      )

  | 0xff06         ->  (* Home *)
      String.st_cursor <- 0;
      String.st_1st_char <- 0

  | 0xff07         ->  (* End *)
      String.st_cursor <- n;
      String.st_1st_char <- max 0 (n-(gr_nb_char_display String)-1)

  | 0x000d         ->  (* LF *)
      String.st_cursor <- 0;
      String.st_1st_char <- 0

  | 0xff02         -> (* Cursor up *)
      (
        match String.st_type with
          Gr_natural -> String.st_name <- string_of_int ((int_of_string Text) + 1)
        | Gr_int     -> String.st_name <- string_of_int ((int_of_string Text) + 1)
        | Gr_hexa    -> ()
        | Gr_float   -> String.st_name <- string_of_float ((float_of_string Text) +. 1.0)
        | _          -> ()
      )

  | 0xff03         -> (* Cursor Down *)
      (
        match String.st_type with
          Gr_natural ->
            let n=int_of_string Text in
              if n>0
              then String.st_name <- string_of_int (n - 1)
        | Gr_int     -> String.st_name <- string_of_int ((int_of_string Text) - 1)
        | Gr_hexa    -> ()
        | Gr_float   -> String.st_name <- string_of_float ((float_of_string Text) -. 1.0)
        | _          -> ()
      )

  | _              ->  (* ASCII key *)
      if Add <= 0xff
      then
      (
        let Char=(char_of_int Add) in
          let correct= match (Char,String.st_type) with
                         (_, Gr_string)    -> true
                       | (_, Gr_password)  -> true
                       | (`0`..`9`, _)     -> true
                       | (`-`, Gr_int)     -> if Pos=0
                                              then true
                                              else false
                       | (`-`, Gr_float)   -> if Pos=0
                                              then true
                                              else false
                       | (`x`, Gr_hexa)    -> if Pos=1 & ((nth_char Text 0)=`0`)
                                              then true
                                              else false
                       | (`.`, Gr_float)   -> true
                       | _                 -> false in
            if correct
            then
            (
              String.st_name <- add_char String.st_name Char String.st_cursor;
              gr_edit_string String Right_key
            )
        )
;;






(*****************************************************************************)
(*                                                                           *)
(*****************************************************************************)
let gr_string_callback String Event =
  let left = to_real_coord String.st_left
  and top  = to_real_coord String.st_top
  and width= to_real_coord String.st_width in

  let mouse_coord={x=Event.mouse_x; y=Event.mouse_y}
  and String_area={x1=left;
                   y1=top-line_height-4*short_space;
                   x2=left+width;
                   y2=top} in
    match (Event.id_event=Key_pressed,
           (inside mouse_coord String_area),
           String.st_state ) with
      (true, _ , Edited) ->
        gr_edit_string String Event.key;
        if Event.key=0x000d (* LF *)
        then (String.st_callback String Event; ());
        draw_gr_string String;
        true
    | (false, true, View_only) -> false
    | (false, true, _ ) ->
        String.st_state <- Edited;
        String.st_cursor <- gr_string_pos String Event.mouse_x;
        draw_gr_string String;
        true
    | (false, false, Edited) ->
        String.st_state <- Editable;
        draw_gr_string String;
        true
    | _ -> false
;;





