#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_list";;
#open "g_prompt";;
#open "g_mloop";;





let gr_select_height = 100;;
let gr_select_width = 85;;


let gr_select_window_def =
{
  win_id = undef_window;
  win_top = (screen_height() + to_real_coord (gr_select_height))/2;
  win_left = (screen_width() - to_real_coord (gr_select_width))/2;
  win_width = gr_select_width;
  win_height = gr_select_height;
  win_name = "Select an item";
  win_state = Destroyed
};;

let gr_select_OK =
{
  bt_window=gr_select_window_def;
  bt_left=(gr_select_width-25)/2;
  bt_top=15;
  bt_width=25;
  bt_height=12;
  bt_name=string_type "Ok";
  bt_state=Up;
  bt_callback= do_nothing
};;


let gr_select_list =
{
  li_window=gr_select_window_def;
  li_left= 5;
  li_top=gr_select_height - 10;
  li_width=gr_select_width - 10;
  li_height=gr_select_height - 27;
  li_nu_item=0;
  li_1st_item=0;
  li_scroll=0;
  li_items=[| |];
  li_callback= do_nothing
};;


let gr_select_prompt=
{
  pt_window=gr_select_window_def;
  pt_left=5;
  pt_top=gr_select_height - 2;
  pt_name="Name:"
};;



let gr_select_window =
{
  win_def=gr_select_window_def;
  win_objects=[g_button gr_select_OK;
               g_list gr_select_list;
               g_prompt gr_select_prompt
              ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;




let rec gr_close_select Obj_graph Event =
  erase_window gr_select_window.win_def;;



(***************************************************************************)
(*                                                                         *)
(* gr_select: string -> string vect -> (int * string);;                    *)
(*                                                                         *)
(***************************************************************************)
let select Prompt Items =
  gr_select_OK.bt_callback <- gr_close_select;
  gr_select_prompt.pt_name <- Prompt;
  gr_select_list.li_items <- Items;
  gr_select_list.li_1st_item <- 0;
  gr_select_list.li_nu_item <- 0;
  gr_select_list.li_scroll <- 0;
  block_loop gr_select_window;
  (gr_select_list.li_nu_item,gr_select_list.li_items.(gr_select_list.li_nu_item))
;;


