#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;


#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;





let next_anchor = make_image
[|
  [| transp;   nextgrey; black;    black;    black;    transp   |];
  [| nextgrey; black;    nextgrey; nextgrey; nextgrey; nextgrey |];
  [| black;    nextgrey; nextgrey; transp;   transp;   transp   |];
  [| black;    nextgrey; transp;   transp;   white;    white    |];
  [| black;    nextgrey; transp;   white;    white;    white    |];
  [| transp;   nextgrey; transp;   white;    white;    transp   |]
|];;

let win_array_up = 
[|
  [| transp; transp; transp; black; transp; transp; transp |];
  [| transp; transp; black;  black; black;  transp; transp |];
  [| transp; black;  black;  black; black;  black;  transp |];
  [| black;  black;  black;  black; black;  black;  black  |];
  [| transp; transp; black;  black; black;  transp; transp |];
  [| transp; transp; black;  black; black;  transp; transp |];
  [| transp; transp; black;  black; black;  transp; transp |]
|];;

let win_array_left = rotate win_array_up;;
let win_array_down = rotate win_array_left;;
let win_array_right = rotate win_array_down;;

let win_arrow_up = make_image win_array_up;;
let win_arrow_down = make_image win_array_down;;
let win_arrow_right = make_image win_array_right;;
let win_arrow_left = make_image win_array_left;;



(***************************************************************************)
(*                                                                         *)
(* elevator_width: int and elevator_height: int define the size of the     *)
(*  elevator in all the scrollbar (horizontal one, and vertical one).      *)
(*                                                                         *)
(***************************************************************************)
let elevator_width = line_height;;
let elevator_height = elevator_width+2;;
let open_elevator_height = 3*line_height;;
let scroll_width = elevator_width + 2;;





let open_triangle_size = 6;;

let draw_triangle_top x y =
  set_color black;
  fill_poly [| (x,y);
               ((x-open_triangle_size/2),y-open_triangle_size-1);
               ((x+open_triangle_size/2),y-open_triangle_size-1);
               (x,y) |]
;;
let draw_triangle_bottom x y =
  set_color black;
  fill_poly [| (x,y);
               ((x-open_triangle_size/2),y+open_triangle_size);
               ((x+open_triangle_size/2),y+open_triangle_size);
               (x,y) |]
;;
let draw_triangle_right x y =
  set_color black;
  fill_poly [| (x,y);
               (x-open_triangle_size,(y-open_triangle_size/2));
               (x-open_triangle_size,(y+open_triangle_size/2));
               (x,y) |]
;;
let draw_triangle_left x y =
  set_color black;
  fill_poly [| (x,y);
               (x+open_triangle_size,(y-open_triangle_size/2));
               (x+open_triangle_size,(y+open_triangle_size/2));
               (x,y) |]
;;







let scroll_course Scroll_length =
  match (get_gr_look()) with
      Std_color       -> Scroll_length - elevator_height - 2
    | Open_look_color -> Scroll_length - open_elevator_height - 12
    | Open_look_mono  -> Scroll_length - open_elevator_height - 12
    | Window_color    -> Scroll_length - 3*elevator_height - 2
    | Motif_color     -> Scroll_length - 3*elevator_height - 2 
    | Next_color      -> Scroll_length - 2*elevator_width - 
                         elevator_height - 2 
    | _               -> Scroll_length - elevator_height - 2
;;





(***************************************************************************)
(*                                                                         *)
(* draw_scrollbar: scrollbar -> unit;;                                     *)
(*                                                                         *)
(***************************************************************************)
let std_draw_vscrollbar left top length pos =
  let width =elevator_width + 2 in
    set_color (backcolor ());
    fill_rect left (top-length) width length;
    draw_button left top width length Down;
    let xline=left + (width / 2) in
      set_color black;
      moveto xline (top - (elevator_height/2));
      lineto xline (top - length + (elevator_height/2));
      set_color (backcolor ());
      moveto xline (top-pos-1-elevator_height);
      lineto xline (top-pos-1);
      draw_button (left+1) (top-pos-1)
                  elevator_width elevator_height Up
;;


let windows_draw_vscrollbar left top length pos =
  let width =elevator_width + 2 in
    set_color (backcolor ());
    fill_rect left (top-length) width length;
    draw_button left top width elevator_height Up;
    draw_button left (top-length+elevator_height) width elevator_height Up;
    draw_image win_arrow_up (left +(width-6)/2) (top-(elevator_height+6)/2);
    draw_image win_arrow_down (left +(width-6)/2) 
               (top-length+(elevator_height-6)/2);
    set_color black;
    draw_rect   left (top-length+elevator_height+1) width (length-2*elevator_height-2);
    draw_button (left+1) (top-elevator_height-pos-1)
                elevator_width elevator_height Up
;;



let open_col_draw_vscrollbar left top length pos =
  let width =elevator_width + 2
  and height=length in
    set_color (backcolor ());
    fill_rect left (top-height) (width+1) height;
    std_col_draw_button left top width 5 Up;
    std_col_draw_button left (top-height+5) width 5 Up;
    set_color black;
    moveto (left + (width / 2))
           (top - (elevator_height/2)-5);
    lineto (left + (width / 2))
           (top - height + (elevator_height/2)+5);
    moveto (left + (width / 2)-1)
           (top - (elevator_height/2)-5);
    lineto (left + (width / 2)-1)
           (top - height + (elevator_height/2)+5);
    moveto (left + (width / 2)+1)
           (top - (elevator_height/2)-5);
    lineto (left + (width / 2)+1)
           (top - height + (elevator_height/2)+5);

    set_color (backcolor ());
    fill_rect left (top-pos-6-open_elevator_height) width 
              open_elevator_height;
    std_col_draw_button left (top-pos-6)
                        width open_elevator_height Up;
    std_col_draw_button left (top-pos-6-3*open_elevator_height/8)
                        width (open_elevator_height/4) Up;
    draw_triangle_top (left+width/2)
                      (top-pos-6-2);
    draw_triangle_bottom (left+width/2)
                         (top-pos-6-open_elevator_height+2)
;;


let open_mono_draw_vscrollbar left top length pos =
  let width =elevator_width + 2
  and height=length in
    set_color (backcolor ());
    fill_rect left (top-height) (width+1) height;
    set_color black;
    draw_rect left (top-5) width 5;
    draw_rect left (top-height) width 5;
    moveto (left + (width / 2))
           (top - (elevator_height/2)-5);
    lineto (left + (width / 2))
           (top - height + (elevator_height/2)+5);
    moveto (left + (width / 2)-1)
           (top - (elevator_height/2)-5);
    lineto (left + (width / 2)-1)
           (top - height + (elevator_height/2)+5);
    moveto (left + (width / 2)+1)
           (top - (elevator_height/2)-5);
    lineto (left + (width / 2)+1)
           (top - height + (elevator_height/2)+5);

    set_color white;
    fill_rect left (top-pos-6-open_elevator_height) width open_elevator_height;
    set_color black;
    draw_rect left (top-pos-6-open_elevator_height)
              width open_elevator_height;
    draw_rect left (top-pos-6-5*open_elevator_height/8)
                        width (open_elevator_height/4);
    draw_triangle_top (left+width/2)
                      (top-pos-6-2);
    draw_triangle_bottom (left+width/2)
                         (top-pos-6-open_elevator_height+2)
;;


let motif_draw_vscrollbar left top length pos =
  let width =elevator_width + 4 in
    draw_button left top width length Down;
    draw_button (left+2) (top-elevator_height-pos-2)
                elevator_width elevator_height Up;
    set_color grey;
    moveto (left+2+elevator_width/2) (top-2);
    lineto (left+2) (top-2-elevator_width);
    lineto (left+2+elevator_width) (top-2-elevator_width);
    set_color black;
    lineto (left+2+elevator_width/2) (top-2);
    set_color grey;
    moveto (left+2+elevator_width/2) (top-3);
    lineto (left+3) (top-1-elevator_width);
    lineto (left+1+elevator_width) (top-1-elevator_width);
    set_color black;
    lineto (left+2+elevator_width/2) (top-3);
    set_color (backcolor ());
    fill_poly [| (left+2+elevator_width/2,top-4);
                 (left+4,top-elevator_width);
                 (left+elevator_width, top-elevator_width);
                 (left+2+elevator_width/2,top-4) |];

    set_color grey;
    moveto (left+2+elevator_width/2) (top-length+2);
    lineto (left+2) (top-length+2+elevator_width);
    lineto (left+2+elevator_width) (top-length+2+elevator_width);
    set_color black;
    lineto (left+2+elevator_width/2) (top-length+2);
    set_color grey;
    moveto (left+2+elevator_width/2) (top-length+3);
    lineto (left+3) (top-length+1+elevator_width);
    lineto (left+1+elevator_width) (top-length+1+elevator_width);
    set_color black;
    lineto (left+2+elevator_width/2) (top-length+3);
    set_color (backcolor ());
    fill_poly [| (left+2+elevator_width/2,top-length+4);
                 (left+4,top-length+elevator_width);
                 (left+elevator_width, top-length+elevator_width);
                 (left+2+elevator_width/2,top-length+4) |]
;;




let next_draw_vscrollbar left top length pos =
  let width =elevator_width + 2 in
    set_color darkgrey;
    fill_rect left (top-length) width length;
    set_color black;
    draw_rect left (top-length) width length;
    set_color grey;
    fill_rect (left+2) (top-pos-elevator_height)
              (elevator_width-1) (elevator_height-2);
    fill_rect (left+2) (top-length+1)
              (elevator_width-1) (2*elevator_width+2);
    draw_button (left+1) (top-pos-1)
                elevator_width elevator_height Up;
    draw_button (left+1) (top-length+elevator_width+1)
                elevator_width elevator_width Up;
    draw_button (left+1) (top-length+2*elevator_width+2)
                elevator_width elevator_width Up;
    set_color black;
    draw_triangle_bottom (left+1+elevator_width/2)
                      (top-length+(elevator_width-open_triangle_size)/2+1);
    draw_triangle_top (left+1+elevator_width/2)
                    (top-length+(3*elevator_width+open_triangle_size)/2+3);
    draw_image next_anchor 
               (left+elevator_width/2-2)(top-pos-elevator_height/2-4)
;;









let std_draw_hscrollbar left top length pos =
  let height = elevator_width + 2 in
    set_color (backcolor ());
    fill_rect left (top-height) length height;
    draw_button left top length height Down;
    let yline = top - (height / 2) in
      set_color black;
      moveto (left + (elevator_height/2)) yline;
      lineto (left + length - (elevator_height/2)) yline;
      set_color (backcolor ());
      moveto (left+pos+1) yline;
      lineto (left+pos+elevator_height+1) yline;
      draw_button (left+pos +1) (top-1)
                  elevator_height elevator_width Up
;;




let windows_draw_hscrollbar left top length pos =
  let height =elevator_width + 2 in
    set_color (backcolor ());
    fill_rect left (top-height) length height;
    draw_button left top elevator_height elevator_height Up;
    draw_button (left+length-elevator_height) top elevator_height
                 elevator_height Up;
    draw_image win_arrow_left (left +(elevator_height-6)/2) 
               (top-(elevator_height+6)/2);
    draw_image win_arrow_right (left + length - (elevator_height+6)/2) 
               (top-(elevator_height+6)/2);
    set_color black;
    draw_rect   (left+elevator_height+1) (top-height) 
                (length-2*elevator_height-2) height;
    draw_button (left+elevator_height+pos+1) top
                elevator_width elevator_height Up
;;





let open_col_draw_hscrollbar left top length pos =
  let width =length
  and height=(elevator_width + 2) in
    set_color (backcolor ());
    fill_rect left (top-height) width (height+1);
    std_col_draw_button left top 5 height Up;
    std_col_draw_button (left+width-5) top 5 height Up;
    set_color black;
    moveto (left +(elevator_height/2)+5)
           (top - height/2);
    lineto (left + width - (elevator_height/2)-5)
           (top - height/2);
    moveto (left +(elevator_height/2)+5)
           (top - height/2-1);
    lineto (left + width - (elevator_height/2)-5)
           (top - height/2-1);
    moveto (left +(elevator_height/2)+5)
           (top - height/2+1);
    lineto (left + width - (elevator_height/2)-5)
           (top - height/2+1);

    set_color (backcolor ());
    fill_rect (left+pos+6) (top-height) open_elevator_height height;
    std_col_draw_button (left+pos+6) top open_elevator_height height Up;
    std_col_draw_button (left+pos+6+3*open_elevator_height/8) top
                        (open_elevator_height/4) height Up;
    draw_triangle_left (left+pos+8) (top-height/2);
    draw_triangle_right (left+pos+4+open_elevator_height)
                        (top-height/2)
;;


let open_mono_draw_hscrollbar left top length pos =
  let width =length
  and height=(elevator_width + 2) in
    set_color (backcolor ());
    fill_rect left (top-height) width (height+1);
    set_color black;
    draw_rect left (top-height) 5 height;
    draw_rect (left+width-5) (top-height) 5 height;
    moveto (left +(elevator_height/2)+5)
           (top - height/2);
    lineto (left + width - (elevator_height/2)-5)
           (top - height/2);
    moveto (left +(elevator_height/2)+5)
           (top - height/2-1);
    lineto (left + width - (elevator_height/2)-5)
           (top - height/2-1);
    moveto (left +(elevator_height/2)+5)
           (top - height/2+1);
    lineto (left + width - (elevator_height/2)-5)
           (top - height/2+1);

    set_color white;
    fill_rect (left+pos+6) (top-height) open_elevator_height height;
    set_color black;
    draw_rect (left+pos+6) (top-height) open_elevator_height height;
    draw_rect (left+pos+6+3*open_elevator_height/8) (top-height)
                        (open_elevator_height/4) height;
    draw_triangle_left (left+pos+8) (top-height/2);
    draw_triangle_right (left+pos+4+open_elevator_height)
                        (top-height/2)
;;



let motif_draw_hscrollbar left top length pos =
  let width = length
  and height = elevator_width + 4 in
    draw_button left top width height Down;
    draw_button (left+pos+4+elevator_width) (top-2)
                elevator_height elevator_width Up;

    set_color grey;
    moveto (left+2) (top-2-elevator_width/2);
    lineto (left+2+elevator_width) (top-2-elevator_width);
    lineto (left+2+elevator_width) (top-2);
    set_color black;
    lineto (left+2) (top-2-elevator_width/2);
    set_color grey;
    moveto (left+3) (top-2-elevator_width/2);
    lineto (left+1+elevator_width) (top-1-elevator_width);
    lineto (left+1+elevator_width) (top-3);
    set_color black;
    lineto (left+3) (top-2-elevator_width/2);
    set_color (backcolor ());
    fill_poly [| (left+4,top-2-elevator_width/2);
                 (left+elevator_width,top-elevator_width);
                 (left+elevator_width, top-4);
                 (left+4,top-2-elevator_width/2) |];

    set_color grey;
    moveto (left+width-2) (top-2-elevator_width/2);
    lineto (left+width-2-elevator_width) (top-2-elevator_width);
    lineto (left+width-2-elevator_width) (top-2);
    set_color black;
    lineto (left+width-2) (top-2-elevator_width/2);
    set_color grey;
    moveto (left+width-3) (top-2-elevator_width/2);
    lineto (left+width-1-elevator_width) (top-1-elevator_width);
    lineto (left+width-1-elevator_width) (top-3);
    set_color black;
    lineto (left+width-3) (top-2-elevator_width/2);
    set_color (backcolor ());
    fill_poly [| (left+width-4,top-2-elevator_width/2);
                 (left+width-elevator_width,top-elevator_width);
                 (left+width-elevator_width, top-4);
                 (left+width-4,top-2-elevator_width/2) |]
;;



let next_draw_hscrollbar left top length pos =
  let height =elevator_width + 2 in
    set_color darkgrey;
    fill_rect left (top-height) length height;
    set_color black;
    draw_rect left (top-height) length height;
    set_color grey;
    fill_rect (left+pos+2*elevator_width+3) (top-height+1)
              (elevator_height-1) (height-2);
    fill_rect (left+1) (top-height+1)
              (2*elevator_width+2) (height-2);
    draw_button (left+pos+2*elevator_width+3) (top-1)
                elevator_height elevator_width Up;
    draw_button (left+1) (top-1)
                elevator_width elevator_width Up;
    draw_button (left+elevator_width+2) (top-1)
                elevator_width elevator_width Up;
    set_color black;
    draw_triangle_left (left+1+(elevator_width-open_triangle_size)/2)
                      (top-elevator_width/2);
    draw_triangle_right (left+2+(3*elevator_width+open_triangle_size)/2)
                    (top-elevator_width/2);
    draw_image next_anchor 
               (left+pos+2*elevator_width+elevator_height/2)
               (top-elevator_width/2-3)
;;





let draw_vscrollbar left top length pos =
  match (get_gr_look()) with
      Open_look_color -> open_col_draw_vscrollbar left top length pos
    | Open_look_mono  -> open_mono_draw_vscrollbar left top length pos
    | Window_color    -> windows_draw_vscrollbar left top length pos
    | Motif_color     -> motif_draw_vscrollbar left top length pos
    | Next_color      -> next_draw_vscrollbar left top length pos
    | _               -> std_draw_vscrollbar left top length pos
;;


let draw_hscrollbar left top length pos =
  match (get_gr_look()) with
      Open_look_color -> open_col_draw_hscrollbar left top length pos
    | Open_look_mono  -> open_mono_draw_hscrollbar left top length pos
    | Window_color    -> windows_draw_hscrollbar left top length pos
    | Motif_color     -> motif_draw_hscrollbar left top length pos
    | Next_color      -> next_draw_hscrollbar left top length pos
    | _               -> std_draw_hscrollbar left top length pos
;;




let draw_gr_scrollbar Scroll =
  if Scroll.sb_window.win_state=Created
  then
  (
    set_draw_window Scroll.sb_window.win_id;
    let top    = to_real_coord Scroll.sb_top
    and left   = to_real_coord Scroll.sb_left
    and length = to_real_coord Scroll.sb_length in
      Scroll.sb_pos <- max 0 Scroll.sb_pos;
      Scroll.sb_pos <- min Scroll.sb_pos (scroll_course length);

      match Scroll.sb_dir with
        Vertical   -> draw_vscrollbar left top length Scroll.sb_pos
      | Horizontal -> draw_hscrollbar left top length Scroll.sb_pos
  )
;;




let event_call = ref false;;


(***************************************************************************)
(*                                                                         *)
(* gr_scrollbar_pos: gr_scrollbar -> int -> int;;                          *)
(*  Return the nearest and correct position of elevator in the scrollbar   *)
(*   Scroll                                                                *)
(*                                                                         *)
(***************************************************************************)
let gr_scrollbar_pos Scroll Pos=
  match ((Pos < 0), (Pos > (scroll_course Scroll.sb_length))) with
      (true, _) -> 0
    | (_, true) -> scroll_course Scroll.sb_length
    | (_, _)    -> Pos;;




(***************************************************************************)
(*                                                                         *)
(* gr_vscrollbar_drag_elevator: gr_scrollbar -> status -> int -> bool;;    *)
(*                                                                         *)
(***************************************************************************)
let gr_vscrollbar_drag_elevator Scroll Event deltay =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord = { x = left + 1; y = Event.mouse_y }
  and scroll_area = { x1 = left;
                      y1 = top - length;
                      x2 = left + elevator_width + 1;
                      y2 = top 
                    }
  and Pos = top - Event.mouse_y - elevator_height/2 - deltay  in
    match ((inside mouse_coord scroll_area ), Event.button) with
        (true, true)  ->
          Scroll.sb_pos <- gr_scrollbar_pos Scroll Pos;
          draw_vscrollbar left top length Scroll.sb_pos;
          true
      | (true, false) ->
          Scroll.sb_pos <- gr_scrollbar_pos Scroll Pos;
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          false
      | (false, _)    ->
          event_call := true;
          false
;;



(***************************************************************************)
(*                                                                         *)
(* gr_vscrollbar_loop: gr_scrollbar -> int -> bool;;                       *)
(*                                                                         *)
(***************************************************************************)
let gr_vscrollbar_loop Scroll deltay =
  while gr_vscrollbar_drag_elevator Scroll 
                                    (get_event([Button_up; Mouse_motion]))
                                    deltay
  do () done
;;



(***************************************************************************)
(*                                                                         *)
(* gr_vscrollbar_callback: gr_scrollbar -> status -> bool;;                *)
(*                                                                         *)
(***************************************************************************)
let next_vscrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord = { x = Event.mouse_x; y = Event.mouse_y }
  and elevator_area = { x1 = left + 1;
                        y1 = top - Scroll.sb_pos - elevator_height - 1;
                        x2 = left + elevator_width + 1;
                        y2 = top - Scroll.sb_pos - 1
                      }
  and scroll_area = { x1 = left;
                      y1 = top - length;
                      x2 = left + elevator_width + 1;
                      y2 = top
                     } 
  and up_area = { x1 = left + 1;
                  y1 = top - length + elevator_width + 2;
                  x2 = left + elevator_width + 1;
                  y2 = top - length + 2*elevator_width + 2
                } 
  and bottom_area = { x1 = left + 1;
                      y1 = top - length + 1;
                      x2 = left + elevator_width + 1;
                      y2 = top - length + elevator_width
                    } in
    match (Event.button,
           inside mouse_coord elevator_area,
           inside mouse_coord scroll_area,
           inside mouse_coord up_area,
           inside mouse_coord bottom_area
          ) with
      (true, _, _, true, _ ) -> (* up button *)
          Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                             (Scroll.sb_pos - (max 1 Scroll.sb_delta/10));
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | (true, _, _, _, true ) -> (* down button *)
          Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                             (Scroll.sb_pos + (max 1 Scroll.sb_delta/10));
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | (true, true, true, _, _ )  ->
          gr_vscrollbar_loop Scroll 0;
          true
    | (true, false, true, _, _ ) ->
          Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                 (top - Event.mouse_y - elevator_height/2);
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | ( _ , _ , _ , _ , _ )       -> false
;;



let motif_vscrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord = { x = Event.mouse_x; y = Event.mouse_y }
  and elevator_area = { x1 = left + 1;
                        y1 = top - Scroll.sb_pos - elevator_height -
                             elevator_width - 1;
                        x2 = left + elevator_width + 1;
                        y2 = top - Scroll.sb_pos - elevator_width - 1
                      }
  and scroll_area = { x1 = left;
                      y1 = top - length;
                      x2 = left + elevator_width + 1;
                      y2 = top
                     } 
  and up_area = { x1 = left + 1;
                  y1 = top - elevator_width - 1;
                  x2 = left + elevator_width + 1;
                  y2 = top - 1
                } 
  and bottom_area = { x1 = left + 1;
                      y1 = top - length + 1;
                      x2 = left + elevator_width + 1;
                      y2 = top - length + elevator_width
                    } in
    match (Event.button,
           inside mouse_coord elevator_area,
           inside mouse_coord scroll_area,
           inside mouse_coord up_area,
           inside mouse_coord bottom_area
          ) with
      (true, _, _, true, _ ) -> (* up button *)
          Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                             (Scroll.sb_pos - (max 1 Scroll.sb_delta/10));
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | (true, _, _, _, true ) -> (* down button *)
          Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                             (Scroll.sb_pos + (max 1 Scroll.sb_delta/10));
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | (true, true, true, _, _ )  ->
          gr_vscrollbar_loop Scroll elevator_width;
          true
    | (true, false, true, _, _ ) ->
          if Event.mouse_y > (top - elevator_width - Scroll.sb_pos)
          then Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                          (Scroll.sb_pos - Scroll.sb_delta)
          else Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                          (Scroll.sb_pos + Scroll.sb_delta);
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | ( _ , _ , _ , _ , _ )       -> false
;;



let open_vscrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord = { x = Event.mouse_x; y = Event.mouse_y }
  and elevator_area = { x1 = left + 1;
                        y1 = top - Scroll.sb_pos - elevator_height -
                             elevator_width - 1;
                        x2 = left + elevator_width + 1;
                        y2 = top - Scroll.sb_pos - elevator_width - 1
                      }
  and scroll_area = { x1 = left;
                      y1 = top - length;
                      x2 = left + elevator_width + 1;
                      y2 = top
                     } 
  and home_area = { x1 = left + 1;
                    y1 = top  - 5;
                    x2 = left + elevator_width + 1;
                    y2 = top - 1
                  } 
  and end_area = { x1 = left + 1;
                   y1 = top - length + 1;
                   x2 = left + elevator_width + 1;
                   y2 = top - length + 5
                 }
  and up_area = { x1 = left + 1;
                  y1 = top - Scroll.sb_pos - 6;
                  x2 = left + elevator_width +1;
                  y2 = top - Scroll.sb_pos - 6 -
                       3*open_elevator_height/8
                } 
  and bottom_area = { x1 = left + 1;
                      y1 = top - Scroll.sb_pos - 6 -
                           5*open_elevator_height/8 ;
                      x2 = left + elevator_width + 1;
                      y2 = top -  Scroll.sb_pos - 6 -
                           open_elevator_height
                    } in
    match (Event.button,
           inside mouse_coord elevator_area,
           inside mouse_coord scroll_area,
           inside mouse_coord up_area,
           inside mouse_coord bottom_area,
           inside mouse_coord home_area,
           inside mouse_coord end_area
          ) with
      (true, _, _, true, _, _, _ ) -> (* up button *)
          Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                             (Scroll.sb_pos - (max 1 Scroll.sb_delta/10));
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | (true, _, _, _, true, _, _ ) -> (* down button *)
          Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                             (Scroll.sb_pos + (max 1 Scroll.sb_delta/10));
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | (true, _, _, _, _,true , _ ) -> (* home button *)
          Scroll.sb_pos <- gr_scrollbar_pos Scroll 0;
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | (true, _, _, _, _, _, true ) -> (* end button *)
          Scroll.sb_pos <- gr_scrollbar_pos Scroll length;
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | (true, true, true, _, _, _, _ )  ->
          gr_vscrollbar_loop Scroll elevator_width;
          true
    | (true, false, true, _, _, _, _ ) ->
          if Event.mouse_y > (top - elevator_width - Scroll.sb_pos)
          then Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                          (Scroll.sb_pos - Scroll.sb_delta)
          else Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                          (Scroll.sb_pos + Scroll.sb_delta);
          draw_vscrollbar left top length Scroll.sb_pos;
          event_call := true;
          true
    | ( _ , _ , _ , _ , _, _, _ )       -> false
;;



let std_vscrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord={x=Event.mouse_x; y=Event.mouse_y}
  and elevator_area={x1=left + 1;
                  y1=top - Scroll.sb_pos - elevator_height - 1;
                  x2=left + elevator_width + 1;
                  y2=top - Scroll.sb_pos - 1
                  }
  and scroll_area={x1=left;
                   y1=top - length;
                   x2=left + elevator_width + 1;
                   y2=top
                  } in
    match (Event.button,
           inside mouse_coord elevator_area,
           inside mouse_coord scroll_area ) with
      (true, true, true)  ->
        gr_vscrollbar_loop Scroll 0;
        true
    | (true, false, true) ->
        if Event.mouse_y > (top - Scroll.sb_pos)
        then Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                          (Scroll.sb_pos - Scroll.sb_delta)
        else Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                          (Scroll.sb_pos + Scroll.sb_delta);
        draw_vscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | ( _ , _ , _ )       -> false
;;




let gr_vscrollbar_callback Scroll Event =
  match (get_gr_look()) with
      Open_look_color -> open_vscrollbar_callback Scroll Event
    | Open_look_mono  -> open_vscrollbar_callback Scroll Event
    | Window_color    -> motif_vscrollbar_callback Scroll Event
    | Motif_color     -> motif_vscrollbar_callback Scroll Event
    | Next_color      -> next_vscrollbar_callback Scroll Event
    | _               -> std_vscrollbar_callback Scroll Event
;;




(***************************************************************************)
(*                                                                         *)
(* gr_hscrollbar_drag_elevator: gr_scrollbar -> status -> int -> bool      *)
(*                                                                         *)
(***************************************************************************)
let gr_hscrollbar_drag_elevator Scroll Event deltax =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord={x=Event.mouse_x; y=top-1}
  and scroll_area={x1=left;
                   y1=top - elevator_width - 1;
                   x2=left + length;
                   y2=top
                  }
  and Pos=Event.mouse_x - left - elevator_height/2 - deltax in
    match ((inside mouse_coord scroll_area ), Event.button) with
      (true, true)  ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll Pos;
        draw_hscrollbar left top length Scroll.sb_pos;
        true
    | (true, false) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll Pos;
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        false
    | (false, _)    ->
        Scroll.sb_callback Scroll Event;
        false
;;



(***************************************************************************)
(*                                                                         *)
(* gr_hscrollbar_loop: gr_scrollbar -> int -> bool                         *)
(*                                                                         *)
(***************************************************************************)
let gr_hscrollbar_loop Scroll deltax =
  while gr_hscrollbar_drag_elevator Scroll 
                                    (get_event([Button_up; Mouse_motion]))
                                    deltax
  do () done;;



(***************************************************************************)
(*                                                                         *)
(* gr_hscrollbar_callback: gr_scrollbar -> status -> bool;;                *)
(*                                                                         *)
(***************************************************************************)
let next_hscrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord = { x = Event.mouse_x; y = Event.mouse_y }
  and elevator_area = { x1 = left + Scroll.sb_pos + 2*elevator_width + 2;
                        y1 = top - elevator_width - 1;
                        x2 = left + Scroll.sb_pos + 2*elevator_width + 
                             elevator_height + 2;
                        y2 = top - 1
                      }
  and scroll_area = { x1 = left;
                      y1 = top - elevator_width - 1;
                      x2 = left + length;
                      y2 = top
                    }
  and left_area = { x1 = left + 1;
                    y1 = top - elevator_width - 1;
                    x2 = left + elevator_width;
                    y2 = top - 1
                  }
  and right_area = { x1 = left + elevator_width + 2;
                     y1 = top - elevator_width - 1;
                     x2 = left + 2*elevator_width + 2;
                     y2 = top - 1
                   } in
    match (Event.button,
           inside mouse_coord elevator_area,
           inside mouse_coord scroll_area,
           inside mouse_coord left_area,
           inside mouse_coord right_area ) with
      (true, _, _, true, _) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                            (Scroll.sb_pos - (max 1 Scroll.sb_delta/10));
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | (true, _, _, _, true) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                            (Scroll.sb_pos + (max 1 Scroll.sb_delta/10));
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | (true, true, true, _, _ )  ->
        gr_hscrollbar_loop Scroll (2*elevator_width + 2);
        true
    | (true, false, true, _, _ ) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                            (Event.mouse_x - Scroll.sb_left - 
                             2*elevator_width - 2 - elevator_height/2);
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | ( _ , _ , _, _, _ )       -> false
;;




let motif_hscrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord = { x = Event.mouse_x; y = Event.mouse_y }
  and elevator_area = { x1 = left + Scroll.sb_pos + elevator_width + 1;
                        y1 = top - elevator_width - 1;
                        x2 = left + Scroll.sb_pos + elevator_width +
                             elevator_height + 1;
                        y2 = top - 1
                      }
  and scroll_area = { x1 = left;
                      y1 = top - elevator_width - 1;
                      x2 = left + length;
                      y2 = top
                    }
  and left_area = { x1 = left + 1;
                    y1 = top - elevator_width - 1;
                    x2 = left + elevator_width;
                    y2 = top - 1
                  }
  and right_area = { x1 = left + length - 1;
                     y1 = top - elevator_width - 1;
                     x2 = left + length - elevator_width;
                     y2 = top - 1
                   } in
    match (Event.button,
           inside mouse_coord elevator_area,
           inside mouse_coord scroll_area,
           inside mouse_coord left_area,
           inside mouse_coord right_area ) with
      (true, _, _, true, _) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                            (Scroll.sb_pos - (max 1 Scroll.sb_delta/10));
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | (true, _, _, _, true) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                            (Scroll.sb_pos + (max 1 Scroll.sb_delta/10));
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | (true, true, true, _, _ )  ->
        gr_hscrollbar_loop Scroll elevator_width;
        true
    | (true, false, true, _, _ ) ->
        if Event.mouse_x > left + Scroll.sb_pos + elevator_width
        then Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                (Scroll.sb_pos + Scroll.sb_delta)
        else Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                (Scroll.sb_pos - Scroll.sb_delta);
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | ( _ , _ , _, _, _ )       -> false
;;




let open_hscrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord = { x = Event.mouse_x; y = Event.mouse_y }
  and elevator_area = { x1 = left + Scroll.sb_pos + elevator_width + 1;
                        y1 = top - elevator_width - 1;
                        x2 = left + Scroll.sb_pos + elevator_width +
                             elevator_height + 1;
                        y2 = top - 1
                      }
  and scroll_area = { x1 = left;
                      y1 = top - elevator_width - 1;
                      x2 = left + length;
                      y2 = top
                    }
  and home_area = { x1 = left + 1;
                    y1 = top - elevator_width - 1;
                    x2 = left + elevator_width;
                    y2 = top - 1
                  }
  and end_area = { x1 = left + length - 1;
                     y1 = top - elevator_width - 1;
                     x2 = left + length - elevator_width;
                     y2 = top - 1
                   }
  and left_area = { x1 = left + Scroll.sb_pos + 6;
                    y1 = top - elevator_width - 1;
                    x2 = left + Scroll.sb_pos + 6 +
                         3*open_elevator_height/8;
                    y2 = top - 1
                  }
  and right_area = { x1 = left + Scroll.sb_pos + 6+
                         5*open_elevator_height/8;
                     y1 = top - elevator_width - 1;
                     x2 = left + Scroll.sb_pos + 6 +
                          open_elevator_height;
                     y2 = top - 1
                   } in
    match (Event.button,
           inside mouse_coord elevator_area,
           inside mouse_coord scroll_area,
           inside mouse_coord left_area,
           inside mouse_coord right_area,
           inside mouse_coord home_area,
           inside mouse_coord end_area ) with
      (true, _, _, _, _, true, _ ) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll 0;
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | (true, _, _, _, _, _, true) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll length;
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | (true, _, _, true, _, _, _ ) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                            (Scroll.sb_pos - (max 1 Scroll.sb_delta/10));
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | (true, _, _, _, true, _, _ ) ->
        Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                            (Scroll.sb_pos + (max 1 Scroll.sb_delta/10));
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | (true, true, true, _, _, _, _ )  ->
        gr_hscrollbar_loop Scroll elevator_width;
        true
    | (true, false, true, _, _, _, _ ) ->
        if Event.mouse_x > left + Scroll.sb_pos + elevator_width
        then Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                (Scroll.sb_pos + Scroll.sb_delta)
        else Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                (Scroll.sb_pos - Scroll.sb_delta);
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | ( _ , _ , _, _, _, _, _ )       -> false
;;



let std_hscrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length in

  let mouse_coord = { x = Event.mouse_x; y = Event.mouse_y }
  and elevator_area = { x1 = left + Scroll.sb_pos + 1;
                        y1 = top - elevator_width - 1;
                        x2 = left + Scroll.sb_pos + elevator_height + 1;
                        y2 = top - 1
                      }
  and scroll_area = { x1 = left;
                      y1 = top - elevator_width - 1;
                      x2 = left + length;
                      y2 = top
                    } in
    match (Event.button,
           (inside mouse_coord elevator_area ),
           (inside mouse_coord scroll_area )) with
      (true, true, true)  ->
        gr_hscrollbar_loop Scroll 0;
        true
    | (true, false, true) ->
        if Event.mouse_x > left + Scroll.sb_pos
        then Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                (Scroll.sb_pos + Scroll.sb_delta)
        else Scroll.sb_pos <- gr_scrollbar_pos Scroll 
                                (Scroll.sb_pos - Scroll.sb_delta);
        draw_hscrollbar left top length Scroll.sb_pos;
        event_call := true;
        true
    | ( _ , _ , _ )       -> false
;;



let gr_hscrollbar_callback Scroll Event =
  match (get_gr_look()) with
      Open_look_color -> open_hscrollbar_callback Scroll Event
    | Open_look_mono  -> open_hscrollbar_callback Scroll Event
    | Window_color    -> motif_hscrollbar_callback Scroll Event
    | Motif_color     -> motif_hscrollbar_callback Scroll Event
    | Next_color      -> next_hscrollbar_callback Scroll Event
    | _               -> std_hscrollbar_callback Scroll Event
;;



(***************************************************************************)
(*                                                                         *)
(*                                                                         *)
(***************************************************************************)
let gr_scrollbar_callback Scroll Event =
  let top  = Scroll.sb_top
  and left = Scroll.sb_left
  and length = Scroll.sb_length
  and return = ref true in
    event_call := false;
    Scroll.sb_left   <- to_real_coord Scroll.sb_left;
    Scroll.sb_top    <- to_real_coord Scroll.sb_top;
    Scroll.sb_length <- to_real_coord Scroll.sb_length;

    (
      match Scroll.sb_dir with
        Horizontal -> return := gr_hscrollbar_callback Scroll Event
      | Vertical   -> return := gr_vscrollbar_callback Scroll Event
    );
    Scroll.sb_left   <- left;
    Scroll.sb_top    <- top;
    Scroll.sb_length <- length;
    if !event_call then return := Scroll.sb_callback Scroll Event;
    !return
;;



