#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_extext";;

let LoadWindow= ref std_win;;

type melted_sav = string_sav of string
                     | int_sav of int
                     | float_sav of float
                     | bitmap_sav of color vect vect
                     | bool_sav of bool
;;


type sav_button =
  { sbt_window : gr_window
  ; sbt_top : int
  ; sbt_left : int
  ; sbt_width : int
  ; sbt_height : int
  ; sbt_name : melted_sav
  ; sbt_state : button_state
  }
;;
type sav_bitmap =
  { sbm_window : gr_window
  ; sbm_left : int
  ; sbm_top : int
  ; sbm_bitmap : color vect vect
  }
;;
type sav_item =
  { sit_window : gr_window
  ; sit_state : item_state
  ; sit_name : string
  }
;;
type sav_menu =
  { smn_window : gr_window
  ; smn_left : int
  ; smn_top : int
  ; smn_state : menu_state
  ; smn_nu_item : int
  ; smn_name : string
  ; smn_items : sav_item vect
  }
;;
type sav_toolbar =
  { stb_window : gr_window
  ; stb_items : sav_menu vect
  }
;;

type sav_scrollbar =
  { ssb_window : gr_window
  ; ssb_left : int
  ; ssb_top : int
  ; ssb_length : int
  ; ssb_pos : int
  ; ssb_delta : int
  ; ssb_dir : direction
  }
;;
type sav_string =
  { sst_window : gr_window
  ; sst_top : int
  ; sst_left : int
  ; sst_width : int
  ; sst_type : string_type
  ; sst_name : string
  ; sst_cursor : int
  ; sst_1st_char : int
  ; sst_state : string_state
  }
;;
type sav_list =
  { sli_window : gr_window
  ; sli_left : int
  ; sli_top : int
  ; sli_width : int
  ; sli_height : int
  ; sli_nu_item : int
  ; sli_1st_item : int
  ; sli_items : string vect
  ; sli_scroll : int
  }
;;
type sav_grpbut =
  { sgb_window : gr_window
  ; sgb_top : int
  ; sgb_left : int
  ; sgb_width : int
  ; sgb_height : int
  ; sgb_delta : int
  ; sgb_btwidth : int
  ; sgb_btheight : int
  ; sgb_dir : direction
  ; sgb_button : int
  ; sgb_name : melted_sav vect
  }
;;
type sav_grprad =
  { sga_window : gr_window
  ; sga_top : int
  ; sga_left : int
  ; sga_width : int
  ; sga_height : int
  ; sga_delta : int
  ; sga_radio : int
  ; sga_name : string vect
  };;
type sav_radio =
  { sra_window : gr_window
  ; sra_left : int
  ; sra_top : int
  ; sra_state : bool
  ; sra_name : string
  }
;;
type sav_extext  =
  { sextx_window : gr_window
  ; mutable sextx_name : string
  ; mutable sextx_left : int
  ; mutable sextx_top : int
  ; mutable sextx_width : int
  ; mutable sextx_height : int
  ; mutable sextx_scroll : int
  ; mutable sextx_anchors : (AnchorType * int) list
  ; mutable sextx_content : Formated_line vect
  }
;;
type sav_user  =
  { sus_window : gr_window
  ; sus_param : melted_sav vect
  }
;;
type sav_obj =
    s_button of sav_button
  | s_item of sav_item
  | s_menu of sav_menu
  | s_string of sav_string
  | s_text of gr_text
  | s_shell of gr_shell
  | s_toolbar of sav_toolbar
  | s_bitmap of sav_bitmap
  | s_scrollbar of sav_scrollbar
  | s_prompt of gr_prompt
  | s_rectangle of gr_rectangle
  | s_line of gr_line
  | s_ellipse of gr_ellipse
  | s_list of sav_list
  | s_radio of sav_radio
  | s_helpbar of gr_helpbar
  | s_grpbut of sav_grpbut
  | s_grprad of sav_grprad
  | s_extext of sav_extext
  | s_exprompt of gr_exprompt
  | s_area of gr_area
  | s_user of sav_user
;;

type swindow =
  { mutable swin_def : gr_window
  ; mutable swin_objects : sav_obj list
  ; mutable shelp_file : string
  ; mutable smiscellaneous : melted_sav vect
  }
;;

(***************************************************************************)
(*                                                                         *)
(* Convert melted_type to melted_sav.                                      *)
(*                                                                         *)
(***************************************************************************)
let melted_to_sav val =
  match val with
    string_type str -> string_sav str
  | int_type x      -> int_sav x
  | float_type x    -> float_sav x
  | bitmap_type bmp -> bitmap_sav (dump_image bmp)
  | bool_type   b   -> bool_sav b
;;

let sav_to_melted val =
  match val with
    string_sav str -> string_type str
  | int_sav x      -> int_type x
  | float_sav x    -> float_type x
  | bitmap_sav bmp -> bitmap_type (make_image bmp)
  | bool_sav b     -> bool_type b
;;


let rec melted_vect_to_sav Vect =
  let len=vect_length Vect in
    let ret=make_vect len (int_sav 0) in
      for i=0 to (len-1) do
        ret.(i)<- melted_to_sav Vect.(i)
      done;
    ret
;;



let rec sav_to_melted_vect Vect =
  let len=vect_length Vect in
    let ret=make_vect len (int_type 0) in
      for i=0 to (len-1) do
        ret.(i)<- sav_to_melted Vect.(i)
      done;
    ret
;;



(***************************************************************************)
(*                                                                         *)
(* Convert sav_obj to graph_obj.                                           *)
(*                                                                         *)
(***************************************************************************)
let button_gr_to_sav Button =
  {
   sbt_window = Button.bt_window;
   sbt_top = Button.bt_top;
   sbt_left = Button.bt_left;
   sbt_width = Button.bt_width;
   sbt_height = Button.bt_height;
   sbt_name = melted_to_sav Button.bt_name;
   sbt_state = Button.bt_state
  } ;;

let button_sav_to_gr SButton =
  {
   bt_window = !LoadWindow;
   bt_top = SButton.sbt_top;
   bt_left = SButton.sbt_left;
   bt_width = SButton.sbt_width;
   bt_height = SButton.sbt_height;
   bt_name = sav_to_melted SButton.sbt_name;
   bt_state = SButton.sbt_state;
   bt_callback = do_nothing
  } ;;


let bitmap_gr_to_sav Bitmap =
  {
   sbm_window = Bitmap.bm_window;
   sbm_left = Bitmap.bm_left;
   sbm_top = Bitmap.bm_top;
   sbm_bitmap = dump_image Bitmap.bm_bitmap
  };;

let bitmap_sav_to_gr SBitmap =
  {
   bm_window = !LoadWindow;
   bm_left = SBitmap.sbm_left;
   bm_top = SBitmap.sbm_top;
   bm_bitmap = make_image SBitmap.sbm_bitmap;
   bm_callback = do_nothing
  };;


let item_gr_to_sav Item =
  {
   sit_window = Item.it_window;
   sit_state = Item.it_state;
   sit_name = Item.it_name
  };;

let item_sav_to_gr SItem =
  {
   it_window = !LoadWindow;
   it_state = SItem.sit_state;
   it_name = SItem.sit_name;
   it_callback = do_nothing
  };;




let item_vect_gr_to_sav ItemVect =
  let rec item_vect_gr_to_sav_loop ItemVect Pos Result =
    if(vect_length ItemVect) = Pos
    then Result
    else item_vect_gr_to_sav_loop ItemVect
                                  (Pos+1)
                                  (concat_vect Result
                                                [| item_gr_to_sav ItemVect.(Pos) |]
                                  )
  in
    item_vect_gr_to_sav_loop ItemVect  0 [| |]
;;



let item_vect_sav_to_gr SItemVect =
  let rec item_vect_sav_to_gr_loop SItemVect Pos Result =
    if(vect_length SItemVect) = Pos
    then Result
    else item_vect_sav_to_gr_loop SItemVect
                                  (Pos+1)
                                  (concat_vect Result
                                               [| item_sav_to_gr SItemVect.(Pos) |]
                                  )
  in
    item_vect_sav_to_gr_loop SItemVect  0 [| |]
;;


let menu_gr_to_sav Menu =
  {
   smn_window = Menu.mn_window;
   smn_left = Menu.mn_left;
   smn_top = Menu.mn_top;
   smn_state = Menu.mn_state;
   smn_nu_item = Menu.mn_nu_item;
   smn_name = Menu.mn_name;
   smn_items = (item_vect_gr_to_sav Menu.mn_items)
  };;

let menu_sav_to_gr SMenu =
  {
   mn_window = !LoadWindow;
   mn_left = SMenu.smn_left;
   mn_top = SMenu.smn_top;
   mn_state = SMenu.smn_state;
   mn_nu_item = SMenu.smn_nu_item;
   mn_name = SMenu.smn_name;
   mn_items = (item_vect_sav_to_gr SMenu.smn_items);
   mn_hide_area = empty_image
  };;





let menu_vect_gr_to_sav MenuVect =
  let rec menu_vect_gr_to_sav_loop MenuVect Pos Result =
    if(vect_length MenuVect)=Pos
    then Result
    else menu_vect_gr_to_sav_loop MenuVect
                                  (Pos+1)
                                  (concat_vect Result
                                               [| menu_gr_to_sav MenuVect.(Pos) |]
                                  )
  in
    menu_vect_gr_to_sav_loop MenuVect  0 [| |]
;;


let menu_vect_sav_to_gr SMenuVect =
  let rec menu_vect_sav_to_gr_loop SMenuVect Pos Result =
    if(vect_length SMenuVect) = Pos
    then Result
    else menu_vect_sav_to_gr_loop SMenuVect
                                  (Pos+1)
                                  (concat_vect Result
                                               [| menu_sav_to_gr SMenuVect.(Pos) |]
                                  )
  in
    menu_vect_sav_to_gr_loop SMenuVect  0 [| |]
;;


let toolbar_gr_to_sav Toolb =
  {
   stb_window = Toolb.tb_window;
   stb_items = (menu_vect_gr_to_sav Toolb.tb_items)
  };;

let toolbar_sav_to_gr SToolb =
  {
   tb_window = !LoadWindow;
   tb_items = (menu_vect_sav_to_gr SToolb.stb_items)
  };;



let scrollbar_gr_to_sav Scroll =
  {
   ssb_window = Scroll.sb_window;
   ssb_left = Scroll.sb_left;
   ssb_top = Scroll.sb_top;
   ssb_length = Scroll.sb_length;
   ssb_pos = Scroll.sb_pos;
   ssb_delta = Scroll.sb_delta;
   ssb_dir = Scroll.sb_dir
  };;

let scrollbar_sav_to_gr SScroll =
  {
   sb_window = !LoadWindow;
   sb_left = SScroll.ssb_left;
   sb_top = SScroll.ssb_top;
   sb_length = SScroll.ssb_length;
   sb_pos = SScroll.ssb_pos;
   sb_delta = SScroll.ssb_delta;
   sb_dir = SScroll.ssb_dir;
   sb_callback = do_nothing
  };;


let string_gr_to_sav String =
  {
   sst_window = String.st_window;
   sst_top = String.st_top;
   sst_left = String.st_left;
   sst_width = String.st_width;
   sst_type = String.st_type;
   sst_name = String.st_name;
   sst_cursor = String.st_cursor;
   sst_1st_char = String.st_1st_char;
   sst_state = String.st_state
  };;

let string_sav_to_gr SString =
  {
   st_window = !LoadWindow;
   st_top = SString.sst_top;
   st_left = SString.sst_left;
   st_width = SString.sst_width;
   st_type = SString.sst_type;
   st_name = SString.sst_name;
   st_cursor = SString.sst_cursor;
   st_1st_char = SString.sst_1st_char;
   st_state = SString.sst_state;
   st_callback = do_nothing
  };;


let list_gr_to_sav List =
  {
   sli_window = List.li_window;
   sli_left = List.li_left;
   sli_top = List.li_top;
   sli_width = List.li_width;
   sli_height = List.li_height;
   sli_nu_item = List.li_nu_item;
   sli_1st_item = List.li_1st_item;
   sli_items = List.li_items;
   sli_scroll = List.li_scroll
  };;

let list_sav_to_gr SList =
  {
   li_window = !LoadWindow;
   li_left = SList.sli_left;
   li_top = SList.sli_top;
   li_width = SList.sli_width;
   li_height = SList.sli_height;
   li_nu_item = SList.sli_nu_item;
   li_1st_item = SList.sli_1st_item;
   li_items = SList.sli_items;
   li_scroll = SList.sli_scroll;
   li_callback = do_nothing
  };;


let grpbut_gr_to_sav Grpbut =
  {
   sgb_window = Grpbut.gb_window;
   sgb_top = Grpbut.gb_top;
   sgb_left = Grpbut.gb_left;
   sgb_width = Grpbut.gb_width;
   sgb_height = Grpbut.gb_height;
   sgb_delta = Grpbut.gb_delta;
   sgb_btwidth = Grpbut.gb_btwidth;
   sgb_btheight = Grpbut.gb_btheight;
   sgb_dir = Grpbut.gb_dir;
   sgb_button = Grpbut.gb_button;
   sgb_name = melted_vect_to_sav Grpbut.gb_name
  };;

let grpbut_sav_to_gr SGrpbut =
  {
   gb_window = !LoadWindow;
   gb_top = SGrpbut.sgb_top;
   gb_left = SGrpbut.sgb_left;
   gb_width = SGrpbut.sgb_width;
   gb_height = SGrpbut.sgb_height;
   gb_delta = SGrpbut.sgb_delta;
   gb_btwidth = SGrpbut.sgb_btwidth;
   gb_btheight = SGrpbut.sgb_btheight;
   gb_dir = SGrpbut.sgb_dir;
   gb_button = SGrpbut.sgb_button;
   gb_name = sav_to_melted_vect SGrpbut.sgb_name;
   gb_callback = do_nothing
  };;


let grprad_gr_to_sav Grprad =
  {
   sga_window = Grprad.ga_window;
   sga_top = Grprad.ga_top;
   sga_left = Grprad.ga_left;
   sga_width = Grprad.ga_width;
   sga_height = Grprad.ga_height;
   sga_delta = Grprad.ga_delta;
   sga_radio = Grprad.ga_radio;
   sga_name = Grprad.ga_name
  };;

let grprad_sav_to_gr Grprad =
  {
   ga_window = !LoadWindow;
   ga_top = Grprad.sga_top;
   ga_left = Grprad.sga_left;
   ga_width = Grprad.sga_width;
   ga_height = Grprad.sga_height;
   ga_delta = Grprad.sga_delta;
   ga_radio = Grprad.sga_radio;
   ga_name = Grprad.sga_name;
   ga_callback = do_nothing
  };;




let radio_gr_to_sav Radio =
  {
   sra_window = Radio.ra_window;
   sra_left = Radio.ra_left;
   sra_top = Radio.ra_top;
   sra_state = Radio.ra_state;
   sra_name = Radio.ra_name
  };;

let radio_sav_to_gr SRadio =
  {
   ra_window = !LoadWindow;
   ra_left = SRadio.sra_left;
   ra_top = SRadio.sra_top;
   ra_state = SRadio.sra_state;
   ra_name = SRadio.sra_name;
   ra_callback = do_nothing
  };;


let text_sav_to_gr Text =
  {
    tx_window = !LoadWindow;
    tx_top = Text.tx_top;
    tx_left = Text.tx_left;
    tx_width = Text.tx_width;
    tx_height = Text.tx_height;
    tx_name = Text.tx_name;
    tx_cursor = Text.tx_cursor;
    tx_line = Text.tx_line;
    tx_1st_line = Text.tx_1st_line;
    tx_1st_row = Text.tx_1st_row;
    tx_state = Text.tx_state;
    tx_modified = Text.tx_modified;
    tx_scroll = Text.tx_scroll;
    tx_vscroll = Text.tx_vscroll;
    tx_hscroll = Text.tx_hscroll;
    tx_s_select = Text.tx_s_select;
    tx_e_select = Text.tx_e_select
  }
;;


let shell_sav_to_gr Shell =
  {
    sh_window = !LoadWindow;
    sh_top = Shell.sh_top;
    sh_left = Shell.sh_left;
    sh_width = Shell.sh_width;
    sh_height = Shell.sh_height;
    sh_name = Shell.sh_name;
    sh_cursor = Shell.sh_cursor;
    sh_line = Shell.sh_line;
    sh_1st_line = Shell.sh_1st_line;
    sh_1st_row = Shell.sh_1st_row;
    sh_state = Shell.sh_state;
    sh_vscroll = Shell.sh_vscroll;
    sh_hscroll = Shell.sh_hscroll;
    sh_s_select = Shell.sh_s_select;
    sh_e_select = Shell.sh_e_select
  }
;;

let prompt_sav_to_gr Prompt =
  {
    pt_window = !LoadWindow;
    pt_left = Prompt.pt_left;
    pt_top = Prompt.pt_top;
    pt_name = Prompt.pt_name
  }
;;

let extext_sav_to_gr exText  =
  { 
    extx_window = !LoadWindow;
    extx_name = exText.sextx_name;
    extx_left = exText.sextx_left;
    extx_top = exText.sextx_top;
    extx_width = exText.sextx_width;
    extx_height = exText.sextx_height;
    extx_scroll = exText.sextx_scroll;
    extx_anchors = exText.sextx_anchors;
    extx_content = exText.sextx_content;
    extx_callback = extext_empty_callback
  }
;;


let extext_gr_to_sav exText  =
  { 
    sextx_window = exText.extx_window;
    sextx_name = exText.extx_name;
    sextx_left = exText.extx_left;
    sextx_top = exText.extx_top;
    sextx_width = exText.extx_width;
    sextx_height = exText.extx_height;
    sextx_scroll = exText.extx_scroll;
    sextx_anchors = exText.extx_anchors;
    sextx_content = exText.extx_content
  }
;;


let exprompt_sav_to_gr exPrompt =
  {
    expt_window = !LoadWindow;
    expt_left = exPrompt.expt_left;
    expt_top = exPrompt.expt_top;
    expt_name = exPrompt.expt_name
  }
;;


let area_sav_to_gr Area =
  {
    ar_window = !LoadWindow;
    ar_name = Area.ar_name;
    ar_left = Area.ar_left;
    ar_top = Area.ar_top;
    ar_width = Area.ar_width;
    ar_height = Area.ar_height
  }
;;


let help_sav_to_gr Help =
  {
    hl_window = !LoadWindow;
    hl_help = Help.hl_help
  }
;;


let line_sav_to_gr Line =
  {
    ln_window = !LoadWindow;
    ln_color = Line.ln_color;
    ln_point1 = Line.ln_point1;
    ln_point2 = Line.ln_point2
  }
;;


let ellipse_sav_to_gr Ellipse =
  { el_window = !LoadWindow;
    el_filled = Ellipse.el_filled;
    el_color = Ellipse.el_color;
    el_center = Ellipse.el_center;
    el_xray = Ellipse.el_xray;
    el_yray = Ellipse.el_yray
  }
;;


let rectangle_sav_to_gr Rectangle =
  { re_window = !LoadWindow;
    re_filled = Rectangle.re_filled;
    re_color = Rectangle.re_color;
    re_point = Rectangle.re_point;
    re_width = Rectangle.re_width;
    re_height = Rectangle.re_height
  }
;;




(***************************************************************************)
(*                                                                         *)
(* sav_window_to_window : swindow -> window;;                              *)
(*                                                                         *)
(***************************************************************************)

let rec window_sav_to_gr_loop SObj_list Obj_list=
  match SObj_list with
    [] -> Obj_list
  | x::y -> match x with
              s_button SButton ->
                let button=(button_sav_to_gr SButton) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_button button])

            | s_item SItem ->
                let item=(item_sav_to_gr SItem) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_item item])

            | s_menu SMenu ->
                let menu=(menu_sav_to_gr SMenu) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_menu menu])

            | s_string SString ->
                let string=(string_sav_to_gr SString) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_string string])

            | s_text SText ->
                let text=text_sav_to_gr SText in
                  window_sav_to_gr_loop y (Obj_list @ [ g_text text])

            | s_shell SShell ->
                let shell = shell_sav_to_gr SShell in
                  window_sav_to_gr_loop y (Obj_list @ [ g_shell shell])

            | s_toolbar SToolb ->
                let toolb=(toolbar_sav_to_gr SToolb) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_toolbar toolb])

            | s_bitmap SBitmap ->
                let bitmap=(bitmap_sav_to_gr SBitmap) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_bitmap bitmap])

            | s_scrollbar SScroll ->
                let scrollbar=(scrollbar_sav_to_gr SScroll) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_scrollbar scrollbar])

            | s_prompt SPrompt ->
                let prompt = prompt_sav_to_gr SPrompt in
                  window_sav_to_gr_loop y (Obj_list @ [ g_prompt prompt])

            | s_line SLine ->
                let line=line_sav_to_gr SLine in
                  window_sav_to_gr_loop y (Obj_list @ [ g_line line])

            | s_rectangle SRectangle ->
                let rect=rectangle_sav_to_gr SRectangle in
                  window_sav_to_gr_loop y (Obj_list @ [ g_rectangle rect])

            | s_ellipse SEllipse ->
                let ellipse=ellipse_sav_to_gr SEllipse in
                  window_sav_to_gr_loop y (Obj_list @ [ g_ellipse ellipse])

            | s_list SList ->
                let list=(list_sav_to_gr SList) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_list list])

            | s_radio SRadio ->
                let radio=(radio_sav_to_gr SRadio) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_radio radio])

            | s_helpbar SHelpb ->
                let help=help_sav_to_gr SHelpb in
                  window_sav_to_gr_loop y (Obj_list @ [ g_helpbar help])

            | s_grpbut SGrpbut ->
                let grpbut=(grpbut_sav_to_gr SGrpbut) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_grpbut grpbut])

            | s_grprad SGrprad ->
                let grprad=(grprad_sav_to_gr SGrprad) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_grprad grprad])

            | s_extext SExText ->
                let extext=(extext_sav_to_gr SExText) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_extext extext])

            | s_exprompt SExPrompt ->
                let exprompt=(exprompt_sav_to_gr SExPrompt) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_exprompt exprompt])

            | s_area SArea ->
                let area=(area_sav_to_gr SArea) in
                  window_sav_to_gr_loop y (Obj_list @ [ g_area area])

            | s_user SUser -> window_sav_to_gr_loop y Obj_list
;;

let window_sav_to_gr SWindow WindowDef=
  LoadWindow := WindowDef;
  !LoadWindow.win_top <- SWindow.swin_def.win_top;
  !LoadWindow.win_left <- SWindow.swin_def.win_left;
  !LoadWindow.win_width <- SWindow.swin_def.win_width;
  !LoadWindow.win_height <- SWindow.swin_def.win_height;
  {
    win_def = !LoadWindow;
    win_objects = window_sav_to_gr_loop SWindow.swin_objects [];
    time_callback = do_nothing;
    resize_callback = do_nothing;
    help_file = SWindow.shelp_file;
    miscellaneous = sav_to_melted_vect SWindow.smiscellaneous
  };;


let input_window Channel WindowDef =
  window_sav_to_gr (input_value Channel : swindow) WindowDef;;




(***************************************************************************)
(*                                                                         *)
(* window_to_sav_window : window -> swindow;;                              *)
(*                                                                         *)
(***************************************************************************)
let rec window_gr_to_sav_loop Obj_list SObj_list=
  match Obj_list with
    [] -> SObj_list
  | x::y -> match x with
              g_button Button ->
                let button=(button_gr_to_sav Button) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_button button])

            | g_item Item ->
                let item=(item_gr_to_sav Item) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_item item])

            | g_menu Menu ->
                let menu=(menu_gr_to_sav Menu) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_menu menu])

            | g_string String ->
                let string=(string_gr_to_sav String) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_string string])

            | g_text Text ->
                window_gr_to_sav_loop y (SObj_list @ [ s_text Text])

            | g_shell Shell ->
                window_gr_to_sav_loop y (SObj_list @ [ s_shell Shell])

            | g_toolbar Toolb ->
                let toolb=(toolbar_gr_to_sav Toolb) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_toolbar toolb])

            | g_bitmap Bitmap ->
                let bitmap=(bitmap_gr_to_sav Bitmap) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_bitmap bitmap])

            | g_scrollbar Scroll ->
                let scrollbar=(scrollbar_gr_to_sav Scroll) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_scrollbar scrollbar])

            | g_prompt Prompt ->
                window_gr_to_sav_loop y (SObj_list @ [ s_prompt Prompt])

            | g_line Line ->
                window_gr_to_sav_loop y (SObj_list @ [ s_line Line])

            | g_rectangle Rectangle ->
                window_gr_to_sav_loop y (SObj_list @ [ s_rectangle Rectangle])

            | g_ellipse Ellipse ->
                window_gr_to_sav_loop y (SObj_list @ [ s_ellipse Ellipse])

            | g_list List ->
                let list=(list_gr_to_sav List) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_list list])
           
            | g_extext Extext ->
             let extext=(extext_gr_to_sav Extext) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_extext extext])

            | g_exprompt Exprompt ->
                  window_gr_to_sav_loop y (SObj_list @ [ s_exprompt Exprompt])

            | g_area Area ->
                  window_gr_to_sav_loop y (SObj_list @ [ s_area Area])

            | g_helpbar Help ->
                  window_gr_to_sav_loop y (SObj_list @ [ s_helpbar Help])

            | g_radio Radio    -> 
                let radio=(radio_gr_to_sav Radio) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_radio radio])

            | g_grpbut Grpbut  -> 
                let grpbut=(grpbut_gr_to_sav Grpbut) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_grpbut grpbut])

            | g_grprad Grprad  -> 
                let grprad=(grprad_gr_to_sav Grprad) in
                  window_gr_to_sav_loop y (SObj_list @ [ s_grprad grprad])

            | g_user usr  -> window_gr_to_sav_loop y SObj_list
;;


let window_gr_to_sav Window =
  {
    swin_def = Window.win_def;
    swin_objects = window_gr_to_sav_loop Window.win_objects [];
    shelp_file = Window.help_file;
    smiscellaneous = melted_vect_to_sav Window.miscellaneous
  }
;;
 


let output_window Channel Window=
  output_value Channel (window_gr_to_sav Window);;

