(* This file is created with Camldraw *)

#open "windows";;
#open "camlwin";;



let replace_win_def = 
{
  win_left     = 20;
  win_top      = 220;
  win_width    = 300;
  win_height   = 200;
  win_id       = 0;
  win_state    = Destroyed
};;

let replace_type = 
{
  ga_window   = replace_win_def;
  ga_left     = 10;
  ga_top      = 120;
  ga_width    = 130;
  ga_height   = 55;
  ga_delta    = 10;
  ga_radio    = 0;
  ga_name     = [|
                 "From Cursor";
                 "Full Text"
                |];
  ga_callback = gr_do_nothing
};;

let replace_zone = 
{
  ga_window   = replace_win_def;
  ga_left     = 150;
  ga_top      = 120;
  ga_width    = 140;
  ga_height   = 55;
  ga_delta    = 10;
  ga_radio    = 0;
  ga_name     = [|
                 "Selected Area";
                 "Entire Scope"
                |];
  ga_callback = gr_do_nothing
};;

let replace_title = 
{
  pt_window   = replace_win_def;
  pt_left     = 113;
  pt_top      = 194;
  pt_name     = "Replace"
};;

let replace_prompt1 = 
{
  pt_window   = replace_win_def;
  pt_left     = 10;
  pt_top      = 170;
  pt_name     = "Text to Find:"
};;

let replace_tofind = 
{
  st_window   = replace_win_def;
  st_left     = 125;
  st_top      = 174;
  st_width    = 150;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let replace_with = 
{
  st_window   = replace_win_def;
  st_left     = 125;
  st_top      = 149;
  st_width    = 150;
  st_1st_char = 0;
  st_cursor   = 0;
  st_name     = "";
  st_state    = Editable;
  st_type     = Gr_string;
  st_callback = gr_do_nothing
};;

let replace_help = 
{
  hl_window   = replace_win_def;
  hl_help     = "Type both text, then press Ok"
};;

let replace_cancel = 
{
  bt_window   = replace_win_def;
  bt_left     = 174;
  bt_top      = 50;
  bt_width    = 50;
  bt_height   = 20;
  bt_state    = Up;
  bt_name     = "Cancel";
  bt_callback = gr_do_nothing
};;

let replace_ok = 
{
  bt_window   = replace_win_def;
  bt_left     = 85;
  bt_top      = 50;
  bt_width    = 50;
  bt_height   = 20;
  bt_state    = Up;
  bt_name     = "Ok";
  bt_callback = gr_do_nothing
};;

let replace_tprompt2 = 
{
  pt_window   = replace_win_def;
  pt_left     = 10;
  pt_top      = 145;
  pt_name     = "Replaced with:"
};;

let replace_win = 
{
  win_def      = replace_win_def;
  win_objects  = [
                  g_grprad    replace_type;
                  g_grprad    replace_zone;
                  g_prompt    replace_title;
                  g_prompt    replace_prompt1;
                  g_string    replace_tofind;
                  g_string    replace_with;
                  g_helpbar   replace_help;
                  g_button    replace_cancel;
                  g_button    replace_ok;
                  g_prompt    replace_tprompt2
                 ]
};;


