#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_bitmap";;



let open_mark col = make_image
[|
  [| -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1; col |];
  [| -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1; col; col;  -1 |];
  [| -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1; col; col;  -1;  -1 |];
  [| -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1; col; col;  -1;  -1;  -1 |];
  [| -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1; col; col;  -1;  -1;  -1;  -1 |];
  [| -1;  -1; col; col;  -1;  -1;  -1; col; col; col;  -1;  -1;  -1;  -1 |];
  [| -1; col; col; col; col;  -1; col; col; col;  -1;  -1;  -1;  -1;  -1 |];
  [|col; col; col; col; col; col; col; col; col;  -1;  -1;  -1;  -1;  -1 |];
  [| -1; col; col; col; col; col; col; col;  -1;  -1;  -1;  -1;  -1;  -1 |];
  [| -1;  -1; col; col; col; col; col; col;  -1;  -1;  -1;  -1;  -1;  -1 |];
  [| -1;  -1;  -1; col; col; col; col;  -1;  -1;  -1;  -1;  -1;  -1;  -1 |];
  [| -1;  -1;  -1;  -1; col; col; col;  -1;  -1;  -1;  -1;  -1;  -1;  -1 |];
  [| -1;  -1;  -1;  -1;  -1; col;  -1;  -1;  -1;  -1;  -1;  -1;  -1;  -1 |]
|];;


let next_mark = make_image
[|
  [| transp; transp; transp; transp; transp; transp; transp; transp; white  |];
  [| transp; transp; transp; transp; transp; transp; transp; white;  black  |];
  [| transp; transp; transp; transp; transp; transp; white;  black;  nextgrey |];
  [| white;  black;  transp; transp; transp; white;  black;  nextgrey; transp |];
  [| white;  black;  transp; transp; white;  black;  nextgrey; transp; transp |];
  [| white;  black;  nextgrey; white; black; nextgrey; transp; transp; transp |];
  [| white;  nextgrey; white; black; nextgrey; transp; transp; transp; transp |];
  [| white;  white;  black;  nextgrey; transp; transp; transp; transp; transp |];
  [| white;  black;  nextgrey; transp; transp; transp; transp; transp; transp |];
  [| black;  nextgrey; transp; transp; transp; transp; transp; transp; transp |]
|];;




let std_draw_radio left top btwidth label state =
  let height=(line_height + 2*short_space) in
    let ray=(height/2) in
      set_color black;
      draw_arc (left+ray)
               (top-ray)
               ray
               ray
               225
               405;
      set_color white;
      draw_arc (left+ray)
               (top-ray)
               ray
               ray
               45
               225;
      set_color black;
      if state = true
      then set_color red
      else set_color black;
      fill_arc (left+ray)
               (top-ray)
               (ray - short_space)
               (ray - short_space)
               0
               360;
      let btstate=(if state then Down else Up) in
        draw_button (left + height + short_space) top
                    btwidth height btstate;
        set_color black;
        moveto (left + height + 2*short_space) (top - height + short_space);
        draw_string label
;;

let open_col_draw_radio left top btwidth label state =
  let height=(line_height + 2*short_space) in
    let ray=(height/2) in
      if not state
      then
      (
        draw_image (open_mark (backcolor ())) left (top-(13+line_height)/2);
        std_col_draw_button left top line_height line_height Up
      )
      else
      (
        std_col_draw_button left top line_height line_height Up;
        draw_image (open_mark black) left (top-(13+line_height)/2)
      );

      moveto (left+height+short_space) (top-short_space-line_height);
      draw_string label
;;


let open_mono_draw_radio left top btwidth label state =
  let height=(line_height + 2*short_space) in
    let ray=(height/2) in
      if not state
      then
      (
        draw_image (open_mark (backcolor ())) left (top-(13+line_height)/2);
        set_color black;
        draw_rect left (top-line_height) line_height line_height
      )
      else
      (
        set_color black;
        draw_rect left (top-line_height) line_height line_height;
        draw_image (open_mark black) left (top-(13+line_height)/2)
      );

      moveto (left+height+short_space) (top-short_space-line_height);
      draw_string label
;;


let motif_draw_radio left top btwidth label state =
  let dim = ((line_height + 2*short_space)/2)*2 in
    let dim2 = dim /2 in
      if not state
      then
      (
        set_color grey;
        moveto (left+dim) (top-dim2);
        lineto (left+dim2) top;
        lineto left (top-dim2);
        set_color black;
        lineto (left+dim2) (top-dim);
        lineto (left+dim) (top-dim2);
        set_color grey;
        moveto (left+dim-1) (top-dim2);
        lineto (left+dim2) (top-1);
        lineto (left+1) (top-dim2);
        set_color black;
        lineto (left+dim2) (top-dim+1);
        lineto (left+dim-1) (top-dim2);
        set_color (backcolor ());
        fill_poly [| (left+dim-3,top-dim2); (left+dim2,top-3);
                    (left+3,top-dim2); (left+dim2,top-dim+3);
                    (left+dim-3,top-dim2) |]
      )
      else
      (
        set_color black;
        moveto (left+dim) (top-dim2);
        lineto (left+dim2) top;
        lineto left (top-dim2);
        set_color grey;
        lineto (left+dim2) (top-dim);
        lineto (left+dim) (top-dim2);
        set_color black;
        moveto (left+dim-1) (top-dim2);
        lineto (left+dim2) (top-1);
        lineto (left+1) (top-dim2);
        set_color grey;
        lineto (left+dim2) (top-dim+1);
        lineto (left+dim-1) (top-dim2);
        set_color white;
        fill_poly [| (left+dim-3,top-dim2); (left+dim2,top-3);
                    (left+3,top-dim2); (left+dim2,top-dim+3);
                    (left+dim-3,top-dim2) |]
      );

      set_color black;
      moveto (left+dim+short_space) (top-short_space-line_height);
      draw_string label
;;



let next_draw_radio left top btwidth label state =
  let height=(line_height + 2*short_space) in
    let ray=(height/2) in
      if not state
      then
      (
        next_draw_button (left+btwidth+short_space) top line_height line_height Up
      )
      else
      (
        next_draw_button (left+btwidth+short_space) top line_height line_height Up;
        draw_image next_mark (left+btwidth+short_space+(line_height-9)/2) 
                             (top-(10+line_height)/2)
      );

      set_color black;
      moveto left (top-short_space-line_height);
      draw_string label
;;



let windows_draw_radio left top btwidth label state =
  let height=(line_height + 2*short_space) in
    set_color white;
    fill_rect left (top-height) height height;
    set_color black;
    draw_rect left (top-height) height height;
    if state = true
    then
    (
      moveto left top;
      lineto (left+height) (top-height);
      moveto (left+height) top;
      lineto left (top-height);
      set_color red
    );
    set_color black;
    moveto (left + height + 2*short_space) (top - height + short_space);
    draw_string label
;;




let draw_radio left top btwidth label state =
  match (get_gr_look()) with
      Std_color       -> std_draw_radio left top btwidth label state
    | Std_mono        -> std_draw_radio left top btwidth label state
    | Open_look_color -> open_col_draw_radio left top btwidth label state
    | Open_look_mono  -> open_mono_draw_radio left top btwidth label state
    | Window_color    -> windows_draw_radio left top btwidth label state
    | Motif_color     -> motif_draw_radio left top btwidth label state
    | Next_color      -> next_draw_radio left top btwidth label state
    | _               -> std_draw_radio left top btwidth label state
;;



let std_draw_gr_radio Radio =
  let left =to_real_coord Radio.ra_left
  and top  =to_real_coord Radio.ra_top
  and btwidth=((fst (text_size Radio.ra_name)) + 4*short_space) in
    std_draw_radio left top btwidth Radio.ra_name Radio.ra_state
;;


let windows_draw_gr_radio Radio =
  let left =to_real_coord Radio.ra_left
  and top  =to_real_coord Radio.ra_top
  and btwidth=((fst (text_size Radio.ra_name)) + 4*short_space) in
    windows_draw_radio left top btwidth Radio.ra_name Radio.ra_state
;;


let motif_draw_gr_radio Radio =
  let left =to_real_coord Radio.ra_left
  and top  =to_real_coord Radio.ra_top
  and btwidth=((fst (text_size Radio.ra_name)) + 4*short_space) in
    motif_draw_radio left top btwidth Radio.ra_name Radio.ra_state
;;


let next_draw_gr_radio Radio =
  let left =to_real_coord Radio.ra_left
  and top  =to_real_coord Radio.ra_top
  and btwidth=((fst (text_size Radio.ra_name)) + 4*short_space) in
    next_draw_radio left top btwidth Radio.ra_name Radio.ra_state
;;



let open_col_draw_gr_radio Radio =
  let left =to_real_coord Radio.ra_left
  and top  =to_real_coord Radio.ra_top
  and btwidth=((fst (text_size Radio.ra_name)) + 4*short_space) in
    open_col_draw_radio left top btwidth Radio.ra_name Radio.ra_state
;;


let open_mono_draw_gr_radio Radio =
  let left =to_real_coord Radio.ra_left
  and top  =to_real_coord Radio.ra_top
  and btwidth=((fst (text_size Radio.ra_name)) + 4*short_space) in
    open_mono_draw_radio left top btwidth Radio.ra_name Radio.ra_state
;;


let draw_gr_radio Radio =
  if Radio.ra_window.win_state=Created
  then
  (
    set_draw_window Radio.ra_window.win_id;
    match (get_gr_look()) with
        Std_color       -> std_draw_gr_radio Radio
      | Std_mono        -> std_draw_gr_radio Radio
      | Open_look_color -> open_col_draw_gr_radio Radio
      | Open_look_mono  -> open_mono_draw_gr_radio Radio
      | Window_color    -> windows_draw_gr_radio Radio
      | Motif_color     -> motif_draw_gr_radio Radio
      | Next_color      -> next_draw_gr_radio Radio
      | _               -> std_draw_gr_radio Radio
  )
;;




let gr_radio_callback Radio Event =
  let left =to_real_coord Radio.ra_left
  and top  =to_real_coord Radio.ra_top in

  if Event.id_event=Button_down
  then
  (
    let height=(line_height + 2*short_space)
    and width=((fst (text_size Radio.ra_name)) + 4*short_space)
    and state=(if Radio.ra_state then Down else Up) in
      let mouse_coord={x = Event.mouse_x; y = Event.mouse_y}
      and Button_area={x1 = left + height + short_space;
                       y1 = top - height;
                       x2 = left + height + short_space+width;
                       y2 = top} in
        if inside mouse_coord Button_area
        then
        (
          Radio.ra_state <- not Radio.ra_state;
          draw_gr_radio Radio;
          Radio.ra_callback Radio Event
        )
        else false
  )
  else false
;;

