#open "sys";;
#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_config";;
#open "g_button";;
#open "g_string";;
#open "g_item";;
#open "g_menu";;
#open "g_text";;
#open "g_shell";;
#open "g_toolb";;
#open "g_bitmap";;
#open "g_scroll";;
#open "g_prompt";;
#open "g_graph";;
#open "g_list";;
#open "g_radio";;
#open "g_helpb";;
#open "g_grpbut";;
#open "g_grprad";;
#open "g_extext";;
#open "g_exprpt";;
#open "g_area";;
#open "g_helpw";;
#open "g_debug";;


let use_time_flag = ref false;;

let use_time_event dt = set_time_event dt; use_time_flag:= true;;
let no_time_event () =  use_time_flag:= false;;



let MainWindows = ref [ { win_def = std_win; 
                          win_objects = []; 
                          time_callback = do_nothing;
                          resize_callback = do_nothing;
                          help_file = "";
                          miscellaneous = [| |]
                        } 
                      ];;

let apply_to_list f Arg = apply_to_list_f
  where rec apply_to_list_f = function
      []   -> ()
   |  x::y -> f x Arg;  apply_to_list_f y
;;

let debug_apply_to_list f Arg = apply_to_list_f
  where rec apply_to_list_f = function
      []   -> ()
   |  x::y -> output_action x (f x Arg);  apply_to_list_f y
;;


let set_main_windows Windows =
  MainWindows := Windows
;;

let get_main_windows () =
  !MainWindows
;;



let create_window Window =
  if Window.win_state = Destroyed
  then
  (
    let height=to_real_coord Window.win_height
    and width =to_real_coord Window.win_width in
      Window.win_id <- add_window Window.win_left
                                  (Window.win_top-height)
                                  width
                                  height
                                  Window.win_name;
    Window.win_state <- Created
  );
  true
;;


let erase_window Window =
  if Window.win_state = Created
  then
  (
    del_window Window.win_id;
    true
  )
  else false
;;

let quit_callback Obj_graph Status =
  close_graph();
  exit 0;
  true
;;



(***********************************************************************)
(*                                                                     *)
(***********************************************************************)
let rec gr_close_helpw Obj_graph Event =
  erase_window gr_helpw_window.win_def
;;




gr_helpw_OK.bt_callback <- gr_close_helpw;;

let open_help file_name =
  if not file_name = ""
  then 
  (
    let name = help_path ^ gr_directory_separator ^ file_name in
      help_index := name;
      help_list := [name];
      try
        extext_load gr_helpw_help name;
        gr_helpw_help.extx_scroll <- 0;
        create_window gr_helpw_window.win_def;
        ()
      with _ ->  ()
  )
;;



(***********************************************************************)
(*                                                                     *)
(***********************************************************************)
let rec had_toolbar Objects =
  match Objects with
    [] -> false
  | x::y -> match x with
              g_toolbar toolbar -> true
            | _                 -> had_toolbar y
;;

let rec get_toolbar Objects =
  match Objects with
    [] -> {tb_window=std_win; tb_items=[||]}
  | x::y -> match x with
              g_toolbar toolbar -> toolbar
            | _                 -> get_toolbar y
;;



(***********************************************************************)
(*                                                                     *)
(***********************************************************************)
let call_callback Igraph_obj Event =
  match Igraph_obj with
    g_button  Button  -> Button.bt_callback  Button  Event
  | g_string  String  -> String.st_callback  String  Event
  | g_text    Text    -> false
  | g_extext  ExText  -> false
  | g_exprompt  Expt  -> false
  | g_area    Area    -> false
  | g_shell   Shell   -> false
  | g_item    Item    -> Item.it_callback    Item    Event
  | g_menu    Menu    -> false
  | g_toolbar Toolbar -> false
  | g_bitmap  Bitmap  -> Bitmap.bm_callback  Bitmap  Event
  | g_scrollbar Scroll-> Scroll.sb_callback  Scroll  Event
  | g_prompt  Prompt  -> false
  | g_line    Line    -> false
  | g_rectangle Rect  -> false
  | g_ellipse Ellipse -> false
  | g_list    List    -> List.li_callback    List    Event
  | g_radio   Radio   -> Radio.ra_callback   Radio   Event
  | g_helpbar Help    -> false
  | g_grpbut  Grpbut  -> Grpbut.gb_callback  Grpbut  Event
  | g_grprad  Grprad  -> Grprad.ga_callback  Grprad  Event
  | g_user    User    -> User.us_callback    User    Event
;;


let draw_graph_obj Igraph_obj =
  match Igraph_obj with
    g_button Button   -> draw_gr_button  Button
  | g_string String   -> draw_gr_string  String
  | g_text   Text     -> draw_gr_text    Text
  | g_shell   Shell   -> draw_gr_shell   Shell
  | g_menu   Menu     -> ()
  | g_item   Item     -> ()
  | g_toolbar Toolbar -> ()
  | g_extext  ExText  -> draw_gr_extext  ExText
  | g_exprompt ExPt   -> draw_gr_exprompt  ExPt
  | g_area   Area     -> draw_gr_area    Area
  | g_bitmap Bitmap   -> draw_gr_bitmap  Bitmap
  | g_scrollbar Scroll-> draw_gr_scrollbar Scroll
  | g_prompt Prompt   -> draw_gr_prompt  Prompt
  | g_line    Line    -> draw_gr_line    Line
  | g_rectangle Rect  -> draw_gr_rectangle Rect
  | g_ellipse Ellipse -> draw_gr_ellipse Ellipse
  | g_list   List     -> draw_gr_list    List
  | g_radio  Radio    -> draw_gr_radio   Radio
  | g_helpbar Help    -> draw_gr_helpbar Help
  | g_grpbut Grpbut   -> draw_gr_grpbut  Grpbut
  | g_grprad  Grprad  -> draw_gr_grprad  Grprad
  | g_user   User     -> User.us_draw    User
;;

let draw_toolb_obj Igraph_obj =
  match Igraph_obj with
    g_toolbar Toolbar -> draw_gr_toolbar Toolbar
  | _                 -> ()
;;



(***********************************************************************)
(*                                                                     *)
(***********************************************************************)
let draw_window Window =
  if Window.win_def.win_state=Created
  then
  (
    set_draw_window Window.win_def.win_id;
    Window.win_def.win_width <- to_win_coord (window_width Window.win_def.win_id);
    Window.win_def.win_height <- to_win_coord (window_height Window.win_def.win_id);

    set_color (backcolor ());

    fill_rect 0
              0
              (to_real_coord Window.win_def.win_width)
              (to_real_coord Window.win_def.win_height);

    do_list draw_graph_obj Window.win_objects;
    do_list draw_toolb_obj Window.win_objects 
  )
;;


let graph_obj_callback Igraph_obj Event =
  match Igraph_obj with
    g_text   Text     -> gr_text_callback    Text    Event
  | g_item   Item     -> gr_item_callback    Item    Event
  | g_menu   Menu     -> gr_menu_callback    Menu    Event
  | g_list   List     -> gr_list_callback    List    Event
  | g_line   Line     -> false
  | g_user   User     -> User.us_callback    User    Event
  | g_radio  Radio    -> gr_radio_callback   Radio   Event
  | g_helpbar Help    -> false
  | g_shell  Shell    -> gr_shell_callback   Shell   Event
  | g_button Button   -> gr_button_callback  Button  Event
  | g_string String   -> gr_string_callback  String  Event
  | g_bitmap Bitmap   -> gr_bitmap_callback  Bitmap  Event
  | g_grpbut Grpbut   -> gr_grpbut_callback  Grpbut  Event
  | g_grprad Grprad   -> gr_grprad_callback  Grprad  Event
  | g_prompt Prompt   -> false
  | g_exprompt exPt   -> false
  | g_area   Area     -> false
  | g_rectangle Rect  -> false
  | g_ellipse Ellipse -> false
  | g_toolbar Toolbar -> false
  | g_extext  ExText  -> gr_extext_callback ExText Event
  | g_scrollbar Scroll-> gr_scrollbar_callback Scroll Event
;;


let rec which_window Windows window_id =
  match Windows with
    []   -> raise (Failure "which_window: Bad window id")
  | x::y -> if x.win_def.win_id=window_id & x.win_def.win_state=Created
            then x
            else which_window y window_id
;;


let redraw_window id =
  let Window=which_window (get_main_windows ()) id in
    draw_window Window
;;


let rec redraw_all_loop Windows =
  match Windows with
    []   -> ()
  | x::y -> draw_window x;
            redraw_all_loop y
;;

let redraw_all () =
  redraw_all_loop (get_main_windows ())
;;


(***********************************************************************)
(*                                                                     *)
(***********************************************************************)
let get_event_list UsedTime =
  match (UsedTime, !get_move) with
    (false, false) -> get_event([Button_down; Button_up; Key_pressed])
  | (false, true)  -> get_event([Button_down; Button_up; Key_pressed; 
                                 Mouse_motion])
  | (true, false)  -> get_event([Button_down; Button_up; Key_pressed; Time])
  | (true, true)   -> get_event([Button_down; Button_up; Key_pressed;
                                 Mouse_motion; Time])
;;





let debug_deal_event Event Window =
  if had_toolbar Window.win_objects
  then
  (
     if gr_toolbar_callback (get_toolbar Window.win_objects) Event
     then ()
     else debug_apply_to_list graph_obj_callback Event Window.win_objects
  )
  else debug_apply_to_list graph_obj_callback Event Window.win_objects
;;


let debug_main_loop Windows =
  init_debug ();
  let windows = Windows @ [ gr_helpw_window ] in
    set_main_windows windows;
    match Windows with
      []   ->
          close_graph();
          exit 0
    | x::y ->
        create_window x.win_def;

    while true do
      let Event= get_event_list !use_time_flag in
        output_event Event;
        let Window=(which_window windows Event.win) in
        (
          match Event.id_event with
            Redraw -> draw_window Window
          | Close  -> Window.win_def.win_state <- Destroyed
          | Time   -> Window.time_callback Window Event; ()
          | Key_pressed -> if Event.key = F1_key
                           then open_help Window.help_file
                           else debug_deal_event Event Window
          | _      -> debug_deal_event Event Window
        )
    done
;;




let debug_block_loop Window =
  let Windows=get_main_windows () in
  create_window Window.win_def;
  set_main_windows (Windows @ [ Window ]);
  let block_id=(Window.win_def.win_id) in
  while Window.win_def.win_state=Created do
    let Event = get_event_list !use_time_flag in
      output_event Event;
      if Event.win=block_id
      then
      (
          match Event.id_event with
            Redraw -> draw_window Window
          | Close  -> Window.win_def.win_state <- Destroyed
          | Time   -> Window.time_callback Window Event; ()
          | Key_pressed -> if Event.key = F1_key
                           then open_help Window.help_file
                           else debug_deal_event Event Window
          | _      -> debug_deal_event Event Window
      )
      else
      (
        let Win=(which_window Windows Event.win) in
          match Event.id_event with
            Redraw -> draw_window Win
          | Close  -> Win.win_def.win_state <- Destroyed
          | Time   -> Win.time_callback Window Event; ()
          | _      -> ()
      )
  done;
  set_main_windows Windows
;;





let deal_event Event Window =
  if had_toolbar Window.win_objects
  then
  (
    if gr_toolbar_callback (get_toolbar Window.win_objects) Event
    then ()
    else apply_to_list graph_obj_callback Event Window.win_objects
  )
  else apply_to_list graph_obj_callback Event Window.win_objects
;;


let std_main_loop Windows =
  let windows = Windows @ [ gr_helpw_window ] in
    set_main_windows windows;
    match Windows with
        []   ->
          close_graph();
          exit 0
      | x::y ->
          create_window x.win_def;
  
    while true do
      let Event = get_event_list !use_time_flag in
        let Window=(which_window windows Event.win) in
        (
          match Event.id_event with
            Redraw -> draw_window Window
          | Close  -> Window.win_def.win_state <- Destroyed
          | Time   -> Window.time_callback Window Event; ()
          | Key_pressed -> if Event.key = F1_key
                           then open_help Window.help_file
                           else deal_event Event Window
          | _      -> deal_event Event Window
        )
    done
;;




let std_block_loop Window =
  let Windows=get_main_windows () in
  create_window Window.win_def;
  set_main_windows (Windows @ [ Window ]);
  let block_id=(Window.win_def.win_id) in
  while Window.win_def.win_state=Created do
    let Event = get_event_list !use_time_flag in
      if Event.win=block_id
      then
        (
          match Event.id_event with
            Redraw -> draw_window Window
          | Close  -> Window.win_def.win_state <- Destroyed
          | Time   -> Window.time_callback Window Event; ()
          | Key_pressed -> if Event.key = F1_key
                           then open_help Window.help_file
                           else deal_event Event Window
          | _      -> deal_event Event Window
        )
      else
      (
        let Win=(which_window Windows Event.win) in
          match Event.id_event with
            Redraw -> draw_window Win
          | Close  -> Win.win_def.win_state <- Destroyed
          | Time   -> Win.time_callback Window Event; ()
          | _      -> ()
      )
  done;
  set_main_windows Windows
;;






let main_loop Windows =
  if gr_debug ()
  then debug_main_loop Windows
  else std_main_loop Windows
;;

let block_loop Window =
  if gr_debug ()
  then debug_block_loop Window
  else std_block_loop Window
;;








