#open "sys";;
#open "windows";;
#open "camlwin";;

#open "g_global";;
#open "g_button";;
#open "g_string";;
#open "g_prompt";;
#open "g_mloop";;






let gr_minput_window_def =
{
  win_id = undef_window;
  win_top = 0;
  win_left = 0;
  win_width = 0;
  win_height = 0;
  win_name = "Input";
  win_state=Destroyed
};;

let gr_minput_OK =
{
  bt_window=gr_minput_window_def;
  bt_left=0;
  bt_top=20;
  bt_width=25;
  bt_height=15;
  bt_name=string_type "Ok";
  bt_state=Up;
  bt_callback= do_nothing
};;


let gr_minput_prompt=
{
  pt_window=gr_minput_window_def;
  pt_left=5;
  pt_top=37;
  pt_name="Name:"
};;

let gr_minput_window =
{
  win_def=gr_minput_window_def;
  win_objects=[ g_button gr_minput_OK;
                g_prompt gr_minput_prompt
              ];
  time_callback = do_nothing;
  resize_callback = do_nothing;
  help_file = "";
  miscellaneous = [| |]
};;




let rec gr_close_input Obj_graph Event =
  erase_window gr_minput_window.win_def;;

gr_minput_OK.bt_callback <- gr_close_input;;


let gr_minput_text =
{
  st_window=gr_minput_window_def;
  st_left= 0;
  st_top= 0;
  st_width=90;
  st_cursor=0;
  st_1st_char=0;
  st_name="";
  st_type=Gr_string;
  st_state=Edited;
  st_callback= do_nothing
};;


let make_minput_vect nb =
  let result = make_vect nb gr_minput_text in
    for i=1 to (nb-1) do
      result.(i) <- {
                      st_window=gr_minput_window_def;
                      st_left= 0;
                      st_top= 0;
                      st_width=90;
                      st_cursor=0;
                      st_1st_char=0;
                      st_name="";
                      st_type=Gr_string;
                      st_state=Edited;
                      st_callback= do_nothing
                    }
    done;
  result
;;


let make_mprompt_vect nb =
  let result = make_vect nb gr_minput_prompt in
    for i=1 to (nb-1) do
      result.(i) <- {
                      pt_window=gr_minput_window_def;
                      pt_left= 0;
                      pt_top= 0;
                      pt_name=""
                    }
    done;
  result
;;



let minput_list_of_vect StrVect PromptVect=
  let len = vect_length StrVect in
    let rec list_loop i =
      if i = len then []
      else (g_prompt PromptVect.(i)) :: (g_string StrVect.(i)) :: 
           list_loop (i+1)
    in
    list_loop 0
;;


let minput_make_result Obj =
  let len = vect_length Obj in
    let result = make_vect len (string_type "") in
      for i = 0 to (len -1) do
        match Obj.(i).st_type with
          Gr_string   -> result.(i) <- string_type Obj.(i).st_name
        | Gr_natural  -> result.(i) <- int_type (int_of_string Obj.(i).st_name)
        | Gr_int      -> result.(i) <- int_type (int_of_string Obj.(i).st_name)
        | Gr_hexa     -> result.(i) <- int_type (int_of_string Obj.(i).st_name)
        | Gr_float    -> result.(i) <- float_type 
                                        (float_of_string Obj.(i).st_name)
        | Gr_password -> result.(i) <- string_type Obj.(i).st_name
      done;
       result
;;


let max_name_width Init =
  let len = vect_length Init in
    let rec width_loop i max =
      if i = len 
      then max
      else
      (
        let width = fst (text_size Init.(i).minput_name) in
          if width > max 
          then width_loop (i+1) width
          else width_loop (i+1) max
      )
    in
      width_loop 0 0
;;

let melted_to_string Melted String_type =
  match String_type with 
    Gr_string   -> ( match Melted with
                       string_type str -> str
                     | int_type n      -> string_of_int n
                     | float_type p    -> string_of_float p
                     | bitmap_type _   -> ""
                     | bool_type b     -> if b then "true" else "false"
                   )
  | Gr_float    -> ( match Melted with
                       string_type str -> "0.0"
                     | int_type n      -> (string_of_int n) ^ ".0"
                     | float_type p    -> string_of_float p
                     | bitmap_type _   -> "0.0"
                     | bool_type b     -> if b then "1.0" else "0.0"
                   )
  | Gr_password -> ( match Melted with
                       string_type str -> str
                     | int_type n      -> string_of_int n
                     | float_type p    -> string_of_float p
                     | bitmap_type _   -> ""
                     | bool_type b     -> if b then "true" else "false"
                   )
  | _           -> ( match Melted with
                       string_type str -> "0"
                     | int_type n      -> string_of_int n
                     | float_type p    -> string_of_float p
                     | bitmap_type _   -> ""
                     | bool_type b     -> if b then "1" else "0"
                   )
;;



(***************************************************************************)
(*                                                                         *)
(* minput : string -> minput_type vect -> melted_type vect                 *)
(*                                                                         *)
(***************************************************************************)
let minput_delta = 8;;
let minput_button_h = 30;;
let minput_width = 90;;

let minput Title Init =
  let len = vect_length Init in
    let height = (len+1) * minput_delta + minput_button_h 
    and width = (to_win_coord (max_name_width Init)) + minput_width + 15 
    and pos = 10 + (to_win_coord (max_name_width Init)) in

      gr_minput_window_def.win_width <- width;
      gr_minput_window_def.win_height <- height;

      gr_minput_window_def.win_top <- 
         ((screen_height() + (to_real_coord height))/2);

      gr_minput_window_def.win_left <- 
         ((screen_width() + (to_real_coord width))/2);


      gr_minput_prompt.pt_top <- height - 5;
      gr_minput_prompt.pt_name <- Title;
      gr_minput_OK.bt_left <- (width-25)/2;

    let input_vect= make_minput_vect len in
      for i = 0 to (len-1) do
      (
        input_vect.(i).st_left <- pos;
        input_vect.(i).st_top <- height - minput_delta * (i + 1);
        input_vect.(i).st_width <- minput_width;
        input_vect.(i).st_cursor <- 0;
        input_vect.(i).st_callback <- gr_close_input;
        input_vect.(i).st_state <- Editable;
        input_vect.(i).st_type <- Init.(i).minput_type;
        input_vect.(i).st_name <- melted_to_string Init.(i).minput_init
                                                   Init.(i).minput_type;
        input_vect.(i).st_1st_char <- 0;
        input_vect.(i).st_cursor <- 0
      )
      done;
      input_vect.(0).st_state <- Edited;

    let prompt_vect= make_mprompt_vect len in
      for i = 0 to (len-1) do
      (
        prompt_vect.(i).pt_left <- 5;
        prompt_vect.(i).pt_top <- height - minput_delta * (i + 1) - 2;
        prompt_vect.(i).pt_name <- Init.(i).minput_name
      )
      done;

      gr_minput_window.win_objects <- [ g_button gr_minput_OK;
                                        g_prompt gr_minput_prompt
                                      ] @ (minput_list_of_vect input_vect 
                                                               prompt_vect );

      block_loop gr_minput_window;

  minput_make_result input_vect
;;




let string_of_melted str =
  match str with
    string_type Str -> Str
  | _ -> ""
;;

let int_of_melted x =
  match x with
    int_type n -> n
  | _ -> 0
;;


let float_of_melted y =
  match y with
    float_type x -> x
  | _ -> 0.0
;;


let bool_of_melted b =
  match b with
    bool_type v -> v
  | _ -> false
;;


let image_of_melted img =
  match img with
    bitmap_type i -> i
  | _ -> empty_image
;;
